/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.phoenix;

import com.google.common.base.Preconditions;
import com.google.inject.Binder;
import com.google.inject.Scopes;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.prestosql.plugin.jdbc.JdbcClient;
import io.prestosql.plugin.jdbc.JdbcPageSinkProvider;
import io.prestosql.plugin.jdbc.JdbcRecordSetProvider;
import io.prestosql.plugin.phoenix.PhoenixClient;
import io.prestosql.plugin.phoenix.PhoenixColumnProperties;
import io.prestosql.plugin.phoenix.PhoenixConfig;
import io.prestosql.plugin.phoenix.PhoenixErrorCode;
import io.prestosql.plugin.phoenix.PhoenixMetadata;
import io.prestosql.plugin.phoenix.PhoenixSplitManager;
import io.prestosql.plugin.phoenix.PhoenixTableProperties;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.connector.ConnectorPageSinkProvider;
import io.prestosql.spi.connector.ConnectorRecordSetProvider;
import io.prestosql.spi.connector.ConnectorSplitManager;
import io.prestosql.spi.type.TypeManager;
import java.sql.SQLException;
import org.apache.phoenix.jdbc.PhoenixDriver;

public class PhoenixClientModule
extends AbstractConfigurationAwareModule {
    private final TypeManager typeManager;

    public PhoenixClientModule(TypeManager typeManager) {
        this.typeManager = typeManager;
    }

    protected void setup(Binder binder) {
        binder.bind(ConnectorSplitManager.class).to(PhoenixSplitManager.class).in(Scopes.SINGLETON);
        binder.bind(ConnectorRecordSetProvider.class).to(JdbcRecordSetProvider.class).in(Scopes.SINGLETON);
        binder.bind(JdbcRecordSetProvider.class).in(Scopes.SINGLETON);
        binder.bind(ConnectorPageSinkProvider.class).to(JdbcPageSinkProvider.class).in(Scopes.SINGLETON);
        binder.bind(PhoenixClient.class).in(Scopes.SINGLETON);
        binder.bind(JdbcClient.class).to(PhoenixClient.class).in(Scopes.SINGLETON);
        binder.bind(PhoenixMetadata.class).in(Scopes.SINGLETON);
        binder.bind(PhoenixTableProperties.class).in(Scopes.SINGLETON);
        binder.bind(PhoenixColumnProperties.class).in(Scopes.SINGLETON);
        binder.bind(TypeManager.class).toInstance((Object)this.typeManager);
        this.checkConfiguration(((PhoenixConfig)this.buildConfigObject(PhoenixConfig.class)).getConnectionUrl());
    }

    private void checkConfiguration(String connectionUrl) {
        try {
            PhoenixDriver driver = PhoenixDriver.INSTANCE;
            Preconditions.checkArgument((boolean)driver.acceptsURL(connectionUrl), (Object)"Invalid JDBC URL for Phoenix connector");
        }
        catch (SQLException e) {
            throw new PrestoException((ErrorCodeSupplier)PhoenixErrorCode.PHOENIX_CONFIG_ERROR, (Throwable)e);
        }
    }
}

