/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.phoenix;

import io.airlift.bootstrap.LifeCycleManager;
import io.airlift.log.Logger;
import io.prestosql.plugin.jdbc.JdbcTransactionHandle;
import io.prestosql.plugin.phoenix.PhoenixColumnProperties;
import io.prestosql.plugin.phoenix.PhoenixTableProperties;
import io.prestosql.spi.connector.Connector;
import io.prestosql.spi.connector.ConnectorMetadata;
import io.prestosql.spi.connector.ConnectorPageSinkProvider;
import io.prestosql.spi.connector.ConnectorRecordSetProvider;
import io.prestosql.spi.connector.ConnectorSplitManager;
import io.prestosql.spi.connector.ConnectorTransactionHandle;
import io.prestosql.spi.session.PropertyMetadata;
import io.prestosql.spi.transaction.IsolationLevel;
import java.util.List;
import java.util.Objects;

public class PhoenixConnector
implements Connector {
    private static final Logger log = Logger.get(PhoenixConnector.class);
    private final LifeCycleManager lifeCycleManager;
    private final ConnectorMetadata metadata;
    private final ConnectorSplitManager splitManager;
    private final ConnectorRecordSetProvider recordSetProvider;
    private final ConnectorPageSinkProvider pageSinkProvider;
    private final PhoenixTableProperties tableProperties;
    private final PhoenixColumnProperties columnProperties;

    public PhoenixConnector(LifeCycleManager lifeCycleManager, ConnectorMetadata metadata, ConnectorSplitManager splitManager, ConnectorRecordSetProvider recordSetProvider, ConnectorPageSinkProvider pageSinkProvider, PhoenixTableProperties tableProperties, PhoenixColumnProperties columnProperties) {
        this.lifeCycleManager = Objects.requireNonNull(lifeCycleManager, "lifeCycleManager is null");
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.splitManager = Objects.requireNonNull(splitManager, "splitManager is null");
        this.recordSetProvider = Objects.requireNonNull(recordSetProvider, "recordSetProvider is null");
        this.pageSinkProvider = Objects.requireNonNull(pageSinkProvider, "pageSinkProvider is null");
        this.tableProperties = Objects.requireNonNull(tableProperties, "tableProperties is null");
        this.columnProperties = Objects.requireNonNull(columnProperties, "columnProperties is null");
    }

    public ConnectorTransactionHandle beginTransaction(IsolationLevel isolationLevel, boolean readOnly) {
        return new JdbcTransactionHandle();
    }

    public ConnectorMetadata getMetadata(ConnectorTransactionHandle transaction) {
        return this.metadata;
    }

    public ConnectorSplitManager getSplitManager() {
        return this.splitManager;
    }

    public ConnectorRecordSetProvider getRecordSetProvider() {
        return this.recordSetProvider;
    }

    public ConnectorPageSinkProvider getPageSinkProvider() {
        return this.pageSinkProvider;
    }

    public List<PropertyMetadata<?>> getTableProperties() {
        return this.tableProperties.getTableProperties();
    }

    public List<PropertyMetadata<?>> getColumnProperties() {
        return this.columnProperties.getColumnProperties();
    }

    public final void shutdown() {
        try {
            this.lifeCycleManager.stop();
        }
        catch (Exception e) {
            log.error((Throwable)e, "Error shutting down connector");
        }
    }
}

