/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.phoenix;

import com.google.common.collect.ImmutableMap;
import io.airlift.log.Logger;
import io.airlift.tpch.TpchTable;
import io.prestosql.Session;
import io.prestosql.metadata.QualifiedObjectName;
import io.prestosql.plugin.phoenix.PhoenixPlugin;
import io.prestosql.plugin.phoenix.TestingPhoenixServer;
import io.prestosql.plugin.tpch.TpchPlugin;
import io.prestosql.spi.Plugin;
import io.prestosql.testing.QueryRunner;
import io.prestosql.testing.TestingSession;
import io.prestosql.tests.DistributedQueryRunner;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import java.util.Properties;

public final class PhoenixQueryRunner {
    private static final Logger LOG = Logger.get(PhoenixQueryRunner.class);
    private static final String TPCH_SCHEMA = "tpch";

    private PhoenixQueryRunner() {
    }

    public static QueryRunner createPhoenixQueryRunner(TestingPhoenixServer server) throws Exception {
        DistributedQueryRunner queryRunner = DistributedQueryRunner.builder((Session)PhoenixQueryRunner.createSession()).build();
        queryRunner.installPlugin((Plugin)new TpchPlugin());
        queryRunner.createCatalog(TPCH_SCHEMA, TPCH_SCHEMA);
        ImmutableMap properties = ImmutableMap.builder().put((Object)"phoenix.connection-url", (Object)server.getJdbcUrl()).put((Object)"case-insensitive-name-matching", (Object)"true").build();
        queryRunner.installPlugin((Plugin)new PhoenixPlugin());
        queryRunner.createCatalog("phoenix", "phoenix", (Map)properties);
        if (!server.isTpchLoaded()) {
            PhoenixQueryRunner.createSchema(server, TPCH_SCHEMA);
            PhoenixQueryRunner.copyTpchTables((QueryRunner)queryRunner, TPCH_SCHEMA, "tiny", PhoenixQueryRunner.createSession(), TpchTable.getTables());
            server.setTpchLoaded();
        } else {
            server.waitTpchLoaded();
        }
        return queryRunner;
    }

    private static void createSchema(TestingPhoenixServer phoenixServer, String schema) throws SQLException {
        Properties properties = new Properties();
        properties.put("phoenix.schema.isNamespaceMappingEnabled", "true");
        try (Connection connection = DriverManager.getConnection(phoenixServer.getJdbcUrl(), properties);
             Statement statement = connection.createStatement();){
            statement.execute(String.format("CREATE SCHEMA %s", schema));
        }
    }

    private static void copyTpchTables(QueryRunner queryRunner, String sourceCatalog, String sourceSchema, Session session, Iterable<TpchTable<?>> tables) {
        LOG.debug("Loading data from %s.%s...", new Object[]{sourceCatalog, sourceSchema});
        for (TpchTable<?> table : tables) {
            PhoenixQueryRunner.copyTable(queryRunner, sourceCatalog, session, sourceSchema, table);
        }
    }

    private static void copyTable(QueryRunner queryRunner, String catalog, Session session, String schema, TpchTable<?> table) {
        QualifiedObjectName source = new QualifiedObjectName(catalog, schema, table.getTableName());
        String target = table.getTableName();
        String tableProperties = "";
        if (TpchTable.LINE_ITEM.getTableName().equals(target)) {
            tableProperties = "WITH (ROWKEYS = 'ORDERKEY,LINENUMBER', SALT_BUCKETS=10)";
        } else if (TpchTable.ORDERS.getTableName().equals(target)) {
            tableProperties = "WITH (SALT_BUCKETS=10)";
        } else if (TpchTable.PART_SUPPLIER.getTableName().equals(target)) {
            tableProperties = "WITH (ROWKEYS = 'PARTKEY,SUPPKEY')";
        }
        String sql = String.format("CREATE TABLE %s %s AS SELECT * FROM %s", target, tableProperties, source);
        LOG.debug("Running import for %s %s", new Object[]{target, sql});
        long rows = queryRunner.execute(session, sql).getUpdateCount().getAsLong();
        LOG.debug("%s rows loaded into %s", new Object[]{rows, target});
    }

    private static Session createSession() {
        return TestingSession.testSessionBuilder().setCatalog("phoenix").setSchema(TPCH_SCHEMA).build();
    }
}

