/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.phoenix;

import com.google.common.collect.ImmutableMap;
import io.airlift.configuration.testing.ConfigAssertions;
import io.airlift.units.Duration;
import io.prestosql.plugin.phoenix.PhoenixConfig;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.testng.annotations.Test;

public class TestPhoenixConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((PhoenixConfig)ConfigAssertions.recordDefaults(PhoenixConfig.class)).setConnectionUrl(null).setResourceConfigFiles("").setCaseInsensitiveNameMatching(false).setCaseInsensitiveNameMatchingCacheTtl(new Duration(1.0, TimeUnit.MINUTES)));
    }

    @Test
    public void testExplicitPropertyMappings() {
        ImmutableMap properties = new ImmutableMap.Builder().put((Object)"phoenix.connection-url", (Object)"jdbc:phoenix:localhost:2181:/hbase").put((Object)"phoenix.config.resources", (Object)"/hbase-site.xml").put((Object)"case-insensitive-name-matching", (Object)"true").put((Object)"case-insensitive-name-matching.cache-ttl", (Object)"1s").build();
        PhoenixConfig expected = new PhoenixConfig().setConnectionUrl("jdbc:phoenix:localhost:2181:/hbase").setResourceConfigFiles("/hbase-site.xml").setCaseInsensitiveNameMatching(true).setCaseInsensitiveNameMatchingCacheTtl(new Duration(1.0, TimeUnit.SECONDS));
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }
}

