/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.phoenix;

import io.prestosql.plugin.phoenix.PhoenixQueryRunner;
import io.prestosql.plugin.phoenix.TestingPhoenixServer;
import io.prestosql.tests.AbstractTestDistributedQueries;
import org.testng.SkipException;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

@Test
public class TestPhoenixDistributedQueries
extends AbstractTestDistributedQueries {
    public TestPhoenixDistributedQueries() {
        this(TestingPhoenixServer.getInstance());
    }

    public TestPhoenixDistributedQueries(TestingPhoenixServer server) {
        super(() -> PhoenixQueryRunner.createPhoenixQueryRunner(server));
    }

    @AfterClass(alwaysRun=true)
    public void destroy() {
        TestingPhoenixServer.shutDown();
    }

    protected boolean supportsViews() {
        return false;
    }

    protected boolean supportsArrays() {
        return false;
    }

    public void testLargeIn() {
        throw new SkipException("test disabled");
    }

    public void testRenameTable() {
    }

    public void testRenameColumn() {
    }

    public void testDelete() {
    }

    public void testInsert() {
        String query = "SELECT orderdate, orderkey, totalprice FROM orders";
        this.assertUpdate("CREATE TABLE test_insert WITH (ROWKEYS='orderkey') AS " + query + " WITH NO DATA", 0L);
        this.assertQuery("SELECT count(*) FROM test_insert", "SELECT 0");
        this.assertUpdate("INSERT INTO test_insert " + query, "SELECT count(*) FROM orders");
        this.assertQuery("SELECT * FROM test_insert", query);
        this.assertUpdate("INSERT INTO test_insert (orderkey) VALUES (-1)", 1L);
        this.assertUpdate("INSERT INTO test_insert (orderkey) VALUES (-1)", 1L);
        this.assertUpdate("INSERT INTO test_insert (orderkey) VALUES (-2)", 1L);
        this.assertUpdate("INSERT INTO test_insert (orderkey, orderdate) VALUES (-3, DATE '2001-01-01')", 1L);
        this.assertUpdate("INSERT INTO test_insert (orderkey, orderdate) VALUES (-4, DATE '2001-01-02')", 1L);
        this.assertUpdate("INSERT INTO test_insert (orderdate, orderkey) VALUES (DATE '2001-01-03', -5)", 1L);
        this.assertUpdate("INSERT INTO test_insert (orderkey, totalprice) VALUES (-6, 1234)", 1L);
        this.assertQuery("SELECT * FROM test_insert", query + " UNION ALL SELECT null, -1, null UNION ALL SELECT null, -2, null UNION ALL SELECT DATE '2001-01-01', -3, null UNION ALL SELECT DATE '2001-01-02', -4, null UNION ALL SELECT DATE '2001-01-03', -5, null UNION ALL SELECT null, -6, 1234");
        this.assertUpdate("INSERT INTO test_insert (orderkey, orderdate, totalprice) SELECT orderkey, orderdate, totalprice FROM orders UNION ALL SELECT orderkey, orderdate, totalprice FROM orders", "SELECT 2 * count(*) FROM orders");
        this.assertUpdate("DROP TABLE test_insert");
    }

    public void testCommentTable() {
        this.assertQueryFails("COMMENT ON TABLE orders IS 'hello'", "This connector does not support setting table comments");
    }
}

