/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.phoenix;

import io.prestosql.plugin.phoenix.PhoenixQueryRunner;
import io.prestosql.plugin.phoenix.TestingPhoenixServer;
import io.prestosql.tests.AbstractTestIntegrationSmokeTest;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

@Test
public class TestPhoenixIntegrationSmokeTest
extends AbstractTestIntegrationSmokeTest {
    private TestingPhoenixServer testingPhoenixServer;

    public TestPhoenixIntegrationSmokeTest() {
        this(TestingPhoenixServer.getInstance());
    }

    public TestPhoenixIntegrationSmokeTest(TestingPhoenixServer server) {
        super(() -> PhoenixQueryRunner.createPhoenixQueryRunner(server));
        this.testingPhoenixServer = server;
    }

    @AfterClass(alwaysRun=true)
    public void destroy() {
        TestingPhoenixServer.shutDown();
    }

    @Test
    public void testSchemaOperations() {
        this.assertUpdate("CREATE SCHEMA new_schema");
        this.assertUpdate("CREATE TABLE new_schema.test (x bigint)");
        try {
            this.getQueryRunner().execute("DROP SCHEMA new_schema");
            Assert.fail((String)"Should not be able to drop non-empty schema");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        this.assertUpdate("DROP TABLE new_schema.test");
        this.assertUpdate("DROP SCHEMA new_schema");
    }

    @Test
    public void testMultipleSomeColumnsRangesPredicate() {
        this.assertQuery("SELECT orderkey, shippriority, clerk, totalprice, custkey FROM orders WHERE orderkey BETWEEN 10 AND 50 OR orderkey BETWEEN 100 AND 150");
    }

    @Test
    public void testCreateTableWithProperties() {
        this.assertUpdate("CREATE TABLE test_create_table_with_properties (created_date date, a bigint, b double, c varchar(10), d varchar(10)) WITH(rowkeys = 'created_date row_timestamp,a,b,c', salt_buckets=10)");
        Assert.assertTrue((boolean)this.getQueryRunner().tableExists(this.getSession(), "test_create_table_with_properties"));
        this.assertTableColumnNames("test_create_table_with_properties", new String[]{"created_date", "a", "b", "c", "d"});
        this.assertUpdate("DROP TABLE test_create_table_with_properties");
    }

    @Test
    public void testCreateTableWithPresplits() {
        this.assertUpdate("CREATE TABLE test_create_table_with_presplits (rid varchar(10), val1 varchar(10)) with(rowkeys = 'rid', SPLIT_ON='\"1\",\"2\",\"3\"')");
        Assert.assertTrue((boolean)this.getQueryRunner().tableExists(this.getSession(), "test_create_table_with_presplits"));
        this.assertTableColumnNames("test_create_table_with_presplits", new String[]{"rid", "val1"});
        this.assertUpdate("DROP TABLE test_create_table_with_presplits");
    }

    @Test
    public void testSecondaryIndex() throws Exception {
        this.assertUpdate("CREATE TABLE test_primary_table (pk bigint, val1 double, val2 double, val3 double) with(rowkeys = 'pk')");
        this.executeInPhoenix("CREATE LOCAL INDEX test_local_index ON tpch.test_primary_table (val1)");
        this.executeInPhoenix("CREATE INDEX test_global_index ON tpch.test_primary_table (val2)");
        this.assertUpdate("INSERT INTO test_primary_table VALUES (1, 1.1, 1.2, 1.3)", 1L);
        this.assertQuery("SELECT val1,val3 FROM test_primary_table where val1 < 1.2", "SELECT 1.1,1.3");
        this.assertQuery("SELECT val2,val3 FROM test_primary_table where val2 < 1.3", "SELECT 1.2,1.3");
        this.assertUpdate("DROP TABLE test_primary_table");
    }

    @Test
    public void testCaseInsensitiveNameMatching() throws Exception {
        this.executeInPhoenix("CREATE TABLE tpch.\"TestCaseInsensitive\" (\"pK\" bigint primary key, \"Val1\" double)");
        this.assertUpdate("INSERT INTO testcaseinsensitive VALUES (1, 1.1)", 1L);
        this.assertQuery("SELECT Val1 FROM testcaseinsensitive where Val1 < 1.2", "SELECT 1.1");
    }

    private void executeInPhoenix(String sql) throws SQLException {
        try (Connection connection = DriverManager.getConnection(this.testingPhoenixServer.getJdbcUrl());
             Statement statement = connection.createStatement();){
            statement.execute(sql);
        }
    }
}

