/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.phoenix;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import io.airlift.json.ObjectMapperProvider;
import io.prestosql.plugin.phoenix.PhoenixSplit;
import io.prestosql.plugin.phoenix.WrappedPhoenixInputSplit;
import io.prestosql.spi.HostAddress;
import io.prestosql.spi.predicate.TupleDomain;
import java.util.Collection;
import java.util.List;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.mapreduce.PhoenixInputSplit;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test
public class TestPhoenixSplit {
    private final ObjectMapper objectMapper = new ObjectMapperProvider().get();

    @Test
    public void testPhoenixSplitJsonRoundtrip() throws Exception {
        ImmutableList addresses = ImmutableList.of((Object)HostAddress.fromString((String)"host:9000"));
        ImmutableList scans = ImmutableList.of((Object)new Scan().withStartRow(Bytes.toBytes((String)"A")).withStopRow(Bytes.toBytes((String)"Z")));
        PhoenixInputSplit phoenixInputSplit = new PhoenixInputSplit((List)scans);
        PhoenixSplit expected = new PhoenixSplit((List)addresses, new WrappedPhoenixInputSplit(phoenixInputSplit), TupleDomain.all());
        Assert.assertTrue((boolean)this.objectMapper.canSerialize(PhoenixSplit.class));
        String json = this.objectMapper.writeValueAsString((Object)expected);
        PhoenixSplit actual = (PhoenixSplit)this.objectMapper.readValue(json, PhoenixSplit.class);
        Assert.assertEquals((Object)actual.getPhoenixInputSplit(), (Object)expected.getPhoenixInputSplit());
        Assert.assertEquals((Collection)actual.getAddresses(), (Collection)expected.getAddresses());
        Assert.assertEquals((Object)actual.getConstraint(), (Object)expected.getConstraint());
    }
}

