/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.phoenix;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.io.BaseEncoding;
import io.prestosql.Session;
import io.prestosql.plugin.phoenix.PhoenixQueryRunner;
import io.prestosql.plugin.phoenix.PhoenixSqlExecutor;
import io.prestosql.plugin.phoenix.TestingPhoenixServer;
import io.prestosql.spi.type.ArrayType;
import io.prestosql.spi.type.DateType;
import io.prestosql.spi.type.DecimalType;
import io.prestosql.spi.type.IntegerType;
import io.prestosql.spi.type.TimeZoneKey;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarbinaryType;
import io.prestosql.tests.AbstractTestQueryFramework;
import io.prestosql.tests.datatype.CreateAndInsertDataSetup;
import io.prestosql.tests.datatype.CreateAsSelectDataSetup;
import io.prestosql.tests.datatype.DataSetup;
import io.prestosql.tests.datatype.DataType;
import io.prestosql.tests.datatype.DataTypeTest;
import io.prestosql.tests.sql.PrestoSqlExecutor;
import io.prestosql.tests.sql.SqlExecutor;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

@Test
public class TestPhoenixSqlTypeMapping
extends AbstractTestQueryFramework {
    private final TestingPhoenixServer phoenixServer;

    public TestPhoenixSqlTypeMapping() {
        this(TestingPhoenixServer.getInstance());
    }

    private TestPhoenixSqlTypeMapping(TestingPhoenixServer phoenixServer) {
        super(() -> PhoenixQueryRunner.createPhoenixQueryRunner(phoenixServer));
        this.phoenixServer = phoenixServer;
    }

    @AfterClass(alwaysRun=true)
    public void destroy() {
        TestingPhoenixServer.shutDown();
    }

    @Test
    public void testBasicTypes() {
        DataTypeTest.create().addRoundTrip(DataType.booleanDataType(), (Object)true).addRoundTrip(DataType.booleanDataType(), (Object)false).addRoundTrip(DataType.bigintDataType(), (Object)123456789012L).addRoundTrip(DataType.integerDataType(), (Object)1234567890).addRoundTrip(DataType.smallintDataType(), (Object)32456).addRoundTrip(DataType.tinyintDataType(), (Object)5).addRoundTrip(DataType.doubleDataType(), (Object)123.45).addRoundTrip(DataType.realDataType(), (Object)Float.valueOf(123.45f)).execute(this.getQueryRunner(), this.prestoCreateAsSelect("test_basic_types"));
    }

    @Test
    public void testVarbinary() {
        this.varbinaryTestCases((DataType<byte[]>)DataType.varbinaryDataType()).execute(this.getQueryRunner(), this.prestoCreateAsSelect("test_varbinary"));
        this.varbinaryTestCases(TestPhoenixSqlTypeMapping.phoenixVarbinaryDataType()).addRoundTrip(this.primaryKey(), (Object)1).execute(this.getQueryRunner(), this.phoenixCreateAndInsert("tpch.test_varbinary"));
    }

    public static DataType<byte[]> phoenixVarbinaryDataType() {
        return DataType.dataType((String)"varbinary", (Type)VarbinaryType.VARBINARY, value -> String.format("DECODE('%s', 'HEX')", BaseEncoding.base16().encode(value)), Function.identity());
    }

    private DataTypeTest varbinaryTestCases(DataType<byte[]> varbinaryDataType) {
        return DataTypeTest.create().addRoundTrip(varbinaryDataType, (Object)"hello".getBytes(StandardCharsets.UTF_8)).addRoundTrip(varbinaryDataType, (Object)"Pi\u0119kna \u0142\u0105ka w \u6771\u4eac\u90fd".getBytes(StandardCharsets.UTF_8)).addRoundTrip(varbinaryDataType, (Object)"Bag full of \ud83d\udcb0".getBytes(StandardCharsets.UTF_16LE)).addRoundTrip(varbinaryDataType, null).addRoundTrip(varbinaryDataType, (Object)new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 13, -7, 54, 122, -89, 0, 0, 0});
    }

    @Test
    public void testVarchar() {
        DataTypeTest varcharTypeTest = this.stringDataTypeTest(DataType::varcharDataType).addRoundTrip(DataType.varcharDataType((int)0xA00000), (Object)"text_f").addRoundTrip(DataType.varcharDataType(), (Object)"unbounded");
        varcharTypeTest.execute(this.getQueryRunner(), this.prestoCreateAsSelect("test_varchar"));
        varcharTypeTest.addRoundTrip(this.primaryKey(), (Object)1).execute(this.getQueryRunner(), this.phoenixCreateAndInsert("tpch.test_varchar"));
    }

    private DataTypeTest stringDataTypeTest(Function<Integer, DataType<String>> dataTypeFactory) {
        return DataTypeTest.create().addRoundTrip(dataTypeFactory.apply(10), (Object)"text_a").addRoundTrip(dataTypeFactory.apply(255), (Object)"text_b").addRoundTrip(dataTypeFactory.apply(65535), (Object)"text_d");
    }

    @Test
    public void testChar() {
        this.stringDataTypeTest(DataType::charDataType).execute(this.getQueryRunner(), this.prestoCreateAsSelect("test_char"));
        this.stringDataTypeTest(DataType::charDataType).addRoundTrip(this.primaryKey(), (Object)1).execute(this.getQueryRunner(), this.phoenixCreateAndInsert("tpch.test_char"));
    }

    @Test
    public void testDecimal() {
        this.decimalTests(DataType::decimalDataType).execute(this.getQueryRunner(), this.prestoCreateAsSelect("test_decimal"));
        this.decimalTests(TestPhoenixSqlTypeMapping::phoenixDecimalDataType).addRoundTrip(this.primaryKey(), (Object)1).execute(this.getQueryRunner(), this.phoenixCreateAndInsert("tpch.test_decimal"));
    }

    private DataTypeTest decimalTests(BiFunction<Integer, Integer, DataType<BigDecimal>> dataTypeFactory) {
        return DataTypeTest.create().addRoundTrip(dataTypeFactory.apply(3, 0), (Object)new BigDecimal("193")).addRoundTrip(dataTypeFactory.apply(3, 0), (Object)new BigDecimal("19")).addRoundTrip(dataTypeFactory.apply(3, 0), (Object)new BigDecimal("-193")).addRoundTrip(dataTypeFactory.apply(3, 1), (Object)new BigDecimal("10.0")).addRoundTrip(dataTypeFactory.apply(3, 1), (Object)new BigDecimal("10.1")).addRoundTrip(dataTypeFactory.apply(3, 1), (Object)new BigDecimal("-10.1")).addRoundTrip(dataTypeFactory.apply(4, 2), (Object)new BigDecimal("2")).addRoundTrip(dataTypeFactory.apply(4, 2), (Object)new BigDecimal("2.3")).addRoundTrip(dataTypeFactory.apply(24, 2), (Object)new BigDecimal("2")).addRoundTrip(dataTypeFactory.apply(24, 2), (Object)new BigDecimal("2.3")).addRoundTrip(dataTypeFactory.apply(24, 2), (Object)new BigDecimal("123456789.3")).addRoundTrip(dataTypeFactory.apply(24, 4), (Object)new BigDecimal("12345678901234567890.31")).addRoundTrip(dataTypeFactory.apply(30, 5), (Object)new BigDecimal("3141592653589793238462643.38327")).addRoundTrip(dataTypeFactory.apply(30, 5), (Object)new BigDecimal("-3141592653589793238462643.38327")).addRoundTrip(dataTypeFactory.apply(38, 0), (Object)new BigDecimal("27182818284590452353602874713526624977")).addRoundTrip(dataTypeFactory.apply(38, 0), (Object)new BigDecimal("-27182818284590452353602874713526624977"));
    }

    private static DataType<BigDecimal> phoenixDecimalDataType(int precision, int scale) {
        String databaseType = String.format("decimal(%s, %s)", precision, scale);
        return DataType.dataType((String)databaseType, (Type)DecimalType.createDecimalType((int)precision, (int)scale), bigDecimal -> String.format("CAST(%s AS %s)", bigDecimal, databaseType), bigDecimal -> bigDecimal.setScale(scale, RoundingMode.UNNECESSARY));
    }

    @Test
    public void testDate() {
        ZoneId jvmZone = ZoneId.systemDefault();
        Preconditions.checkState((boolean)jvmZone.getId().equals("America/Bahia_Banderas"), (Object)"This test assumes certain JVM time zone");
        LocalDate dateOfLocalTimeChangeForwardAtMidnightInJvmZone = LocalDate.of(1970, 1, 1);
        TestPhoenixSqlTypeMapping.checkIsGap(jvmZone, dateOfLocalTimeChangeForwardAtMidnightInJvmZone.atStartOfDay());
        ZoneId someZone = ZoneId.of("Europe/Vilnius");
        LocalDate dateOfLocalTimeChangeForwardAtMidnightInSomeZone = LocalDate.of(1983, 4, 1);
        TestPhoenixSqlTypeMapping.checkIsGap(someZone, dateOfLocalTimeChangeForwardAtMidnightInSomeZone.atStartOfDay());
        LocalDate dateOfLocalTimeChangeBackwardAtMidnightInSomeZone = LocalDate.of(1983, 10, 1);
        TestPhoenixSqlTypeMapping.checkIsDoubled(someZone, dateOfLocalTimeChangeBackwardAtMidnightInSomeZone.atStartOfDay().minusMinutes(1L));
        DataTypeTest prestoTestCases = this.dateTests(dateOfLocalTimeChangeForwardAtMidnightInJvmZone, dateOfLocalTimeChangeForwardAtMidnightInSomeZone, dateOfLocalTimeChangeBackwardAtMidnightInSomeZone, (DataType<LocalDate>)DataType.dateDataType());
        DataTypeTest phoenixTestCases = this.dateTests(dateOfLocalTimeChangeForwardAtMidnightInJvmZone, dateOfLocalTimeChangeForwardAtMidnightInSomeZone, dateOfLocalTimeChangeBackwardAtMidnightInSomeZone, TestPhoenixSqlTypeMapping.phoenixDateDataType()).addRoundTrip(this.primaryKey(), (Object)1);
        for (String timeZoneId : ImmutableList.of((Object)TimeZoneKey.UTC_KEY.getId(), (Object)jvmZone.getId(), (Object)someZone.getId())) {
            Session session = Session.builder((Session)this.getQueryRunner().getDefaultSession()).setTimeZoneKey(TimeZoneKey.getTimeZoneKey((String)timeZoneId)).build();
            prestoTestCases.execute(this.getQueryRunner(), session, this.prestoCreateAsSelect("test_date"));
            phoenixTestCases.execute(this.getQueryRunner(), session, this.phoenixCreateAndInsert("tpch.test_date"));
        }
    }

    @Test
    public void testArray() {
        DataTypeTest.create().addRoundTrip(TestPhoenixSqlTypeMapping.arrayDataType(DataType.booleanDataType()), Arrays.asList(true, false)).addRoundTrip(TestPhoenixSqlTypeMapping.arrayDataType(DataType.bigintDataType()), Arrays.asList(123456789012L)).addRoundTrip(TestPhoenixSqlTypeMapping.arrayDataType(DataType.integerDataType()), Arrays.asList(1, 2, 1234567890)).addRoundTrip(TestPhoenixSqlTypeMapping.arrayDataType(DataType.smallintDataType()), Arrays.asList((short)32456)).addRoundTrip(TestPhoenixSqlTypeMapping.arrayDataType(DataType.doubleDataType()), Arrays.asList(123.45)).addRoundTrip(TestPhoenixSqlTypeMapping.arrayDataType(DataType.realDataType()), Arrays.asList(Float.valueOf(123.45f))).execute(this.getQueryRunner(), this.prestoCreateAsSelect("test_array_basic"));
        this.arrayDateTest(TestPhoenixSqlTypeMapping::arrayDataType, (DataType<LocalDate>)DataType.dateDataType()).execute(this.getQueryRunner(), this.prestoCreateAsSelect("test_array_date"));
        this.arrayDateTest(TestPhoenixSqlTypeMapping::phoenixArrayDataType, TestPhoenixSqlTypeMapping.phoenixDateDataType()).addRoundTrip(this.primaryKey(), (Object)1).execute(this.getQueryRunner(), this.phoenixCreateAndInsert("tpch.test_array_date"));
        this.arrayDecimalTest(TestPhoenixSqlTypeMapping::arrayDataType, DataType::decimalDataType).execute(this.getQueryRunner(), this.prestoCreateAsSelect("test_array_decimal"));
        this.arrayDecimalTest(TestPhoenixSqlTypeMapping::phoenixArrayDataType, TestPhoenixSqlTypeMapping::phoenixDecimalDataType).addRoundTrip(this.primaryKey(), (Object)1).execute(this.getQueryRunner(), this.phoenixCreateAndInsert("tpch.test_array_decimal"));
        this.arrayStringDataTypeTest(TestPhoenixSqlTypeMapping::arrayDataType, DataType::charDataType).execute(this.getQueryRunner(), this.prestoCreateAsSelect("test_array_char"));
        this.arrayStringDataTypeTest(TestPhoenixSqlTypeMapping::phoenixArrayDataType, DataType::charDataType).addRoundTrip(this.primaryKey(), (Object)1).execute(this.getQueryRunner(), this.phoenixCreateAndInsert("tpch.test_array_char"));
        this.arrayStringDataTypeTest(TestPhoenixSqlTypeMapping::arrayDataType, DataType::varcharDataType).addRoundTrip(TestPhoenixSqlTypeMapping.arrayDataType(DataType.varcharDataType((int)0xA00000)), Arrays.asList("text_f")).addRoundTrip(TestPhoenixSqlTypeMapping.arrayDataType(DataType.varcharDataType()), Arrays.asList("unbounded")).execute(this.getQueryRunner(), this.prestoCreateAsSelect("test_array_varchar"));
        this.arrayStringDataTypeTest(TestPhoenixSqlTypeMapping::phoenixArrayDataType, DataType::varcharDataType).addRoundTrip(TestPhoenixSqlTypeMapping.phoenixArrayDataType(DataType.varcharDataType((int)0xA00000)), Arrays.asList("text_f")).addRoundTrip(TestPhoenixSqlTypeMapping.phoenixArrayDataType(DataType.varcharDataType()), Arrays.asList("unbounded")).addRoundTrip(this.primaryKey(), (Object)1).execute(this.getQueryRunner(), this.phoenixCreateAndInsert("tpch.test_array_varchar"));
    }

    @Test
    public void testArrayNulls() {
        DataTypeTest.create().addRoundTrip(TestPhoenixSqlTypeMapping.arrayDataType(DataType.booleanDataType()), null).addRoundTrip(TestPhoenixSqlTypeMapping.arrayDataType(DataType.varcharDataType()), Collections.singletonList(null)).addRoundTrip(TestPhoenixSqlTypeMapping.arrayDataType(DataType.varcharDataType()), Arrays.asList("foo", null, "bar", null)).execute(this.getQueryRunner(), this.prestoCreateAsSelect("test_array_nulls"));
    }

    private DataTypeTest arrayDecimalTest(Function<DataType<BigDecimal>, DataType<List<BigDecimal>>> arrayTypeFactory, BiFunction<Integer, Integer, DataType<BigDecimal>> decimalTypeFactory) {
        return DataTypeTest.create().addRoundTrip(arrayTypeFactory.apply(decimalTypeFactory.apply(3, 0)), Arrays.asList(new BigDecimal("193"), new BigDecimal("19"), new BigDecimal("-193"))).addRoundTrip(arrayTypeFactory.apply(decimalTypeFactory.apply(3, 1)), Arrays.asList(new BigDecimal("10.0"), new BigDecimal("10.1"), new BigDecimal("-10.1"))).addRoundTrip(arrayTypeFactory.apply(decimalTypeFactory.apply(4, 2)), Arrays.asList(new BigDecimal("2"), new BigDecimal("2.3"))).addRoundTrip(arrayTypeFactory.apply(decimalTypeFactory.apply(24, 2)), Arrays.asList(new BigDecimal("2"), new BigDecimal("2.3"), new BigDecimal("123456789.3"))).addRoundTrip(arrayTypeFactory.apply(decimalTypeFactory.apply(24, 4)), Arrays.asList(new BigDecimal("12345678901234567890.31"))).addRoundTrip(arrayTypeFactory.apply(decimalTypeFactory.apply(30, 5)), Arrays.asList(new BigDecimal("3141592653589793238462643.38327"), new BigDecimal("-3141592653589793238462643.38327"))).addRoundTrip(arrayTypeFactory.apply(decimalTypeFactory.apply(38, 0)), Arrays.asList(new BigDecimal("27182818284590452353602874713526624977"), new BigDecimal("-27182818284590452353602874713526624977")));
    }

    private DataTypeTest arrayStringDataTypeTest(Function<DataType<String>, DataType<List<String>>> arrayTypeFactory, Function<Integer, DataType<String>> dataTypeFactory) {
        return DataTypeTest.create().addRoundTrip(arrayTypeFactory.apply(dataTypeFactory.apply(10)), Arrays.asList("text_a")).addRoundTrip(arrayTypeFactory.apply(dataTypeFactory.apply(255)), Arrays.asList("text_b")).addRoundTrip(arrayTypeFactory.apply(dataTypeFactory.apply(65535)), Arrays.asList("text_d"));
    }

    private DataTypeTest arrayDateTest(Function<DataType<LocalDate>, DataType<List<LocalDate>>> arrayTypeFactory, DataType<LocalDate> dateDataType) {
        ZoneId jvmZone = ZoneId.systemDefault();
        Preconditions.checkState((boolean)jvmZone.getId().equals("America/Bahia_Banderas"), (Object)"This test assumes certain JVM time zone");
        LocalDate dateOfLocalTimeChangeForwardAtMidnightInJvmZone = LocalDate.of(1970, 1, 1);
        TestPhoenixSqlTypeMapping.checkIsGap(jvmZone, dateOfLocalTimeChangeForwardAtMidnightInJvmZone.atStartOfDay());
        ZoneId someZone = ZoneId.of("Europe/Vilnius");
        LocalDate dateOfLocalTimeChangeForwardAtMidnightInSomeZone = LocalDate.of(1983, 4, 1);
        TestPhoenixSqlTypeMapping.checkIsGap(someZone, dateOfLocalTimeChangeForwardAtMidnightInSomeZone.atStartOfDay());
        LocalDate dateOfLocalTimeChangeBackwardAtMidnightInSomeZone = LocalDate.of(1983, 10, 1);
        TestPhoenixSqlTypeMapping.checkIsDoubled(someZone, dateOfLocalTimeChangeBackwardAtMidnightInSomeZone.atStartOfDay().minusMinutes(1L));
        return DataTypeTest.create().addRoundTrip(arrayTypeFactory.apply(dateDataType), Arrays.asList(LocalDate.of(1952, 4, 3))).addRoundTrip(arrayTypeFactory.apply(dateDataType), Arrays.asList(LocalDate.of(1970, 1, 1))).addRoundTrip(arrayTypeFactory.apply(dateDataType), Arrays.asList(LocalDate.of(1970, 2, 3))).addRoundTrip(arrayTypeFactory.apply(dateDataType), Arrays.asList(LocalDate.of(2017, 7, 1))).addRoundTrip(arrayTypeFactory.apply(dateDataType), Arrays.asList(LocalDate.of(2017, 1, 1))).addRoundTrip(arrayTypeFactory.apply(dateDataType), Arrays.asList(dateOfLocalTimeChangeForwardAtMidnightInJvmZone)).addRoundTrip(arrayTypeFactory.apply(dateDataType), Arrays.asList(dateOfLocalTimeChangeForwardAtMidnightInSomeZone)).addRoundTrip(arrayTypeFactory.apply(dateDataType), Arrays.asList(dateOfLocalTimeChangeBackwardAtMidnightInSomeZone));
    }

    private DataTypeTest dateTests(LocalDate dateOfLocalTimeChangeForwardAtMidnightInJvmZone, LocalDate dateOfLocalTimeChangeForwardAtMidnightInSomeZone, LocalDate dateOfLocalTimeChangeBackwardAtMidnightInSomeZone, DataType<LocalDate> dateDataType) {
        return DataTypeTest.create().addRoundTrip(dateDataType, (Object)LocalDate.of(1952, 4, 3)).addRoundTrip(dateDataType, (Object)LocalDate.of(1970, 1, 1)).addRoundTrip(dateDataType, (Object)LocalDate.of(1970, 2, 3)).addRoundTrip(dateDataType, (Object)LocalDate.of(2017, 7, 1)).addRoundTrip(dateDataType, (Object)LocalDate.of(2017, 1, 1)).addRoundTrip(dateDataType, (Object)dateOfLocalTimeChangeForwardAtMidnightInJvmZone).addRoundTrip(dateDataType, (Object)dateOfLocalTimeChangeForwardAtMidnightInSomeZone).addRoundTrip(dateDataType, (Object)dateOfLocalTimeChangeBackwardAtMidnightInSomeZone);
    }

    private static <E> DataType<List<E>> arrayDataType(DataType<E> elementType) {
        return TestPhoenixSqlTypeMapping.arrayDataType(elementType, String.format("ARRAY(%s)", elementType.getInsertType()));
    }

    private static <E> DataType<List<E>> phoenixArrayDataType(DataType<E> elementType) {
        return TestPhoenixSqlTypeMapping.arrayDataType(elementType, elementType.getInsertType() + " ARRAY");
    }

    private static <E> DataType<List<E>> arrayDataType(DataType<E> elementType, String insertType) {
        return DataType.dataType((String)insertType, (Type)new ArrayType(elementType.getPrestoResultType()), valuesList -> "ARRAY" + valuesList.stream().map(arg_0 -> ((DataType)elementType).toLiteral(arg_0)).collect(Collectors.toList()), valuesList -> valuesList == null ? null : valuesList.stream().map(arg_0 -> ((DataType)elementType).toPrestoQueryResult(arg_0)).collect(Collectors.toList()));
    }

    public static DataType<LocalDate> phoenixDateDataType() {
        return DataType.dataType((String)"date", (Type)DateType.DATE, value -> String.format("TO_DATE('%s', 'yyyy-MM-dd', 'local')", DateTimeFormatter.ofPattern("yyyy-MM-dd").format((TemporalAccessor)value)), Function.identity());
    }

    private static void checkIsGap(ZoneId zone, LocalDateTime dateTime) {
        Verify.verify((boolean)TestPhoenixSqlTypeMapping.isGap(zone, dateTime), (String)"Expected %s to be a gap in %s", (Object)dateTime, (Object)zone);
    }

    private static boolean isGap(ZoneId zone, LocalDateTime dateTime) {
        return zone.getRules().getValidOffsets(dateTime).isEmpty();
    }

    private static void checkIsDoubled(ZoneId zone, LocalDateTime dateTime) {
        Verify.verify((zone.getRules().getValidOffsets(dateTime).size() == 2 ? 1 : 0) != 0, (String)"Expected %s to be doubled in %s", (Object)dateTime, (Object)zone);
    }

    private DataType<Integer> primaryKey() {
        return DataType.dataType((String)"integer primary key", (Type)IntegerType.INTEGER, Object::toString, Function.identity());
    }

    private DataSetup prestoCreateAsSelect(String tableNamePrefix) {
        return new CreateAsSelectDataSetup((SqlExecutor)new PrestoSqlExecutor(this.getQueryRunner()), tableNamePrefix);
    }

    private DataSetup phoenixCreateAndInsert(String tableNamePrefix) {
        return new CreateAndInsertDataSetup((SqlExecutor)new PhoenixSqlExecutor(this.phoenixServer.getJdbcUrl()), tableNamePrefix);
    }
}

