/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.phoenix;

import io.airlift.log.Logger;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import javax.annotation.concurrent.GuardedBy;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.zookeeper.MiniZooKeeperCluster;
import org.apache.phoenix.shaded.org.apache.zookeeper.server.ZooKeeperServer;

public final class TestingPhoenixServer {
    private static final Logger LOG = Logger.get(TestingPhoenixServer.class);
    @GuardedBy(value="this")
    private static int referenceCount;
    @GuardedBy(value="this")
    private static TestingPhoenixServer instance;
    private HBaseTestingUtility hbaseTestingUtility;
    private final int port;
    private final Configuration conf = HBaseConfiguration.create();
    private final AtomicBoolean tpchLoaded = new AtomicBoolean();
    private final CountDownLatch tpchLoadComplete = new CountDownLatch(1);
    private final java.util.logging.Logger apacheLogger = java.util.logging.Logger.getLogger("org.apache");
    private final java.util.logging.Logger zookeeperLogger;
    private final java.util.logging.Logger securityLogger;

    public static synchronized TestingPhoenixServer getInstance() {
        if (referenceCount == 0) {
            instance = new TestingPhoenixServer();
        }
        ++referenceCount;
        return instance;
    }

    public static synchronized void shutDown() {
        if (--referenceCount == 0) {
            instance.shutdown();
            instance = null;
        }
    }

    private TestingPhoenixServer() {
        this.apacheLogger.setLevel(Level.SEVERE);
        this.zookeeperLogger = java.util.logging.Logger.getLogger(ZooKeeperServer.class.getName());
        this.zookeeperLogger.setLevel(Level.OFF);
        this.securityLogger = java.util.logging.Logger.getLogger("SecurityLogger.org.apache");
        this.securityLogger.setLevel(Level.SEVERE);
        LogFactory.getLog((String)"SecurityLogger.org.apache.hadoop.hbase.server");
        this.conf.set("hbase.security.logger", "ERROR");
        this.conf.setInt("hbase.master.info.port", -1);
        this.conf.setInt("hbase.regionserver.info.port", -1);
        this.conf.setInt("hbase.client.retries.number", 1);
        this.conf.setBoolean("phoenix.schema.isNamespaceMappingEnabled", true);
        this.conf.set("hbase.regionserver.wal.codec", "org.apache.hadoop.hbase.regionserver.wal.IndexedWALEditCodec");
        this.hbaseTestingUtility = new HBaseTestingUtility(this.conf);
        try {
            MiniZooKeeperCluster zkCluster = this.hbaseTestingUtility.startMiniZKCluster();
            this.port = zkCluster.getClientPort();
            MiniHBaseCluster hbaseCluster = this.hbaseTestingUtility.startMiniHBaseCluster(1, 4);
            hbaseCluster.waitForActiveAndReadyMaster();
            LOG.info("Phoenix server ready: %s", new Object[]{this.getJdbcUrl()});
        }
        catch (Exception e) {
            throw new RuntimeException("Can't start phoenix server.", e);
        }
    }

    private void shutdown() {
        if (this.hbaseTestingUtility == null) {
            return;
        }
        try {
            LOG.info("Shutting down HBase cluster.");
            this.hbaseTestingUtility.shutdownMiniHBaseCluster();
            this.hbaseTestingUtility.shutdownMiniZKCluster();
        }
        catch (IOException e) {
            Thread.currentThread().interrupt();
            throw new UncheckedIOException("Failed to shutdown HBaseTestingUtility instance", e);
        }
        this.hbaseTestingUtility = null;
    }

    public String getJdbcUrl() {
        return String.format("jdbc:phoenix:localhost:%d:/hbase;phoenix.schema.isNamespaceMappingEnabled=true", this.port);
    }

    public boolean isTpchLoaded() {
        return this.tpchLoaded.getAndSet(true);
    }

    public void setTpchLoaded() {
        this.tpchLoadComplete.countDown();
    }

    public void waitTpchLoaded() throws InterruptedException {
        this.tpchLoadComplete.await(2L, TimeUnit.MINUTES);
    }
}

