/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.phoenix;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import io.airlift.configuration.Config;
import io.airlift.units.Duration;
import io.airlift.units.MinDuration;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.NotNull;

public class PhoenixConfig {
    private String connectionUrl;
    private List<String> resourceConfigFiles = ImmutableList.of();
    private boolean caseInsensitiveNameMatching;
    private Duration caseInsensitiveNameMatchingCacheTtl = new Duration(1.0, TimeUnit.MINUTES);

    @NotNull
    public String getConnectionUrl() {
        return this.connectionUrl;
    }

    @Config(value="phoenix.connection-url")
    public PhoenixConfig setConnectionUrl(String connectionUrl) {
        this.connectionUrl = connectionUrl;
        return this;
    }

    @NotNull
    public List<String> getResourceConfigFiles() {
        return this.resourceConfigFiles;
    }

    @Config(value="phoenix.config.resources")
    public PhoenixConfig setResourceConfigFiles(String files) {
        this.resourceConfigFiles = Splitter.on((char)',').trimResults().omitEmptyStrings().splitToList((CharSequence)files);
        return this;
    }

    public boolean isCaseInsensitiveNameMatching() {
        return this.caseInsensitiveNameMatching;
    }

    @Config(value="case-insensitive-name-matching")
    public PhoenixConfig setCaseInsensitiveNameMatching(boolean caseInsensitiveNameMatching) {
        this.caseInsensitiveNameMatching = caseInsensitiveNameMatching;
        return this;
    }

    @NotNull
    @MinDuration(value="0ms")
    public @NotNull @MinDuration(value="0ms") Duration getCaseInsensitiveNameMatchingCacheTtl() {
        return this.caseInsensitiveNameMatchingCacheTtl;
    }

    @Config(value="case-insensitive-name-matching.cache-ttl")
    public PhoenixConfig setCaseInsensitiveNameMatchingCacheTtl(Duration caseInsensitiveNameMatchingCacheTtl) {
        this.caseInsensitiveNameMatchingCacheTtl = caseInsensitiveNameMatchingCacheTtl;
        return this;
    }
}

