/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.phoenix;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slice;
import io.prestosql.plugin.jdbc.JdbcColumnHandle;
import io.prestosql.plugin.jdbc.JdbcIdentity;
import io.prestosql.plugin.jdbc.JdbcOutputTableHandle;
import io.prestosql.plugin.jdbc.JdbcTableHandle;
import io.prestosql.plugin.phoenix.MetadataUtil;
import io.prestosql.plugin.phoenix.PhoenixClient;
import io.prestosql.plugin.phoenix.PhoenixColumnProperties;
import io.prestosql.plugin.phoenix.PhoenixErrorCode;
import io.prestosql.plugin.phoenix.PhoenixOutputTableHandle;
import io.prestosql.plugin.phoenix.PhoenixTableLayoutHandle;
import io.prestosql.plugin.phoenix.PhoenixTableProperties;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.connector.ColumnMetadata;
import io.prestosql.spi.connector.ConnectorInsertTableHandle;
import io.prestosql.spi.connector.ConnectorMetadata;
import io.prestosql.spi.connector.ConnectorNewTableLayout;
import io.prestosql.spi.connector.ConnectorOutputMetadata;
import io.prestosql.spi.connector.ConnectorOutputTableHandle;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.connector.ConnectorTableHandle;
import io.prestosql.spi.connector.ConnectorTableLayout;
import io.prestosql.spi.connector.ConnectorTableLayoutHandle;
import io.prestosql.spi.connector.ConnectorTableLayoutResult;
import io.prestosql.spi.connector.ConnectorTableMetadata;
import io.prestosql.spi.connector.Constraint;
import io.prestosql.spi.connector.SchemaNotFoundException;
import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.spi.connector.SchemaTablePrefix;
import io.prestosql.spi.connector.TableNotFoundException;
import io.prestosql.spi.predicate.TupleDomain;
import io.prestosql.spi.statistics.ComputedStatistics;
import io.prestosql.spi.type.Type;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.TableProperty;
import org.apache.phoenix.util.PhoenixRuntime;
import org.apache.phoenix.util.SchemaUtil;

public class PhoenixMetadata
implements ConnectorMetadata {
    public static final String DEFAULT_SCHEMA = "default";
    private static final String ROWKEY = "ROWKEY";
    private final PhoenixClient phoenixClient;

    @Inject
    public PhoenixMetadata(PhoenixClient phoenixClient) {
        this.phoenixClient = Objects.requireNonNull(phoenixClient, "client is null");
    }

    public List<String> listSchemaNames(ConnectorSession session) {
        return ImmutableList.copyOf((Collection)this.phoenixClient.getSchemaNames(JdbcIdentity.from((ConnectorSession)session)));
    }

    public JdbcTableHandle getTableHandle(ConnectorSession session, SchemaTableName schemaTableName) {
        return this.phoenixClient.getTableHandle(JdbcIdentity.from((ConnectorSession)session), schemaTableName).map(tableHandle -> new JdbcTableHandle(schemaTableName, tableHandle.getCatalogName(), (String)MetadataUtil.toPrestoSchemaName(Optional.ofNullable(tableHandle.getSchemaName())).orElse(null), tableHandle.getTableName())).orElse(null);
    }

    public List<ConnectorTableLayoutResult> getTableLayouts(ConnectorSession session, ConnectorTableHandle table, Constraint constraint, Optional<Set<ColumnHandle>> desiredColumns) {
        JdbcTableHandle tableHandle = (JdbcTableHandle)table;
        ConnectorTableLayout layout = new ConnectorTableLayout((ConnectorTableLayoutHandle)new PhoenixTableLayoutHandle(tableHandle, (TupleDomain<ColumnHandle>)constraint.getSummary(), desiredColumns));
        return ImmutableList.of((Object)new ConnectorTableLayoutResult(layout, constraint.getSummary()));
    }

    public ConnectorTableLayout getTableLayout(ConnectorSession session, ConnectorTableLayoutHandle handle) {
        return new ConnectorTableLayout(handle);
    }

    public ConnectorTableMetadata getTableMetadata(ConnectorSession session, ConnectorTableHandle table) {
        return this.getTableMetadata(session, table, false);
    }

    public ConnectorTableMetadata getTableMetadata(ConnectorSession session, ConnectorTableHandle table, boolean rowkeyRequired) {
        JdbcTableHandle handle = (JdbcTableHandle)table;
        List columnMetadata = (List)this.phoenixClient.getColumns(session, handle).stream().filter(column -> rowkeyRequired || !ROWKEY.equalsIgnoreCase(column.getColumnName())).map(JdbcColumnHandle::getColumnMetadata).collect(ImmutableList.toImmutableList());
        return new ConnectorTableMetadata(handle.getSchemaTableName(), columnMetadata, this.getTableProperties(session, handle));
    }

    public boolean usesLegacyTableLayouts() {
        return true;
    }

    public Map<String, Object> getTableProperties(ConnectorSession session, JdbcTableHandle handle) {
        ImmutableMap.Builder properties = ImmutableMap.builder();
        try (PhoenixConnection connection = this.phoenixClient.getConnection(JdbcIdentity.from((ConnectorSession)session));
             HBaseAdmin admin = connection.getQueryServices().getAdmin();){
            HColumnDescriptor[] columnFamilies;
            String schemaName = MetadataUtil.toPhoenixSchemaName(Optional.ofNullable(handle.getSchemaName())).orElse(null);
            PTable table = PhoenixRuntime.getTable((Connection)connection, (String)SchemaUtil.getTableName((String)schemaName, (String)handle.getTableName()));
            boolean salted = table.getBucketNum() != null;
            StringJoiner joiner = new StringJoiner(",");
            List pkColumns = table.getPKColumns();
            for (PColumn pkColumn : pkColumns.subList(salted ? 1 : 0, pkColumns.size())) {
                joiner.add(pkColumn.getName().getString());
            }
            properties.put((Object)"rowkeys", (Object)joiner.toString());
            if (table.getBucketNum() != null) {
                properties.put((Object)"salt_buckets", (Object)table.getBucketNum());
            }
            if (table.isWALDisabled()) {
                properties.put((Object)"disable_wal", (Object)table.isWALDisabled());
            }
            if (table.isImmutableRows()) {
                properties.put((Object)"immutable_rows", (Object)table.isImmutableRows());
            }
            String defaultFamilyName = "0";
            if (table.getDefaultFamilyName() != null) {
                defaultFamilyName = table.getDefaultFamilyName().getString();
                properties.put((Object)"default_column_family", (Object)defaultFamilyName);
            }
            HTableDescriptor tableDesc = admin.getTableDescriptor(table.getPhysicalName().getBytes());
            for (HColumnDescriptor columnFamily : columnFamilies = tableDesc.getColumnFamilies()) {
                if (!columnFamily.getNameAsString().equals(defaultFamilyName)) continue;
                if (!"NONE".equals(columnFamily.getBloomFilterType().toString())) {
                    properties.put((Object)"bloomfilter", (Object)columnFamily.getBloomFilterType().toString());
                }
                if (columnFamily.getMaxVersions() != 1) {
                    properties.put((Object)"versions", (Object)columnFamily.getMaxVersions());
                }
                if (columnFamily.getMinVersions() > 0) {
                    properties.put((Object)"min_versions", (Object)columnFamily.getMinVersions());
                }
                if (!columnFamily.getCompression().toString().equals("NONE")) {
                    properties.put((Object)"compression", (Object)columnFamily.getCompression().toString());
                }
                if (columnFamily.getTimeToLive() < Integer.MAX_VALUE) {
                    properties.put((Object)"ttl", (Object)columnFamily.getTimeToLive());
                }
                break;
            }
        }
        catch (IOException | SQLException e) {
            throw new PrestoException((ErrorCodeSupplier)PhoenixErrorCode.PHOENIX_METADATA_ERROR, "Couldn't get Phoenix table properties", (Throwable)e);
        }
        return properties.build();
    }

    public void createSchema(ConnectorSession session, String schemaName, Map<String, Object> properties) {
        Preconditions.checkArgument((boolean)properties.isEmpty(), (Object)"Can't have properties for schema creation");
        if (DEFAULT_SCHEMA.equalsIgnoreCase(schemaName)) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Can't create 'default' schema which maps to Phoenix empty schema");
        }
        this.phoenixClient.execute(session, String.format("CREATE SCHEMA %s", SchemaUtil.getEscapedArgument((String)this.toMetadataCasing(session, schemaName))));
    }

    public void dropSchema(ConnectorSession session, String schemaName) {
        if (DEFAULT_SCHEMA.equalsIgnoreCase(schemaName)) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Can't drop 'default' schema which maps to Phoenix empty schema");
        }
        this.phoenixClient.execute(session, String.format("DROP SCHEMA %s", SchemaUtil.getEscapedArgument((String)this.toMetadataCasing(session, schemaName))));
    }

    private String toMetadataCasing(ConnectorSession session, String schemaName) {
        try (PhoenixConnection connection = this.phoenixClient.getConnection(JdbcIdentity.from((ConnectorSession)session));){
            boolean uppercase = connection.getMetaData().storesUpperCaseIdentifiers();
            if (uppercase) {
                schemaName = schemaName.toUpperCase(Locale.ENGLISH);
            }
        }
        catch (SQLException e) {
            throw new PrestoException((ErrorCodeSupplier)PhoenixErrorCode.PHOENIX_METADATA_ERROR, "Couldn't get casing for the schema name", (Throwable)e);
        }
        return schemaName;
    }

    public void createTable(ConnectorSession session, ConnectorTableMetadata tableMetadata, boolean ignoreExisting) {
        this.createTable(session, tableMetadata);
    }

    public ConnectorOutputTableHandle beginCreateTable(ConnectorSession session, ConnectorTableMetadata tableMetadata, Optional<ConnectorNewTableLayout> layout) {
        return this.createTable(session, tableMetadata);
    }

    public Optional<ConnectorOutputMetadata> finishCreateTable(ConnectorSession session, ConnectorOutputTableHandle tableHandle, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics) {
        return Optional.empty();
    }

    public ConnectorInsertTableHandle beginInsert(ConnectorSession session, ConnectorTableHandle tableHandle) {
        JdbcTableHandle handle = (JdbcTableHandle)tableHandle;
        List allColumns = this.phoenixClient.getColumns(session, handle);
        List nonRowkeyColumns = (List)allColumns.stream().filter(column -> !ROWKEY.equalsIgnoreCase(column.getColumnName())).collect(ImmutableList.toImmutableList());
        return new PhoenixOutputTableHandle(Optional.ofNullable(handle.getSchemaName()), handle.getTableName(), (List)nonRowkeyColumns.stream().map(JdbcColumnHandle::getColumnName).collect(ImmutableList.toImmutableList()), (List)nonRowkeyColumns.stream().map(JdbcColumnHandle::getColumnType).collect(ImmutableList.toImmutableList()), Optional.of(nonRowkeyColumns.stream().map(JdbcColumnHandle::getJdbcTypeHandle).collect(ImmutableList.toImmutableList())), nonRowkeyColumns.size() != allColumns.size());
    }

    public Optional<ConnectorOutputMetadata> finishInsert(ConnectorSession session, ConnectorInsertTableHandle insertHandle, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics) {
        return Optional.empty();
    }

    public void addColumn(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnMetadata column) {
        JdbcTableHandle handle = (JdbcTableHandle)tableHandle;
        this.phoenixClient.execute(session, String.format("ALTER TABLE %s ADD %s %s", MetadataUtil.getEscapedTableName(Optional.ofNullable(handle.getSchemaName()), handle.getTableName()), column.getName(), this.phoenixClient.toWriteMapping(session, column.getType()).getDataType()));
    }

    public void dropColumn(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle column) {
        JdbcTableHandle handle = (JdbcTableHandle)tableHandle;
        JdbcColumnHandle columnHandle = (JdbcColumnHandle)column;
        this.phoenixClient.execute(session, String.format("ALTER TABLE %s DROP COLUMN %s", MetadataUtil.getEscapedTableName(Optional.ofNullable(handle.getSchemaName()), handle.getTableName()), columnHandle.getColumnName()));
    }

    public void dropTable(ConnectorSession session, ConnectorTableHandle tableHandle) {
        boolean hasRowkey = this.getColumnHandles(session, tableHandle).values().stream().map(JdbcColumnHandle.class::cast).map(JdbcColumnHandle::getColumnName).anyMatch(ROWKEY::equals);
        if (hasRowkey) {
            JdbcTableHandle jdbcHandle = (JdbcTableHandle)tableHandle;
            this.phoenixClient.execute(session, String.format("DROP SEQUENCE %s", MetadataUtil.getEscapedTableName(Optional.ofNullable(jdbcHandle.getSchemaName()), jdbcHandle.getTableName() + "_sequence")));
        }
        this.phoenixClient.dropTable(JdbcIdentity.from((ConnectorSession)session), (JdbcTableHandle)tableHandle);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JdbcOutputTableHandle createTable(ConnectorSession session, ConnectorTableMetadata tableMetadata) {
        SchemaTableName schemaTableName = tableMetadata.getTable();
        Optional<String> schema = Optional.of(schemaTableName.getSchemaName());
        String table = schemaTableName.getTableName();
        if (!this.phoenixClient.getSchemaNames(JdbcIdentity.from((ConnectorSession)session)).contains(schema.orElse(null))) {
            throw new SchemaNotFoundException((String)schema.orElse(null));
        }
        try (PhoenixConnection connection = this.phoenixClient.getConnection(JdbcIdentity.from((ConnectorSession)session));){
            boolean uppercase = connection.getMetaData().storesUpperCaseIdentifiers();
            if (uppercase) {
                schema = schema.map(schemaName -> schemaName.toUpperCase(Locale.ENGLISH));
                table = table.toUpperCase(Locale.ENGLISH);
            }
            schema = MetadataUtil.toPhoenixSchemaName(schema);
            LinkedList tableColumns = new LinkedList(tableMetadata.getColumns());
            Map tableProperties = tableMetadata.getProperties();
            Optional<Boolean> immutableRows = PhoenixTableProperties.getImmutableRows(tableProperties);
            String immutable = immutableRows.isPresent() && immutableRows.get() != false ? "IMMUTABLE" : "";
            ImmutableList.Builder columnNames = ImmutableList.builder();
            ImmutableList.Builder columnTypes = ImmutableList.builder();
            ImmutableList.Builder columnList = ImmutableList.builder();
            Set rowkeyColumns = tableColumns.stream().filter(col -> PhoenixColumnProperties.isPrimaryKey(col, tableProperties)).collect(Collectors.toSet());
            ImmutableList.Builder pkNames = ImmutableList.builder();
            boolean hasUUIDRowkey = false;
            if (rowkeyColumns.isEmpty()) {
                columnList.add((Object)"ROWKEY bigint not null");
                pkNames.add((Object)ROWKEY);
                this.phoenixClient.execute(session, String.format("CREATE SEQUENCE %s", MetadataUtil.getEscapedTableName(schema, table + "_sequence")));
                hasUUIDRowkey = true;
            }
            for (ColumnMetadata column : tableColumns) {
                String columnName = column.getName();
                if (uppercase) {
                    columnName = columnName.toUpperCase(Locale.ENGLISH);
                }
                columnNames.add((Object)columnName);
                columnTypes.add((Object)column.getType());
                String typeStatement = this.phoenixClient.toWriteMapping(session, column.getType()).getDataType();
                if (rowkeyColumns.contains(column)) {
                    typeStatement = typeStatement + " not null";
                    pkNames.add((Object)columnName);
                }
                columnList.add((Object)String.format("%s %s", columnName, typeStatement));
            }
            ImmutableList.Builder tableOptions = ImmutableList.builder();
            PhoenixTableProperties.getSaltBuckets(tableProperties).ifPresent(value -> tableOptions.add((Object)(TableProperty.SALT_BUCKETS + "=" + value)));
            PhoenixTableProperties.getSplitOn(tableProperties).ifPresent(value -> tableOptions.add((Object)("SPLIT ON (" + value.replace('\"', '\'') + ")")));
            PhoenixTableProperties.getDisableWal(tableProperties).ifPresent(value -> tableOptions.add((Object)(TableProperty.DISABLE_WAL + "=" + value)));
            PhoenixTableProperties.getDefaultColumnFamily(tableProperties).ifPresent(value -> tableOptions.add((Object)(TableProperty.DEFAULT_COLUMN_FAMILY + "=" + value)));
            PhoenixTableProperties.getBloomfilter(tableProperties).ifPresent(value -> tableOptions.add((Object)("BLOOMFILTER='" + value + "'")));
            PhoenixTableProperties.getVersions(tableProperties).ifPresent(value -> tableOptions.add((Object)("VERSIONS=" + value)));
            PhoenixTableProperties.getMinVersions(tableProperties).ifPresent(value -> tableOptions.add((Object)("MIN_VERSIONS=" + value)));
            PhoenixTableProperties.getCompression(tableProperties).ifPresent(value -> tableOptions.add((Object)("COMPRESSION='" + value + "'")));
            PhoenixTableProperties.getTimeToLive(tableProperties).ifPresent(value -> tableOptions.add((Object)("TTL=" + value)));
            String sql = String.format("CREATE %s TABLE %s (%s , CONSTRAINT PK PRIMARY KEY (%s)) %s", immutable, MetadataUtil.getEscapedTableName(schema, table), String.join((CharSequence)", ", (Iterable<? extends CharSequence>)columnList.build()), String.join((CharSequence)", ", (Iterable<? extends CharSequence>)pkNames.build()), String.join((CharSequence)", ", (Iterable<? extends CharSequence>)tableOptions.build()));
            this.phoenixClient.execute(session, sql);
            PhoenixOutputTableHandle phoenixOutputTableHandle = new PhoenixOutputTableHandle(schema, table, (List<String>)columnNames.build(), (List<Type>)columnTypes.build(), Optional.empty(), hasUUIDRowkey);
            return phoenixOutputTableHandle;
        }
        catch (SQLException e) {
            if (e.getErrorCode() != SQLExceptionCode.TABLE_ALREADY_EXIST.getErrorCode()) throw new PrestoException((ErrorCodeSupplier)PhoenixErrorCode.PHOENIX_METADATA_ERROR, "Error creating Phoenix table", (Throwable)e);
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.ALREADY_EXISTS, "Phoenix table already exists", (Throwable)e);
        }
    }

    public List<SchemaTableName> listTables(ConnectorSession session, Optional<String> schemaName) {
        return this.phoenixClient.getTableNames(JdbcIdentity.from((ConnectorSession)session), schemaName);
    }

    public Map<String, ColumnHandle> getColumnHandles(ConnectorSession session, ConnectorTableHandle tableHandle) {
        JdbcTableHandle jdbcTableHandle = (JdbcTableHandle)tableHandle;
        ImmutableMap.Builder columnHandles = ImmutableMap.builder();
        for (JdbcColumnHandle column : this.phoenixClient.getColumns(session, jdbcTableHandle)) {
            columnHandles.put((Object)column.getColumnMetadata().getName(), (Object)column);
        }
        return columnHandles.build();
    }

    public ColumnMetadata getColumnMetadata(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle columnHandle) {
        return ((JdbcColumnHandle)columnHandle).getColumnMetadata();
    }

    public Map<SchemaTableName, List<ColumnMetadata>> listTableColumns(ConnectorSession session, SchemaTablePrefix prefix) {
        ImmutableMap.Builder columns = ImmutableMap.builder();
        List tables = prefix.toOptionalSchemaTableName().map(ImmutableList::of).orElseGet(() -> this.listTables(session, prefix.getSchema()));
        for (SchemaTableName tableName : tables) {
            try {
                this.phoenixClient.getTableHandle(JdbcIdentity.from((ConnectorSession)session), tableName).ifPresent(tableHandle -> columns.put((Object)tableName, (Object)this.getTableMetadata(session, (ConnectorTableHandle)tableHandle).getColumns()));
            }
            catch (TableNotFoundException tableNotFoundException) {}
        }
        return columns.build();
    }
}

