/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.phoenix;

import com.google.common.collect.ImmutableList;
import io.prestosql.plugin.phoenix.PhoenixTableProperties;
import io.prestosql.spi.connector.ColumnMetadata;
import io.prestosql.spi.session.PropertyMetadata;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;

public class PhoenixColumnProperties {
    public static final String PRIMARY_KEY = "primary_key";
    private final List<PropertyMetadata<?>> columnProperties = ImmutableList.of((Object)PropertyMetadata.booleanProperty((String)"primary_key", (String)"True if the column is part of the primary key", (Boolean)false, (boolean)false));

    @Inject
    public PhoenixColumnProperties() {
    }

    public List<PropertyMetadata<?>> getColumnProperties() {
        return this.columnProperties;
    }

    public static boolean isPrimaryKey(ColumnMetadata col, Map<String, Object> tableProperties) {
        Optional<List<String>> rowkeysTableProp = PhoenixTableProperties.getRowkeys(tableProperties);
        if (rowkeysTableProp.isPresent()) {
            return rowkeysTableProp.get().stream().anyMatch(col.getName()::equalsIgnoreCase);
        }
        Boolean isPk = (Boolean)col.getProperties().get(PRIMARY_KEY);
        return isPk != null && isPk != false;
    }
}

