/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.phoenix;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.prestosql.plugin.jdbc.JdbcSplit;
import io.prestosql.plugin.phoenix.WrappedPhoenixInputSplit;
import io.prestosql.spi.HostAddress;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.predicate.TupleDomain;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.phoenix.mapreduce.PhoenixInputSplit;

public class PhoenixSplit
extends JdbcSplit {
    private final List<HostAddress> addresses;
    private final WrappedPhoenixInputSplit phoenixInputSplit;
    private final TupleDomain<ColumnHandle> constraint;

    @JsonCreator
    public PhoenixSplit(@JsonProperty(value="addresses") List<HostAddress> addresses, @JsonProperty(value="phoenixInputSplit") WrappedPhoenixInputSplit wrappedPhoenixInputSplit, @JsonProperty(value="constraint") TupleDomain<ColumnHandle> constraint) {
        super(Optional.empty());
        this.addresses = Objects.requireNonNull(addresses, "addresses is null");
        this.phoenixInputSplit = Objects.requireNonNull(wrappedPhoenixInputSplit, "wrappedPhoenixInputSplit is null");
        this.constraint = Objects.requireNonNull(constraint, "constraint is null");
    }

    @JsonProperty
    public List<HostAddress> getAddresses() {
        return this.addresses;
    }

    @JsonProperty(value="phoenixInputSplit")
    public WrappedPhoenixInputSplit getWrappedPhoenixInputSplit() {
        return this.phoenixInputSplit;
    }

    @JsonIgnore
    public PhoenixInputSplit getPhoenixInputSplit() {
        return this.phoenixInputSplit.getPhoenixInputSplit();
    }

    @JsonProperty
    public TupleDomain<ColumnHandle> getConstraint() {
        return this.constraint;
    }
}

