/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.base.security;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.prestosql.plugin.base.security.AnyCatalogPermissionsRule;
import io.prestosql.plugin.base.security.AnyCatalogSchemaPermissionsRule;
import io.prestosql.plugin.base.security.TableAccessControlRule;
import io.prestosql.spi.connector.CatalogSchemaTableName;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;

public class CatalogTableAccessControlRule {
    public static final CatalogTableAccessControlRule ALLOW_ALL = new CatalogTableAccessControlRule(TableAccessControlRule.ALLOW_ALL, Optional.empty());
    private final TableAccessControlRule tableAccessControlRule;
    private final Optional<Pattern> catalogRegex;

    @JsonCreator
    public CatalogTableAccessControlRule(@JsonProperty(value="privileges") Set<TableAccessControlRule.TablePrivilege> privileges, @JsonProperty(value="user") Optional<Pattern> userRegex, @JsonProperty(value="group") Optional<Pattern> groupRegex, @JsonProperty(value="schema") Optional<Pattern> schemaRegex, @JsonProperty(value="table") Optional<Pattern> tableRegex, @JsonProperty(value="catalog") Optional<Pattern> catalogRegex) {
        this.tableAccessControlRule = new TableAccessControlRule(privileges, userRegex, groupRegex, schemaRegex, tableRegex);
        this.catalogRegex = Objects.requireNonNull(catalogRegex, "catalogRegex is null");
    }

    public CatalogTableAccessControlRule(TableAccessControlRule tableAccessControlRule, Optional<Pattern> catalogRegex) {
        this.tableAccessControlRule = tableAccessControlRule;
        this.catalogRegex = catalogRegex;
    }

    public Optional<Set<TableAccessControlRule.TablePrivilege>> match(String user, Set<String> groups, CatalogSchemaTableName table) {
        if (!this.catalogRegex.map(regex -> regex.matcher(table.getCatalogName()).matches()).orElse(true).booleanValue()) {
            return Optional.empty();
        }
        return this.tableAccessControlRule.match(user, groups, table.getSchemaTableName());
    }

    Optional<AnyCatalogPermissionsRule> toAnyCatalogPermissionsRule() {
        if (this.tableAccessControlRule.getPrivileges().isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new AnyCatalogPermissionsRule(this.tableAccessControlRule.getUserRegex(), this.tableAccessControlRule.getGroupRegex(), this.catalogRegex));
    }

    Optional<AnyCatalogSchemaPermissionsRule> toAnyCatalogSchemaPermissionsRule() {
        if (this.tableAccessControlRule.getPrivileges().isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new AnyCatalogSchemaPermissionsRule(this.tableAccessControlRule.getUserRegex(), this.tableAccessControlRule.getGroupRegex(), this.catalogRegex, this.tableAccessControlRule.getSchemaRegex()));
    }
}

