/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.postgresql;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.google.common.collect.ImmutableMap;
import io.airlift.json.ObjectMapperProvider;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.prestosql.plugin.jdbc.BaseJdbcClient;
import io.prestosql.plugin.jdbc.BaseJdbcConfig;
import io.prestosql.plugin.jdbc.BlockReadFunction;
import io.prestosql.plugin.jdbc.BlockWriteFunction;
import io.prestosql.plugin.jdbc.ColumnMapping;
import io.prestosql.plugin.jdbc.ConnectionFactory;
import io.prestosql.plugin.jdbc.DriverConnectionFactory;
import io.prestosql.plugin.jdbc.JdbcColumnHandle;
import io.prestosql.plugin.jdbc.JdbcErrorCode;
import io.prestosql.plugin.jdbc.JdbcIdentity;
import io.prestosql.plugin.jdbc.JdbcTableHandle;
import io.prestosql.plugin.jdbc.JdbcTypeHandle;
import io.prestosql.plugin.jdbc.LongWriteFunction;
import io.prestosql.plugin.jdbc.SliceWriteFunction;
import io.prestosql.plugin.jdbc.StandardColumnMappings;
import io.prestosql.plugin.jdbc.WriteMapping;
import io.prestosql.plugin.postgresql.PostgreSqlConfig;
import io.prestosql.plugin.postgresql.TypeUtils;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.connector.ConnectorTableMetadata;
import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.spi.type.ArrayType;
import io.prestosql.spi.type.DateTimeEncoding;
import io.prestosql.spi.type.TimeZoneKey;
import io.prestosql.spi.type.TimestampType;
import io.prestosql.spi.type.TimestampWithTimeZoneType;
import io.prestosql.spi.type.TinyintType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeManager;
import io.prestosql.spi.type.TypeSignature;
import io.prestosql.spi.type.TypeSignatureParameter;
import io.prestosql.spi.type.VarbinaryType;
import io.prestosql.spi.type.VarcharType;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.sql.Array;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.UnaryOperator;
import javax.inject.Inject;
import org.postgresql.core.TypeInfo;
import org.postgresql.jdbc.PgConnection;
import org.postgresql.util.PGobject;

public class PostgreSqlClient
extends BaseJdbcClient {
    private static final String DUPLICATE_TABLE_SQLSTATE = "42P07";
    private final Type jsonType;
    private final boolean supportArrays;
    private static final JsonFactory JSON_FACTORY = new JsonFactory().disable(JsonFactory.Feature.CANONICALIZE_FIELD_NAMES);
    private static final ObjectMapper SORTED_MAPPER = new ObjectMapperProvider().get().configure(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS, true);

    @Inject
    public PostgreSqlClient(BaseJdbcConfig config, PostgreSqlConfig postgreSqlConfig, TypeManager typeManager) {
        super(config, "\"", (ConnectionFactory)new DriverConnectionFactory((Driver)new org.postgresql.Driver(), config));
        this.jsonType = typeManager.getType(new TypeSignature("json", new TypeSignatureParameter[0]));
        switch (postgreSqlConfig.getArrayMapping()) {
            case DISABLED: {
                this.supportArrays = false;
                break;
            }
            case AS_ARRAY: {
                this.supportArrays = true;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported ArrayMapping: " + (Object)((Object)postgreSqlConfig.getArrayMapping()));
            }
        }
    }

    public void createTable(ConnectorSession session, ConnectorTableMetadata tableMetadata) {
        try {
            this.createTable(session, tableMetadata, tableMetadata.getTable().getTableName());
        }
        catch (SQLException e) {
            boolean exists = DUPLICATE_TABLE_SQLSTATE.equals(e.getSQLState());
            throw new PrestoException((ErrorCodeSupplier)(exists ? StandardErrorCode.ALREADY_EXISTS : JdbcErrorCode.JDBC_ERROR), (Throwable)e);
        }
    }

    protected void renameTable(JdbcIdentity identity, String catalogName, String schemaName, String tableName, SchemaTableName newTable) {
        if (!schemaName.equals(newTable.getSchemaName())) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Table rename across schemas is not supported in PostgreSQL");
        }
        String sql = String.format("ALTER TABLE %s RENAME TO %s", this.quoted(catalogName, schemaName, tableName), this.quoted(newTable.getTableName()));
        try (Connection connection = this.connectionFactory.openConnection(identity);){
            this.execute(connection, sql);
        }
        catch (SQLException e) {
            throw new PrestoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
        }
    }

    public PreparedStatement getPreparedStatement(Connection connection, String sql) throws SQLException {
        connection.setAutoCommit(false);
        PreparedStatement statement = connection.prepareStatement(sql);
        statement.setFetchSize(1000);
        return statement;
    }

    protected ResultSet getTables(Connection connection, Optional<String> schemaName, Optional<String> tableName) throws SQLException {
        DatabaseMetaData metadata = connection.getMetaData();
        Optional<String> escape = Optional.ofNullable(metadata.getSearchStringEscape());
        return metadata.getTables(connection.getCatalog(), PostgreSqlClient.escapeNamePattern(schemaName, escape).orElse(null), PostgreSqlClient.escapeNamePattern(tableName, escape).orElse(null), new String[]{"TABLE", "VIEW", "MATERIALIZED VIEW", "FOREIGN TABLE"});
    }

    /*
     * Exception decompiling
     */
    public List<JdbcColumnHandle> getColumns(ConnectorSession session, JdbcTableHandle tableHandle) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Map<String, Integer> getArrayColumnDimensions(Connection connection, JdbcTableHandle tableHandle) throws SQLException {
        if (!this.supportArrays) {
            return ImmutableMap.of();
        }
        String sql = "SELECT att.attname, greatest(att.attndims, 1) AS attndims FROM pg_attribute att   JOIN pg_type attyp ON att.atttypid = attyp.oid  JOIN pg_class tbl ON tbl.oid = att.attrelid   JOIN pg_namespace ns ON tbl.relnamespace = ns.oid WHERE ns.nspname = ? AND tbl.relname = ? AND attyp.typcategory = 'A' ";
        try (PreparedStatement statement = connection.prepareStatement(sql);){
            statement.setString(1, tableHandle.getSchemaName());
            statement.setString(2, tableHandle.getTableName());
            HashMap<String, Integer> arrayColumnDimensions = new HashMap<String, Integer>();
            try (ResultSet resultSet = statement.executeQuery();){
                while (resultSet.next()) {
                    arrayColumnDimensions.put(resultSet.getString("attname"), resultSet.getInt("attndims"));
                }
            }
            HashMap<String, Integer> hashMap = arrayColumnDimensions;
            return hashMap;
        }
    }

    public Optional<ColumnMapping> toPrestoType(ConnectorSession session, Connection connection, JdbcTypeHandle typeHandle) {
        String jdbcTypeName;
        switch (jdbcTypeName = (String)typeHandle.getJdbcTypeName().orElseThrow(() -> new PrestoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, "Type name is missing: " + typeHandle))) {
            case "jsonb": 
            case "json": {
                return Optional.of(this.jsonColumnMapping());
            }
            case "timestamptz": {
                return Optional.of(PostgreSqlClient.timestampWithTimeZoneColumnMapping());
            }
        }
        if (typeHandle.getJdbcType() == 12 && !jdbcTypeName.equals("varchar")) {
            return Optional.of(this.typedVarcharColumnMapping(jdbcTypeName));
        }
        if (typeHandle.getJdbcType() == 93) {
            return Optional.of(StandardColumnMappings.timestampColumnMapping((ConnectorSession)session));
        }
        if (typeHandle.getJdbcType() == 2003 && this.supportArrays) {
            if (!typeHandle.getArrayDimensions().isPresent()) {
                return Optional.empty();
            }
            JdbcTypeHandle elementTypeHandle = this.getArrayElementTypeHandle(connection, typeHandle);
            String elementTypeName = (String)typeHandle.getJdbcTypeName().orElseThrow(() -> new PrestoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, "Element type name is missing: " + elementTypeHandle));
            if (elementTypeHandle.getJdbcType() == -3) {
                return Optional.empty();
            }
            return this.toPrestoType(session, connection, elementTypeHandle).map(elementMapping -> {
                ArrayType prestoArrayType = new ArrayType(elementMapping.getType());
                int arrayDimensions = (Integer)typeHandle.getArrayDimensions().get();
                for (int i = 1; i < arrayDimensions; ++i) {
                    prestoArrayType = new ArrayType((Type)prestoArrayType);
                }
                return PostgreSqlClient.arrayColumnMapping(session, prestoArrayType, elementTypeName);
            });
        }
        return super.toPrestoType(session, connection, typeHandle);
    }

    public WriteMapping toWriteMapping(ConnectorSession session, Type type) {
        if (VarbinaryType.VARBINARY.equals((Object)type)) {
            return WriteMapping.sliceMapping((String)"bytea", (SliceWriteFunction)StandardColumnMappings.varbinaryWriteFunction());
        }
        if (TimestampType.TIMESTAMP.equals((Object)type)) {
            return WriteMapping.longMapping((String)"timestamp", (LongWriteFunction)StandardColumnMappings.timestampWriteFunction((ConnectorSession)session));
        }
        if (TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE.equals((Object)type)) {
            return WriteMapping.longMapping((String)"timestamp with time zone", (LongWriteFunction)PostgreSqlClient.timestampWithTimeZoneWriteFunction());
        }
        if (TinyintType.TINYINT.equals((Object)type)) {
            return WriteMapping.longMapping((String)"smallint", (LongWriteFunction)StandardColumnMappings.tinyintWriteFunction());
        }
        if (type.getTypeSignature().getBase().equals("json")) {
            return WriteMapping.sliceMapping((String)"jsonb", (SliceWriteFunction)PostgreSqlClient.typedVarcharWriteFunction("json"));
        }
        if (type instanceof ArrayType && this.supportArrays) {
            Type elementType = ((ArrayType)type).getElementType();
            String elementDataType = this.toWriteMapping(session, elementType).getDataType();
            return WriteMapping.blockMapping((String)(elementDataType + "[]"), (BlockWriteFunction)PostgreSqlClient.arrayWriteFunction(session, elementType, TypeUtils.getArrayElementPgTypeName(session, this, elementType)));
        }
        return super.toWriteMapping(session, type);
    }

    protected Optional<BiFunction<String, Long, String>> limitFunction() {
        return Optional.of((sql, limit) -> sql + " LIMIT " + limit);
    }

    public boolean isLimitGuaranteed() {
        return true;
    }

    private static ColumnMapping timestampWithTimeZoneColumnMapping() {
        return ColumnMapping.longMapping((Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE, (resultSet, columnIndex) -> {
            long millisUtc = resultSet.getTimestamp(columnIndex).getTime();
            return DateTimeEncoding.packDateTimeWithZone((long)millisUtc, (TimeZoneKey)TimeZoneKey.UTC_KEY);
        }, (LongWriteFunction)PostgreSqlClient.timestampWithTimeZoneWriteFunction());
    }

    private static LongWriteFunction timestampWithTimeZoneWriteFunction() {
        return (statement, index, value) -> {
            long millisUtc = DateTimeEncoding.unpackMillisUtc((long)value);
            statement.setTimestamp(index, new Timestamp(millisUtc));
        };
    }

    private static ColumnMapping arrayColumnMapping(ConnectorSession session, ArrayType arrayType, String elementJdbcTypeName) {
        return ColumnMapping.blockMapping((Type)arrayType, (BlockReadFunction)PostgreSqlClient.arrayReadFunction(session, arrayType.getElementType()), (BlockWriteFunction)PostgreSqlClient.arrayWriteFunction(session, arrayType.getElementType(), elementJdbcTypeName));
    }

    private static BlockReadFunction arrayReadFunction(ConnectorSession session, Type elementType) {
        return (resultSet, columnIndex) -> {
            Object[] objectArray = TypeUtils.toBoxedArray(resultSet.getArray(columnIndex).getArray());
            return TypeUtils.jdbcObjectArrayToBlock(session, elementType, objectArray);
        };
    }

    private static BlockWriteFunction arrayWriteFunction(ConnectorSession session, Type elementType, String elementJdbcTypeName) {
        return (statement, index, block) -> {
            Array jdbcArray = statement.getConnection().createArrayOf(elementJdbcTypeName, TypeUtils.getJdbcObjectArray(session, elementType, block));
            statement.setArray(index, jdbcArray);
        };
    }

    private JdbcTypeHandle getArrayElementTypeHandle(Connection connection, JdbcTypeHandle arrayTypeHandle) {
        String jdbcTypeName = (String)arrayTypeHandle.getJdbcTypeName().orElseThrow(() -> new PrestoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, "Type name is missing: " + arrayTypeHandle));
        try {
            TypeInfo typeInfo = connection.unwrap(PgConnection.class).getTypeInfo();
            int pgElementOid = typeInfo.getPGArrayElement(typeInfo.getPGType(jdbcTypeName));
            return new JdbcTypeHandle(typeInfo.getSQLType(pgElementOid), Optional.of(typeInfo.getPGType(pgElementOid)), arrayTypeHandle.getColumnSize(), arrayTypeHandle.getDecimalDigits(), arrayTypeHandle.getArrayDimensions());
        }
        catch (SQLException e) {
            throw new PrestoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
        }
    }

    private ColumnMapping jsonColumnMapping() {
        return ColumnMapping.sliceMapping((Type)this.jsonType, (resultSet, columnIndex) -> PostgreSqlClient.jsonParse(Slices.utf8Slice((String)resultSet.getString(columnIndex))), (SliceWriteFunction)PostgreSqlClient.typedVarcharWriteFunction("json"), (UnaryOperator)ColumnMapping.DISABLE_PUSHDOWN);
    }

    private ColumnMapping typedVarcharColumnMapping(String jdbcTypeName) {
        return ColumnMapping.sliceMapping((Type)VarcharType.VARCHAR, (resultSet, columnIndex) -> Slices.utf8Slice((String)resultSet.getString(columnIndex)), (SliceWriteFunction)PostgreSqlClient.typedVarcharWriteFunction(jdbcTypeName));
    }

    private static SliceWriteFunction typedVarcharWriteFunction(String jdbcTypeName) {
        return (statement, index, value) -> {
            PGobject pgObject = new PGobject();
            pgObject.setType(jdbcTypeName);
            pgObject.setValue(value.toStringUtf8());
            statement.setObject(index, pgObject);
        };
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Slice jsonParse(Slice slice) {
        try (JsonParser parser = PostgreSqlClient.createJsonParser(slice);){
            byte[] in = slice.getBytes();
            DynamicSliceOutput dynamicSliceOutput = new DynamicSliceOutput(in.length);
            SORTED_MAPPER.writeValue((OutputStream)dynamicSliceOutput, SORTED_MAPPER.readValue(parser, Object.class));
            parser.nextToken();
            Slice slice2 = dynamicSliceOutput.slice();
            return slice2;
        }
        catch (Exception e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, String.format("Cannot convert '%s' to JSON", slice.toStringUtf8()));
        }
    }

    private static JsonParser createJsonParser(Slice json) throws IOException {
        return JSON_FACTORY.createParser((Reader)new InputStreamReader((InputStream)json.getInput(), StandardCharsets.UTF_8));
    }
}

