/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.guava.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.KeyDeserializer;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.type.MapType;
import java.io.IOException;

public abstract class GuavaMapDeserializer<T>
extends JsonDeserializer<T>
implements ContextualDeserializer {
    protected final MapType _mapType;
    protected KeyDeserializer _keyDeserializer;
    protected JsonDeserializer<?> _valueDeserializer;
    protected final TypeDeserializer _typeDeserializerForValue;

    protected GuavaMapDeserializer(MapType type, KeyDeserializer keyDeser, TypeDeserializer typeDeser, JsonDeserializer<?> deser) {
        this._mapType = type;
        this._keyDeserializer = keyDeser;
        this._typeDeserializerForValue = typeDeser;
        this._valueDeserializer = deser;
    }

    public abstract GuavaMapDeserializer<T> withResolved(KeyDeserializer var1, TypeDeserializer var2, JsonDeserializer<?> var3);

    public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) throws JsonMappingException {
        KeyDeserializer keyDeser = this._keyDeserializer;
        JsonDeserializer deser = this._valueDeserializer;
        TypeDeserializer typeDeser = this._typeDeserializerForValue;
        if (keyDeser != null && deser != null && typeDeser == null) {
            return this;
        }
        if (keyDeser == null) {
            keyDeser = ctxt.findKeyDeserializer(this._mapType.getKeyType(), property);
        }
        if (deser == null) {
            deser = ctxt.findContextualValueDeserializer(this._mapType.getContentType(), property);
        }
        if (typeDeser != null) {
            typeDeser = typeDeser.forProperty(property);
        }
        return this.withResolved(keyDeser, typeDeser, deser);
    }

    public Object deserializeWithType(JsonParser p, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws IOException {
        return typeDeserializer.deserializeTypedFromObject(p, ctxt);
    }

    public T deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonToken t = p.getCurrentToken();
        if (t == JsonToken.START_OBJECT) {
            t = p.nextToken();
        }
        if (t != JsonToken.FIELD_NAME && t != JsonToken.END_OBJECT) {
            return (T)ctxt.handleUnexpectedToken(this._mapType.getRawClass(), p);
        }
        return this._deserializeEntries(p, ctxt);
    }

    protected abstract T _deserializeEntries(JsonParser var1, DeserializationContext var2) throws IOException;
}

