/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.jdbc;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import io.prestosql.spi.connector.ConnectorSession;
import java.util.Map;
import java.util.Objects;

public class JdbcIdentity {
    private final String user;
    private final Map<String, String> extraCredentials;

    public static JdbcIdentity from(ConnectorSession session) {
        return new JdbcIdentity(session.getIdentity().getUser(), session.getIdentity().getExtraCredentials());
    }

    public JdbcIdentity(String user, Map<String, String> extraCredentials) {
        this.user = Objects.requireNonNull(user, "user is null");
        this.extraCredentials = ImmutableMap.copyOf(Objects.requireNonNull(extraCredentials, "extraCredentials is null"));
    }

    public String getUser() {
        return this.user;
    }

    public Map<String, String> getExtraCredentials() {
        return this.extraCredentials;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JdbcIdentity that = (JdbcIdentity)o;
        return Objects.equals(this.user, that.user) && Objects.equals(this.extraCredentials, that.extraCredentials);
    }

    public int hashCode() {
        return Objects.hash(this.user, this.extraCredentials);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("user", (Object)this.user).add("extraCredentials", this.extraCredentials.keySet()).toString();
    }
}

