/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.postgresql;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.google.common.base.Preconditions;
import io.airlift.json.ObjectMapperProvider;
import io.airlift.log.Logger;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.prestosql.plugin.jdbc.BaseJdbcClient;
import io.prestosql.plugin.jdbc.BaseJdbcConfig;
import io.prestosql.plugin.jdbc.BlockReadFunction;
import io.prestosql.plugin.jdbc.BlockWriteFunction;
import io.prestosql.plugin.jdbc.BooleanReadFunction;
import io.prestosql.plugin.jdbc.ColumnMapping;
import io.prestosql.plugin.jdbc.ConnectionFactory;
import io.prestosql.plugin.jdbc.DoubleReadFunction;
import io.prestosql.plugin.jdbc.JdbcColumnHandle;
import io.prestosql.plugin.jdbc.JdbcErrorCode;
import io.prestosql.plugin.jdbc.JdbcIdentity;
import io.prestosql.plugin.jdbc.JdbcTableHandle;
import io.prestosql.plugin.jdbc.JdbcTypeHandle;
import io.prestosql.plugin.jdbc.LongReadFunction;
import io.prestosql.plugin.jdbc.LongWriteFunction;
import io.prestosql.plugin.jdbc.ReadFunction;
import io.prestosql.plugin.jdbc.SliceReadFunction;
import io.prestosql.plugin.jdbc.SliceWriteFunction;
import io.prestosql.plugin.jdbc.StandardColumnMappings;
import io.prestosql.plugin.jdbc.StatsCollecting;
import io.prestosql.plugin.jdbc.WriteMapping;
import io.prestosql.plugin.postgresql.PostgreSqlConfig;
import io.prestosql.plugin.postgresql.PostgreSqlSessionProperties;
import io.prestosql.plugin.postgresql.TypeUtils;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.block.SingleMapBlock;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.connector.ConnectorTableMetadata;
import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.spi.type.ArrayType;
import io.prestosql.spi.type.DateTimeEncoding;
import io.prestosql.spi.type.MapType;
import io.prestosql.spi.type.TimeZoneKey;
import io.prestosql.spi.type.TimestampType;
import io.prestosql.spi.type.TimestampWithTimeZoneType;
import io.prestosql.spi.type.TinyintType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeManager;
import io.prestosql.spi.type.TypeSignature;
import io.prestosql.spi.type.TypeSignatureParameter;
import io.prestosql.spi.type.VarbinaryType;
import io.prestosql.spi.type.VarcharType;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.sql.Array;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.UnaryOperator;
import javax.inject.Inject;
import org.postgresql.core.TypeInfo;
import org.postgresql.jdbc.PgConnection;
import org.postgresql.util.PGobject;

public class PostgreSqlClient
extends BaseJdbcClient {
    private static final Logger log = Logger.get(PostgreSqlClient.class);
    private static final int ARRAY_RESULT_SET_VALUE_COLUMN = 2;
    private static final String DUPLICATE_TABLE_SQLSTATE = "42P07";
    private final TypeManager typeManager;
    private final Type jsonType;
    private final Type uuidType;
    private final MapType varcharMapType;
    private final String[] tableTypes;
    private static final JsonFactory JSON_FACTORY = new JsonFactory().disable(JsonFactory.Feature.CANONICALIZE_FIELD_NAMES);
    private static final ObjectMapper SORTED_MAPPER = new ObjectMapperProvider().get().configure(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS, true);

    @Inject
    public PostgreSqlClient(BaseJdbcConfig config, PostgreSqlConfig postgreSqlConfig, @StatsCollecting ConnectionFactory connectionFactory, TypeManager typeManager) {
        super(config, "\"", connectionFactory);
        this.typeManager = typeManager;
        this.jsonType = typeManager.getType(new TypeSignature("json", new TypeSignatureParameter[0]));
        this.uuidType = typeManager.getType(new TypeSignature("uuid", new TypeSignatureParameter[0]));
        this.varcharMapType = (MapType)typeManager.getType(TypeSignature.mapType((TypeSignature)VarcharType.VARCHAR.getTypeSignature(), (TypeSignature)VarcharType.VARCHAR.getTypeSignature()));
        ArrayList tableTypes = new ArrayList();
        Collections.addAll(tableTypes, "TABLE", "VIEW", "MATERIALIZED VIEW", "FOREIGN TABLE");
        if (postgreSqlConfig.isIncludeSystemTables()) {
            Collections.addAll(tableTypes, "SYSTEM TABLE", "SYSTEM VIEW");
        }
        this.tableTypes = tableTypes.toArray(new String[0]);
    }

    public void createTable(ConnectorSession session, ConnectorTableMetadata tableMetadata) {
        try {
            this.createTable(session, tableMetadata, tableMetadata.getTable().getTableName());
        }
        catch (SQLException e) {
            boolean exists = DUPLICATE_TABLE_SQLSTATE.equals(e.getSQLState());
            throw new PrestoException((ErrorCodeSupplier)(exists ? StandardErrorCode.ALREADY_EXISTS : JdbcErrorCode.JDBC_ERROR), (Throwable)e);
        }
    }

    protected void renameTable(JdbcIdentity identity, String catalogName, String schemaName, String tableName, SchemaTableName newTable) {
        if (!schemaName.equals(newTable.getSchemaName())) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Table rename across schemas is not supported in PostgreSQL");
        }
        String sql = String.format("ALTER TABLE %s RENAME TO %s", this.quoted(catalogName, schemaName, tableName), this.quoted(newTable.getTableName()));
        try (Connection connection = this.connectionFactory.openConnection(identity);){
            this.execute(connection, sql);
        }
        catch (SQLException e) {
            throw new PrestoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
        }
    }

    public PreparedStatement getPreparedStatement(Connection connection, String sql) throws SQLException {
        connection.setAutoCommit(false);
        PreparedStatement statement = connection.prepareStatement(sql);
        statement.setFetchSize(1000);
        return statement;
    }

    protected ResultSet getTables(Connection connection, Optional<String> schemaName, Optional<String> tableName) throws SQLException {
        DatabaseMetaData metadata = connection.getMetaData();
        return metadata.getTables(connection.getCatalog(), PostgreSqlClient.escapeNamePattern(schemaName, (String)metadata.getSearchStringEscape()).orElse(null), PostgreSqlClient.escapeNamePattern(tableName, (String)metadata.getSearchStringEscape()).orElse(null), (String[])this.tableTypes.clone());
    }

    /*
     * Exception decompiling
     */
    public List<JdbcColumnHandle> getColumns(ConnectorSession session, JdbcTableHandle tableHandle) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Map<String, Integer> getArrayColumnDimensions(Connection connection, JdbcTableHandle tableHandle) throws SQLException {
        String sql = "SELECT att.attname, greatest(att.attndims, 1) AS attndims FROM pg_attribute att   JOIN pg_type attyp ON att.atttypid = attyp.oid  JOIN pg_class tbl ON tbl.oid = att.attrelid   JOIN pg_namespace ns ON tbl.relnamespace = ns.oid WHERE ns.nspname = ? AND tbl.relname = ? AND attyp.typcategory = 'A' ";
        try (PreparedStatement statement = connection.prepareStatement(sql);){
            statement.setString(1, tableHandle.getSchemaName());
            statement.setString(2, tableHandle.getTableName());
            HashMap<String, Integer> arrayColumnDimensions = new HashMap<String, Integer>();
            try (ResultSet resultSet = statement.executeQuery();){
                while (resultSet.next()) {
                    arrayColumnDimensions.put(resultSet.getString("attname"), resultSet.getInt("attndims"));
                }
            }
            HashMap<String, Integer> hashMap = arrayColumnDimensions;
            return hashMap;
        }
    }

    public Optional<ColumnMapping> toPrestoType(ConnectorSession session, Connection connection, JdbcTypeHandle typeHandle) {
        String jdbcTypeName = (String)typeHandle.getJdbcTypeName().orElseThrow(() -> new PrestoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, "Type name is missing: " + typeHandle));
        Optional mapping = this.getForcedMappingToVarchar(typeHandle);
        if (mapping.isPresent()) {
            return mapping;
        }
        switch (jdbcTypeName) {
            case "uuid": {
                return Optional.of(this.uuidColumnMapping());
            }
            case "jsonb": 
            case "json": {
                return Optional.of(this.jsonColumnMapping());
            }
            case "timestamptz": {
                return Optional.of(PostgreSqlClient.timestampWithTimeZoneColumnMapping());
            }
            case "hstore": {
                return Optional.of(this.hstoreColumnMapping(session));
            }
        }
        if (typeHandle.getJdbcType() == 12 && !jdbcTypeName.equals("varchar")) {
            return Optional.of(this.typedVarcharColumnMapping(jdbcTypeName));
        }
        if (typeHandle.getJdbcType() == 93) {
            return Optional.of(ColumnMapping.longMapping((Type)TimestampType.TIMESTAMP, (LongReadFunction)StandardColumnMappings.timestampReadFunction((ConnectorSession)session), (LongWriteFunction)PostgreSqlClient.timestampWriteFunction(session)));
        }
        if (typeHandle.getJdbcType() == 2003) {
            PostgreSqlConfig.ArrayMapping arrayMapping = PostgreSqlSessionProperties.getArrayMapping(session);
            if (arrayMapping == PostgreSqlConfig.ArrayMapping.DISABLED) {
                return Optional.empty();
            }
            JdbcTypeHandle baseElementTypeHandle = this.getArrayElementTypeHandle(connection, typeHandle);
            String baseElementTypeName = (String)baseElementTypeHandle.getJdbcTypeName().orElseThrow(() -> new PrestoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, "Element type name is missing: " + baseElementTypeHandle));
            if (baseElementTypeHandle.getJdbcType() == -3) {
                return Optional.empty();
            }
            Optional<ColumnMapping> baseElementMapping = this.toPrestoType(session, connection, baseElementTypeHandle);
            if (arrayMapping == PostgreSqlConfig.ArrayMapping.AS_ARRAY) {
                if (!typeHandle.getArrayDimensions().isPresent()) {
                    return Optional.empty();
                }
                return baseElementMapping.map(elementMapping -> {
                    ArrayType prestoArrayType = new ArrayType(elementMapping.getType());
                    ColumnMapping arrayColumnMapping = PostgreSqlClient.arrayColumnMapping(session, prestoArrayType, elementMapping, baseElementTypeName);
                    int arrayDimensions = (Integer)typeHandle.getArrayDimensions().get();
                    for (int i = 1; i < arrayDimensions; ++i) {
                        prestoArrayType = new ArrayType((Type)prestoArrayType);
                        arrayColumnMapping = PostgreSqlClient.arrayColumnMapping(session, prestoArrayType, arrayColumnMapping, baseElementTypeName);
                    }
                    return arrayColumnMapping;
                });
            }
            if (arrayMapping == PostgreSqlConfig.ArrayMapping.AS_JSON) {
                return baseElementMapping.map(elementMapping -> this.arrayAsJsonColumnMapping(session, (ColumnMapping)elementMapping));
            }
            throw new IllegalStateException("Unsupported array mapping type: " + (Object)((Object)arrayMapping));
        }
        return super.toPrestoType(session, connection, typeHandle);
    }

    public WriteMapping toWriteMapping(ConnectorSession session, Type type) {
        if (VarbinaryType.VARBINARY.equals((Object)type)) {
            return WriteMapping.sliceMapping((String)"bytea", (SliceWriteFunction)StandardColumnMappings.varbinaryWriteFunction());
        }
        if (TimestampType.TIMESTAMP.equals((Object)type)) {
            return WriteMapping.longMapping((String)"timestamp", (LongWriteFunction)PostgreSqlClient.timestampWriteFunction(session));
        }
        if (TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE.equals((Object)type)) {
            return WriteMapping.longMapping((String)"timestamptz", (LongWriteFunction)PostgreSqlClient.timestampWithTimeZoneWriteFunction());
        }
        if (TinyintType.TINYINT.equals((Object)type)) {
            return WriteMapping.longMapping((String)"smallint", (LongWriteFunction)StandardColumnMappings.tinyintWriteFunction());
        }
        if (type.equals(this.jsonType)) {
            return WriteMapping.sliceMapping((String)"jsonb", (SliceWriteFunction)PostgreSqlClient.typedVarcharWriteFunction("json"));
        }
        if (type.equals(this.uuidType)) {
            return WriteMapping.sliceMapping((String)"uuid", (SliceWriteFunction)PostgreSqlClient.uuidWriteFunction());
        }
        if (type instanceof ArrayType && PostgreSqlSessionProperties.getArrayMapping(session) == PostgreSqlConfig.ArrayMapping.AS_ARRAY) {
            Type elementType = ((ArrayType)type).getElementType();
            String elementDataType = this.toWriteMapping(session, elementType).getDataType();
            return WriteMapping.blockMapping((String)(elementDataType + "[]"), (BlockWriteFunction)PostgreSqlClient.arrayWriteFunction(session, elementType, TypeUtils.getArrayElementPgTypeName(session, this, elementType)));
        }
        return super.toWriteMapping(session, type);
    }

    protected Optional<BiFunction<String, Long, String>> limitFunction() {
        return Optional.of((sql, limit) -> sql + " LIMIT " + limit);
    }

    public boolean isLimitGuaranteed() {
        return true;
    }

    private static LongWriteFunction timestampWriteFunction(ConnectorSession session) {
        ZoneId sessionZone = ZoneId.of(session.getTimeZoneKey().getId());
        boolean legacyTimestamp = session.isLegacyTimestamp();
        return (statement, index, value) -> {
            LocalDateTime localDateTime = legacyTimestamp ? StandardColumnMappings.fromPrestoLegacyTimestamp((long)value, (ZoneId)sessionZone) : StandardColumnMappings.fromPrestoTimestamp((long)value);
            statement.setObject(index, TypeUtils.toPgTimestamp(localDateTime));
        };
    }

    private static ColumnMapping timestampWithTimeZoneColumnMapping() {
        return ColumnMapping.longMapping((Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE, (resultSet, columnIndex) -> {
            long millisUtc = resultSet.getTimestamp(columnIndex).getTime();
            return DateTimeEncoding.packDateTimeWithZone((long)millisUtc, (TimeZoneKey)TimeZoneKey.UTC_KEY);
        }, (LongWriteFunction)PostgreSqlClient.timestampWithTimeZoneWriteFunction());
    }

    private static LongWriteFunction timestampWithTimeZoneWriteFunction() {
        return (statement, index, value) -> {
            long millisUtc = DateTimeEncoding.unpackMillisUtc((long)value);
            statement.setTimestamp(index, new Timestamp(millisUtc));
        };
    }

    private ColumnMapping hstoreColumnMapping(ConnectorSession session) {
        return ColumnMapping.blockMapping((Type)this.varcharMapType, (BlockReadFunction)this.varcharMapReadFunction(), (BlockWriteFunction)this.hstoreWriteFunction(session), (UnaryOperator)ColumnMapping.DISABLE_PUSHDOWN);
    }

    private BlockReadFunction varcharMapReadFunction() {
        return (resultSet, columnIndex) -> {
            Map map = (Map)resultSet.getObject(columnIndex);
            BlockBuilder keyBlockBuilder = this.varcharMapType.getKeyType().createBlockBuilder(null, map.size());
            BlockBuilder valueBlockBuilder = this.varcharMapType.getValueType().createBlockBuilder(null, map.size());
            for (Map.Entry entry : map.entrySet()) {
                if (entry.getKey() == null) {
                    throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "hstore key is null");
                }
                this.varcharMapType.getKeyType().writeSlice(keyBlockBuilder, Slices.utf8Slice((String)((String)entry.getKey())));
                if (entry.getValue() == null) {
                    valueBlockBuilder.appendNull();
                    continue;
                }
                this.varcharMapType.getValueType().writeSlice(valueBlockBuilder, Slices.utf8Slice((String)((String)entry.getValue())));
            }
            return (Block)this.varcharMapType.createBlockFromKeyValue(Optional.empty(), new int[]{0, map.size()}, keyBlockBuilder.build(), valueBlockBuilder.build()).getObject(0, Block.class);
        };
    }

    private BlockWriteFunction hstoreWriteFunction(ConnectorSession session) {
        return (statement, index, block) -> {
            Preconditions.checkArgument((boolean)(block instanceof SingleMapBlock), (String)"wrong block type: %s. expected SingleMapBlock", (Object)block.getClass().getSimpleName());
            HashMap<Object, Object> map = new HashMap<Object, Object>();
            for (int i = 0; i < block.getPositionCount(); i += 2) {
                map.put(this.varcharMapType.getKeyType().getObjectValue(session, block, i), this.varcharMapType.getValueType().getObjectValue(session, block, i + 1));
            }
            statement.setObject(index, Collections.unmodifiableMap(map));
        };
    }

    private static ColumnMapping arrayColumnMapping(ConnectorSession session, ArrayType arrayType, ColumnMapping arrayElementMapping, String baseElementJdbcTypeName) {
        return ColumnMapping.blockMapping((Type)arrayType, (BlockReadFunction)PostgreSqlClient.arrayReadFunction(arrayType.getElementType(), arrayElementMapping.getReadFunction()), (BlockWriteFunction)PostgreSqlClient.arrayWriteFunction(session, arrayType.getElementType(), baseElementJdbcTypeName));
    }

    private static BlockReadFunction arrayReadFunction(Type elementType, ReadFunction elementReadFunction) {
        return (resultSet, columnIndex) -> {
            Array array = resultSet.getArray(columnIndex);
            BlockBuilder builder = elementType.createBlockBuilder(null, 10);
            try (ResultSet arrayAsResultSet = array.getResultSet();){
                while (arrayAsResultSet.next()) {
                    arrayAsResultSet.getObject(2);
                    if (arrayAsResultSet.wasNull()) {
                        builder.appendNull();
                        continue;
                    }
                    if (elementType.getJavaType() == Boolean.TYPE) {
                        elementType.writeBoolean(builder, ((BooleanReadFunction)elementReadFunction).readBoolean(arrayAsResultSet, 2));
                        continue;
                    }
                    if (elementType.getJavaType() == Long.TYPE) {
                        elementType.writeLong(builder, ((LongReadFunction)elementReadFunction).readLong(arrayAsResultSet, 2));
                        continue;
                    }
                    if (elementType.getJavaType() == Double.TYPE) {
                        elementType.writeDouble(builder, ((DoubleReadFunction)elementReadFunction).readDouble(arrayAsResultSet, 2));
                        continue;
                    }
                    if (elementType.getJavaType() == Slice.class) {
                        elementType.writeSlice(builder, ((SliceReadFunction)elementReadFunction).readSlice(arrayAsResultSet, 2));
                        continue;
                    }
                    if (elementType.getJavaType() == Block.class) {
                        elementType.writeObject(builder, (Object)((BlockReadFunction)elementReadFunction).readBlock(arrayAsResultSet, 2));
                        continue;
                    }
                    throw new IllegalStateException("Unsupported Java type: " + elementType.getJavaType());
                }
            }
            return builder.build();
        };
    }

    private static BlockWriteFunction arrayWriteFunction(ConnectorSession session, Type elementType, String baseElementJdbcTypeName) {
        return (statement, index, block) -> {
            Array jdbcArray = statement.getConnection().createArrayOf(baseElementJdbcTypeName, TypeUtils.getJdbcObjectArray(session, elementType, block));
            statement.setArray(index, jdbcArray);
        };
    }

    private ColumnMapping arrayAsJsonColumnMapping(ConnectorSession session, ColumnMapping baseElementMapping) {
        return ColumnMapping.sliceMapping((Type)this.jsonType, (SliceReadFunction)this.arrayAsJsonReadFunction(session, baseElementMapping), (statement, index, block) -> {
            throw new UnsupportedOperationException();
        }, (UnaryOperator)ColumnMapping.DISABLE_PUSHDOWN);
    }

    private SliceReadFunction arrayAsJsonReadFunction(ConnectorSession session, ColumnMapping baseElementMapping) {
        return (resultSet, columnIndex) -> {
            Object jdbcArray = resultSet.getArray(columnIndex).getArray();
            int arrayDimensions = TypeUtils.arrayDepth(jdbcArray);
            ReadFunction readFunction = baseElementMapping.getReadFunction();
            Type type = baseElementMapping.getType();
            for (int i = 0; i < arrayDimensions; ++i) {
                readFunction = PostgreSqlClient.arrayReadFunction(type, readFunction);
                type = new ArrayType(type);
            }
            Block block = ((BlockReadFunction)readFunction).readBlock(resultSet, columnIndex);
            try {
                return this.typeManager.getCoercion(type, this.jsonType).invokeExact(session, block);
            }
            catch (Throwable throwable) {
                throw new PrestoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, "Cast to JSON failed: " + throwable.getMessage(), throwable);
            }
        };
    }

    private JdbcTypeHandle getArrayElementTypeHandle(Connection connection, JdbcTypeHandle arrayTypeHandle) {
        String jdbcTypeName = (String)arrayTypeHandle.getJdbcTypeName().orElseThrow(() -> new PrestoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, "Type name is missing: " + arrayTypeHandle));
        try {
            TypeInfo typeInfo = connection.unwrap(PgConnection.class).getTypeInfo();
            int pgElementOid = typeInfo.getPGArrayElement(typeInfo.getPGType(jdbcTypeName));
            return new JdbcTypeHandle(typeInfo.getSQLType(pgElementOid), Optional.of(typeInfo.getPGType(pgElementOid)), arrayTypeHandle.getColumnSize(), arrayTypeHandle.getDecimalDigits(), arrayTypeHandle.getArrayDimensions());
        }
        catch (SQLException e) {
            throw new PrestoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
        }
    }

    private ColumnMapping jsonColumnMapping() {
        return ColumnMapping.sliceMapping((Type)this.jsonType, (resultSet, columnIndex) -> PostgreSqlClient.jsonParse(Slices.utf8Slice((String)resultSet.getString(columnIndex))), (SliceWriteFunction)PostgreSqlClient.typedVarcharWriteFunction("json"), (UnaryOperator)ColumnMapping.DISABLE_PUSHDOWN);
    }

    private ColumnMapping typedVarcharColumnMapping(String jdbcTypeName) {
        return ColumnMapping.sliceMapping((Type)VarcharType.VARCHAR, (resultSet, columnIndex) -> Slices.utf8Slice((String)resultSet.getString(columnIndex)), (SliceWriteFunction)PostgreSqlClient.typedVarcharWriteFunction(jdbcTypeName));
    }

    private static SliceWriteFunction typedVarcharWriteFunction(String jdbcTypeName) {
        return (statement, index, value) -> {
            PGobject pgObject = new PGobject();
            pgObject.setType(jdbcTypeName);
            pgObject.setValue(value.toStringUtf8());
            statement.setObject(index, pgObject);
        };
    }

    private static SliceWriteFunction uuidWriteFunction() {
        return (statement, index, value) -> {
            UUID uuid = new UUID(value.getLong(0), value.getLong(8));
            statement.setObject(index, (Object)uuid, 1111);
        };
    }

    private static Slice uuidSlice(UUID uuid) {
        return Slices.wrappedLongArray((long[])new long[]{uuid.getMostSignificantBits(), uuid.getLeastSignificantBits()});
    }

    private ColumnMapping uuidColumnMapping() {
        return ColumnMapping.sliceMapping((Type)this.uuidType, (resultSet, columnIndex) -> PostgreSqlClient.uuidSlice((UUID)resultSet.getObject(columnIndex)), (SliceWriteFunction)PostgreSqlClient.uuidWriteFunction());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Slice jsonParse(Slice slice) {
        try (JsonParser parser = PostgreSqlClient.createJsonParser(slice);){
            byte[] in = slice.getBytes();
            DynamicSliceOutput dynamicSliceOutput = new DynamicSliceOutput(in.length);
            SORTED_MAPPER.writeValue((OutputStream)dynamicSliceOutput, SORTED_MAPPER.readValue(parser, Object.class));
            parser.nextToken();
            Slice slice2 = dynamicSliceOutput.slice();
            return slice2;
        }
        catch (Exception e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, String.format("Cannot convert '%s' to JSON", slice.toStringUtf8()));
        }
    }

    private static JsonParser createJsonParser(Slice json) throws IOException {
        return JSON_FACTORY.createParser((Reader)new InputStreamReader((InputStream)json.getInput(), StandardCharsets.UTF_8));
    }
}

