/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.postgresql;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import com.google.inject.multibindings.Multibinder;
import io.airlift.configuration.ConfigBinder;
import io.prestosql.plugin.jdbc.BaseJdbcConfig;
import io.prestosql.plugin.jdbc.ConnectionFactory;
import io.prestosql.plugin.jdbc.DriverConnectionFactory;
import io.prestosql.plugin.jdbc.JdbcClient;
import io.prestosql.plugin.jdbc.SessionPropertiesProvider;
import io.prestosql.plugin.jdbc.credential.CredentialProvider;
import io.prestosql.plugin.postgresql.PostgreSqlClient;
import io.prestosql.plugin.postgresql.PostgreSqlConfig;
import io.prestosql.plugin.postgresql.PostgreSqlSessionProperties;
import org.postgresql.Driver;

public class PostgreSqlClientModule
implements Module {
    public void configure(Binder binder) {
        binder.bind(JdbcClient.class).to(PostgreSqlClient.class).in(Scopes.SINGLETON);
        ConfigBinder.configBinder((Binder)binder).bindConfig(BaseJdbcConfig.class);
        ConfigBinder.configBinder((Binder)binder).bindConfig(PostgreSqlConfig.class);
        Multibinder.newSetBinder((Binder)binder, SessionPropertiesProvider.class).addBinding().to(PostgreSqlSessionProperties.class).in(Scopes.SINGLETON);
    }

    @Provides
    @Singleton
    public ConnectionFactory getConnectionFactory(BaseJdbcConfig config, CredentialProvider credentialProvider) {
        return new DriverConnectionFactory((java.sql.Driver)new Driver(), config, credentialProvider);
    }
}

