/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.jdbc;

import io.prestosql.plugin.jdbc.InternalBaseJdbc;
import io.prestosql.plugin.jdbc.JdbcClient;
import io.prestosql.plugin.jdbc.JdbcMetadata;
import io.prestosql.plugin.jdbc.JdbcMetadataConfig;
import io.prestosql.plugin.jdbc.TransactionScopeCachingJdbcClient;
import java.util.Objects;
import javax.inject.Inject;

public class JdbcMetadataFactory {
    private final JdbcClient jdbcClient;
    private final boolean allowDropTable;

    @Inject
    public JdbcMetadataFactory(@InternalBaseJdbc JdbcClient jdbcClient, JdbcMetadataConfig config) {
        this.jdbcClient = Objects.requireNonNull(jdbcClient, "jdbcClient is null");
        Objects.requireNonNull(config, "config is null");
        this.allowDropTable = config.isAllowDropTable();
    }

    public JdbcMetadata create() {
        return new JdbcMetadata(new TransactionScopeCachingJdbcClient(this.jdbcClient), this.allowDropTable);
    }
}

