/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.jdbc.credential;

import io.prestosql.plugin.jdbc.BaseJdbcAuthenticationConfig;
import io.prestosql.plugin.jdbc.JdbcIdentity;
import io.prestosql.plugin.jdbc.credential.CredentialProvider;
import io.prestosql.plugin.jdbc.credential.ForExtraCredentialProvider;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;

public class ExtraCredentialProvider
implements CredentialProvider {
    private final Optional<String> userCredentialName;
    private final Optional<String> passwordCredentialName;
    private final CredentialProvider delegate;

    @Inject
    public ExtraCredentialProvider(BaseJdbcAuthenticationConfig config, @ForExtraCredentialProvider CredentialProvider delegate) {
        this(Optional.ofNullable(config.getUserCredentialName()), Optional.ofNullable(config.getPasswordCredentialName()), delegate);
    }

    public ExtraCredentialProvider(Optional<String> userCredentialName, Optional<String> passwordCredentialName, CredentialProvider delegate) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.userCredentialName = Objects.requireNonNull(userCredentialName, "userCredentialName is null");
        this.passwordCredentialName = Objects.requireNonNull(passwordCredentialName, "passwordCredentialName is null");
    }

    @Override
    public Optional<String> getConnectionUser(Optional<JdbcIdentity> jdbcIdentity) {
        Map<String, String> extraCredentials;
        if (jdbcIdentity.isPresent() && this.userCredentialName.isPresent() && (extraCredentials = jdbcIdentity.get().getExtraCredentials()).containsKey(this.userCredentialName.get())) {
            return Optional.of(extraCredentials.get(this.userCredentialName.get()));
        }
        return this.delegate.getConnectionUser(jdbcIdentity);
    }

    @Override
    public Optional<String> getConnectionPassword(Optional<JdbcIdentity> jdbcIdentity) {
        Map<String, String> extraCredentials;
        if (jdbcIdentity.isPresent() && this.passwordCredentialName.isPresent() && (extraCredentials = jdbcIdentity.get().getExtraCredentials()).containsKey(this.passwordCredentialName.get())) {
            return Optional.of(extraCredentials.get(this.passwordCredentialName.get()));
        }
        return this.delegate.getConnectionPassword(jdbcIdentity);
    }
}

