/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.jdbc.jmx;

import io.prestosql.plugin.jdbc.ConnectionFactory;
import io.prestosql.plugin.jdbc.JdbcIdentity;
import io.prestosql.plugin.jdbc.jmx.JdbcApiStats;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Objects;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

public class StatisticsAwareConnectionFactory
implements ConnectionFactory {
    private final JdbcApiStats openConnection = new JdbcApiStats();
    private final JdbcApiStats closeConnection = new JdbcApiStats();
    private final ConnectionFactory delegate;

    public StatisticsAwareConnectionFactory(ConnectionFactory delegate) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
    }

    @Override
    public Connection openConnection(JdbcIdentity identity) throws SQLException {
        return this.openConnection.wrap(() -> this.delegate.openConnection(identity));
    }

    @Override
    public void close() throws SQLException {
        this.closeConnection.wrap(() -> this.delegate.close());
    }

    @Managed
    @Nested
    public JdbcApiStats getOpenConnection() {
        return this.openConnection;
    }

    @Managed
    @Nested
    public JdbcApiStats getCloseConnection() {
        return this.closeConnection;
    }
}

