/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.base.authentication;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.airlift.log.Logger;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.InetAddress;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.Principal;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;

public class KerberosAuthentication {
    private static final Logger log = Logger.get(KerberosAuthentication.class);
    private static final String KERBEROS_LOGIN_MODULE = "com.sun.security.auth.module.Krb5LoginModule";
    private static final String HOSTNAME_PATTERN = "_HOST";
    private final KerberosPrincipal principal;
    private final Configuration configuration;

    public KerberosAuthentication(String principal, String keytabLocation) {
        Objects.requireNonNull(principal, "principal is null");
        Objects.requireNonNull(keytabLocation, "keytabLocation is null");
        Path keytabPath = Paths.get(keytabLocation, new String[0]);
        Preconditions.checkArgument((boolean)Files.exists(keytabPath, new LinkOption[0]), (Object)("keytab does not exist: " + keytabLocation));
        Preconditions.checkArgument((boolean)Files.isReadable(keytabPath), (Object)("keytab is not readable: " + keytabLocation));
        this.principal = KerberosAuthentication.createKerberosPrincipal(principal);
        this.configuration = KerberosAuthentication.createConfiguration(this.principal.getName(), keytabLocation);
    }

    public Subject getSubject() {
        Subject subject = new Subject(false, (Set<? extends Principal>)ImmutableSet.of((Object)this.principal), Collections.emptySet(), Collections.emptySet());
        try {
            LoginContext loginContext = new LoginContext("", subject, null, this.configuration);
            loginContext.login();
            return loginContext.getSubject();
        }
        catch (LoginException e) {
            throw new RuntimeException(e);
        }
    }

    private static KerberosPrincipal createKerberosPrincipal(String principal) {
        try {
            return new KerberosPrincipal(KerberosAuthentication.getServerPrincipal(principal, InetAddress.getLocalHost().getCanonicalHostName()));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static Configuration createConfiguration(String principal, String keytabLocation) {
        ImmutableMap.Builder optionsBuilder = ImmutableMap.builder().put((Object)"useKeyTab", (Object)"true").put((Object)"storeKey", (Object)"true").put((Object)"doNotPrompt", (Object)"true").put((Object)"isInitiator", (Object)"true").put((Object)"principal", (Object)principal).put((Object)"keyTab", (Object)keytabLocation);
        if (log.isDebugEnabled()) {
            optionsBuilder.put((Object)"debug", (Object)"true");
        }
        ImmutableMap options = optionsBuilder.build();
        return new Configuration((Map)options){
            final /* synthetic */ Map val$options;
            {
                this.val$options = map;
            }

            @Override
            public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
                return new AppConfigurationEntry[]{new AppConfigurationEntry(KerberosAuthentication.KERBEROS_LOGIN_MODULE, AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, this.val$options)};
            }
        };
    }

    private static String getServerPrincipal(String principal, String hostname) {
        String[] components = principal.split("[/@]");
        if (components.length != 3 || !components[1].equals(HOSTNAME_PATTERN)) {
            return principal;
        }
        return String.format("%s/%s@%s", components[0], hostname.toLowerCase(Locale.ENGLISH), components[2]);
    }
}

