/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.base.security;

import io.prestosql.spi.connector.CatalogSchemaName;
import io.prestosql.spi.connector.CatalogSchemaTableName;
import io.prestosql.spi.connector.ColumnMetadata;
import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.spi.security.PrestoPrincipal;
import io.prestosql.spi.security.Privilege;
import io.prestosql.spi.security.SystemAccessControl;
import io.prestosql.spi.security.SystemSecurityContext;
import java.security.Principal;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;

public abstract class ForwardingSystemAccessControl
implements SystemAccessControl {
    public static SystemAccessControl of(final Supplier<SystemAccessControl> systemAccessControlSupplier) {
        Objects.requireNonNull(systemAccessControlSupplier, "systemAccessControlSupplier is null");
        return new ForwardingSystemAccessControl(){

            @Override
            protected SystemAccessControl delegate() {
                return (SystemAccessControl)systemAccessControlSupplier.get();
            }
        };
    }

    protected abstract SystemAccessControl delegate();

    public void checkCanSetUser(Optional<Principal> principal, String userName) {
        this.delegate().checkCanSetUser(principal, userName);
    }

    public void checkCanSetSystemSessionProperty(SystemSecurityContext context, String propertyName) {
        this.delegate().checkCanSetSystemSessionProperty(context, propertyName);
    }

    public void checkCanAccessCatalog(SystemSecurityContext context, String catalogName) {
        this.delegate().checkCanAccessCatalog(context, catalogName);
    }

    public Set<String> filterCatalogs(SystemSecurityContext context, Set<String> catalogs) {
        return this.delegate().filterCatalogs(context, catalogs);
    }

    public void checkCanCreateSchema(SystemSecurityContext context, CatalogSchemaName schema) {
        this.delegate().checkCanCreateSchema(context, schema);
    }

    public void checkCanDropSchema(SystemSecurityContext context, CatalogSchemaName schema) {
        this.delegate().checkCanDropSchema(context, schema);
    }

    public void checkCanRenameSchema(SystemSecurityContext context, CatalogSchemaName schema, String newSchemaName) {
        this.delegate().checkCanRenameSchema(context, schema, newSchemaName);
    }

    public void checkCanShowSchemas(SystemSecurityContext context, String catalogName) {
        this.delegate().checkCanShowSchemas(context, catalogName);
    }

    public Set<String> filterSchemas(SystemSecurityContext context, String catalogName, Set<String> schemaNames) {
        return this.delegate().filterSchemas(context, catalogName, schemaNames);
    }

    public void checkCanCreateTable(SystemSecurityContext context, CatalogSchemaTableName table) {
        this.delegate().checkCanCreateTable(context, table);
    }

    public void checkCanDropTable(SystemSecurityContext context, CatalogSchemaTableName table) {
        this.delegate().checkCanDropTable(context, table);
    }

    public void checkCanRenameTable(SystemSecurityContext context, CatalogSchemaTableName table, CatalogSchemaTableName newTable) {
        this.delegate().checkCanRenameTable(context, table, newTable);
    }

    public void checkCanSetTableComment(SystemSecurityContext context, CatalogSchemaTableName table) {
        this.delegate().checkCanSetTableComment(context, table);
    }

    public void checkCanShowTablesMetadata(SystemSecurityContext context, CatalogSchemaName schema) {
        this.delegate().checkCanShowTablesMetadata(context, schema);
    }

    public Set<SchemaTableName> filterTables(SystemSecurityContext context, String catalogName, Set<SchemaTableName> tableNames) {
        return this.delegate().filterTables(context, catalogName, tableNames);
    }

    public void checkCanShowColumnsMetadata(SystemSecurityContext context, CatalogSchemaTableName tableName) {
        this.delegate().checkCanShowColumnsMetadata(context, tableName);
    }

    public List<ColumnMetadata> filterColumns(SystemSecurityContext context, CatalogSchemaTableName tableName, List<ColumnMetadata> columns) {
        return this.delegate().filterColumns(context, tableName, columns);
    }

    public void checkCanAddColumn(SystemSecurityContext context, CatalogSchemaTableName table) {
        this.delegate().checkCanAddColumn(context, table);
    }

    public void checkCanDropColumn(SystemSecurityContext context, CatalogSchemaTableName table) {
        this.delegate().checkCanDropColumn(context, table);
    }

    public void checkCanRenameColumn(SystemSecurityContext context, CatalogSchemaTableName table) {
        this.delegate().checkCanRenameColumn(context, table);
    }

    public void checkCanSelectFromColumns(SystemSecurityContext context, CatalogSchemaTableName table, Set<String> columns) {
        this.delegate().checkCanSelectFromColumns(context, table, columns);
    }

    public void checkCanInsertIntoTable(SystemSecurityContext context, CatalogSchemaTableName table) {
        this.delegate().checkCanInsertIntoTable(context, table);
    }

    public void checkCanDeleteFromTable(SystemSecurityContext context, CatalogSchemaTableName table) {
        this.delegate().checkCanDeleteFromTable(context, table);
    }

    public void checkCanCreateView(SystemSecurityContext context, CatalogSchemaTableName view) {
        this.delegate().checkCanCreateView(context, view);
    }

    public void checkCanDropView(SystemSecurityContext context, CatalogSchemaTableName view) {
        this.delegate().checkCanDropView(context, view);
    }

    public void checkCanCreateViewWithSelectFromColumns(SystemSecurityContext context, CatalogSchemaTableName table, Set<String> columns) {
        this.delegate().checkCanCreateViewWithSelectFromColumns(context, table, columns);
    }

    public void checkCanSetCatalogSessionProperty(SystemSecurityContext context, String catalogName, String propertyName) {
        this.delegate().checkCanSetCatalogSessionProperty(context, catalogName, propertyName);
    }

    public void checkCanGrantTablePrivilege(SystemSecurityContext context, Privilege privilege, CatalogSchemaTableName table, PrestoPrincipal grantee, boolean withGrantOption) {
        this.delegate().checkCanGrantTablePrivilege(context, privilege, table, grantee, withGrantOption);
    }

    public void checkCanRevokeTablePrivilege(SystemSecurityContext context, Privilege privilege, CatalogSchemaTableName table, PrestoPrincipal revokee, boolean grantOptionFor) {
        this.delegate().checkCanRevokeTablePrivilege(context, privilege, table, revokee, grantOptionFor);
    }

    public void checkCanShowRoles(SystemSecurityContext context, String catalogName) {
        this.delegate().checkCanShowRoles(context, catalogName);
    }
}

