/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.postgresql;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.log.Logger;
import io.airlift.log.Logging;
import io.airlift.testing.Closeables;
import io.prestosql.Session;
import io.prestosql.plugin.postgresql.PostgreSqlPlugin;
import io.prestosql.plugin.postgresql.TestingPostgreSqlServer;
import io.prestosql.plugin.tpch.TpchPlugin;
import io.prestosql.spi.Plugin;
import io.prestosql.testing.DistributedQueryRunner;
import io.prestosql.testing.QueryAssertions;
import io.prestosql.testing.QueryRunner;
import io.prestosql.testing.TestingSession;
import io.prestosql.tpch.TpchTable;
import java.io.Closeable;
import java.util.HashMap;
import java.util.Map;

public final class PostgreSqlQueryRunner {
    private static final String TPCH_SCHEMA = "tpch";

    private PostgreSqlQueryRunner() {
    }

    public static QueryRunner createPostgreSqlQueryRunner(TestingPostgreSqlServer server, TpchTable<?> ... tables) throws Exception {
        return PostgreSqlQueryRunner.createPostgreSqlQueryRunner(server, (Map<String, String>)ImmutableMap.of(), (Map<String, String>)ImmutableMap.of(), ImmutableList.copyOf((Object[])tables));
    }

    public static DistributedQueryRunner createPostgreSqlQueryRunner(TestingPostgreSqlServer server, Map<String, String> extraProperties, Map<String, String> connectorProperties, Iterable<TpchTable<?>> tables) throws Exception {
        DistributedQueryRunner queryRunner = null;
        try {
            queryRunner = DistributedQueryRunner.builder((Session)PostgreSqlQueryRunner.createSession()).setExtraProperties(extraProperties).build();
            queryRunner.installPlugin((Plugin)new TpchPlugin());
            queryRunner.createCatalog(TPCH_SCHEMA, TPCH_SCHEMA);
            connectorProperties = new HashMap<String, String>((Map<String, String>)ImmutableMap.copyOf(connectorProperties));
            connectorProperties.putIfAbsent("connection-url", server.getJdbcUrl());
            connectorProperties.putIfAbsent("allow-drop-table", "true");
            connectorProperties.putIfAbsent("postgresql.include-system-tables", "true");
            server.execute("CREATE SCHEMA tpch");
            queryRunner.installPlugin((Plugin)new PostgreSqlPlugin());
            queryRunner.createCatalog("postgresql", "postgresql", connectorProperties);
            QueryAssertions.copyTpchTables((QueryRunner)queryRunner, (String)TPCH_SCHEMA, (String)"tiny", (Session)PostgreSqlQueryRunner.createSession(), tables);
            return queryRunner;
        }
        catch (Throwable e) {
            Closeables.closeAllSuppress((Throwable)e, (Closeable[])new Closeable[]{queryRunner, server});
            throw e;
        }
    }

    public static Session createSession() {
        return TestingSession.testSessionBuilder().setCatalog("postgresql").setSchema(TPCH_SCHEMA).build();
    }

    public static void main(String[] args) throws Exception {
        Logging.initialize();
        DistributedQueryRunner queryRunner = PostgreSqlQueryRunner.createPostgreSqlQueryRunner(new TestingPostgreSqlServer(), (Map<String, String>)ImmutableMap.of((Object)"http-server.http.port", (Object)"8080"), (Map<String, String>)ImmutableMap.of(), TpchTable.getTables());
        Logger log = Logger.get(PostgreSqlQueryRunner.class);
        log.info("======== SERVER STARTED ========");
        log.info("\n====\n%s\n====", new Object[]{queryRunner.getCoordinator().getBaseUrl()});
    }
}

