/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.postgresql;

import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.MetadataManager;
import io.prestosql.plugin.jdbc.BaseJdbcConfig;
import io.prestosql.plugin.jdbc.ColumnMapping;
import io.prestosql.plugin.jdbc.JdbcClient;
import io.prestosql.plugin.jdbc.JdbcColumnHandle;
import io.prestosql.plugin.jdbc.JdbcExpression;
import io.prestosql.plugin.jdbc.JdbcTypeHandle;
import io.prestosql.plugin.postgresql.PostgreSqlClient;
import io.prestosql.plugin.postgresql.PostgreSqlConfig;
import io.prestosql.spi.connector.AggregateFunction;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.expression.Variable;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.BooleanType;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeManager;
import io.prestosql.testing.TestingConnectorSession;
import io.prestosql.testing.assertions.Assert;
import io.prestosql.type.InternalTypeManager;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class TestPostgreSqlClient {
    private static final TypeManager TYPE_MANAGER = new InternalTypeManager((Metadata)MetadataManager.createTestMetadataManager());
    private static final JdbcColumnHandle BIGINT_COLUMN = JdbcColumnHandle.builder().setColumnName("c_bigint").setColumnType((Type)BigintType.BIGINT).setJdbcTypeHandle(new JdbcTypeHandle(-5, Optional.of("int8"), 0, 0, Optional.empty(), Optional.empty())).build();
    private static final JdbcColumnHandle DOUBLE_COLUMN = JdbcColumnHandle.builder().setColumnName("c_double").setColumnType((Type)DoubleType.DOUBLE).setJdbcTypeHandle(new JdbcTypeHandle(8, Optional.of("double"), 0, 0, Optional.empty(), Optional.empty())).build();
    private static final JdbcClient JDBC_CLIENT = new PostgreSqlClient(new BaseJdbcConfig(), new PostgreSqlConfig(), identity -> {
        throw new UnsupportedOperationException();
    }, TYPE_MANAGER);

    @Test
    public void testImplementCount() {
        Variable bigintVariable = new Variable("v_bigint", (Type)BigintType.BIGINT);
        Variable doubleVariable = new Variable("v_double", (Type)BigintType.BIGINT);
        Optional<Variable> filter = Optional.of(new Variable("a_filter", (Type)BooleanType.BOOLEAN));
        this.testImplementAggregation(new AggregateFunction("count", (Type)BigintType.BIGINT, List.of(), List.of(), false, Optional.empty()), Map.of(), Optional.of("count(*)"));
        this.testImplementAggregation(new AggregateFunction("count", (Type)BigintType.BIGINT, List.of(bigintVariable), List.of(), false, Optional.empty()), Map.of(bigintVariable.getName(), BIGINT_COLUMN), Optional.of("count(\"c_bigint\")"));
        this.testImplementAggregation(new AggregateFunction("count", (Type)BigintType.BIGINT, List.of(doubleVariable), List.of(), false, Optional.empty()), Map.of(doubleVariable.getName(), DOUBLE_COLUMN), Optional.of("count(\"c_double\")"));
        this.testImplementAggregation(new AggregateFunction("count", (Type)BigintType.BIGINT, List.of(bigintVariable), List.of(), true, Optional.empty()), Map.of(bigintVariable.getName(), BIGINT_COLUMN), Optional.empty());
        this.testImplementAggregation(new AggregateFunction("count", (Type)BigintType.BIGINT, List.of(), List.of(), false, filter), Map.of(), Optional.empty());
        this.testImplementAggregation(new AggregateFunction("count", (Type)BigintType.BIGINT, List.of(bigintVariable), List.of(), false, filter), Map.of(bigintVariable.getName(), BIGINT_COLUMN), Optional.empty());
    }

    @Test
    public void testImplementSum() {
        Variable bigintVariable = new Variable("v_bigint", (Type)BigintType.BIGINT);
        Variable doubleVariable = new Variable("v_double", (Type)DoubleType.DOUBLE);
        Optional<Variable> filter = Optional.of(new Variable("a_filter", (Type)BooleanType.BOOLEAN));
        this.testImplementAggregation(new AggregateFunction("sum", (Type)BigintType.BIGINT, List.of(bigintVariable), List.of(), false, Optional.empty()), Map.of(bigintVariable.getName(), BIGINT_COLUMN), Optional.of("sum(\"c_bigint\")"));
        this.testImplementAggregation(new AggregateFunction("sum", (Type)DoubleType.DOUBLE, List.of(doubleVariable), List.of(), false, Optional.empty()), Map.of(doubleVariable.getName(), DOUBLE_COLUMN), Optional.of("sum(\"c_double\")"));
        this.testImplementAggregation(new AggregateFunction("sum", (Type)BigintType.BIGINT, List.of(bigintVariable), List.of(), true, Optional.empty()), Map.of(bigintVariable.getName(), BIGINT_COLUMN), Optional.empty());
        this.testImplementAggregation(new AggregateFunction("sum", (Type)BigintType.BIGINT, List.of(bigintVariable), List.of(), false, filter), Map.of(bigintVariable.getName(), BIGINT_COLUMN), Optional.empty());
    }

    private void testImplementAggregation(AggregateFunction aggregateFunction, Map<String, ColumnHandle> assignments, Optional<String> expectedExpression) {
        Optional result = JDBC_CLIENT.implementAggregation(TestingConnectorSession.SESSION, aggregateFunction, assignments);
        if (expectedExpression.isEmpty()) {
            Assertions.assertThat((Optional)result).isEmpty();
        } else {
            Assertions.assertThat((Optional)result).isPresent();
            Assert.assertEquals((String)((JdbcExpression)result.get()).getExpression(), (String)expectedExpression.get());
            Optional columnMapping = JDBC_CLIENT.toPrestoType(TestingConnectorSession.SESSION, null, ((JdbcExpression)result.get()).getJdbcTypeHandle());
            org.testng.Assert.assertTrue((boolean)columnMapping.isPresent(), (String)("No mapping for: " + ((JdbcExpression)result.get()).getJdbcTypeHandle()));
            Assert.assertEquals((Object)((ColumnMapping)columnMapping.get()).getType(), (Object)aggregateFunction.getOutputType());
        }
    }
}

