/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.postgresql;

import com.google.common.collect.ImmutableMap;
import io.prestosql.plugin.postgresql.PostgreSqlConfig;
import io.prestosql.plugin.postgresql.PostgreSqlQueryRunner;
import io.prestosql.plugin.postgresql.TestingPostgreSqlServer;
import io.prestosql.testing.AbstractTestDistributedQueries;
import io.prestosql.testing.QueryRunner;
import io.prestosql.testing.sql.JdbcSqlExecutor;
import io.prestosql.testing.sql.SqlExecutor;
import io.prestosql.testing.sql.TestTable;
import io.prestosql.tpch.TpchTable;
import java.util.Map;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

@Test
public class TestPostgreSqlDistributedQueries
extends AbstractTestDistributedQueries {
    private TestingPostgreSqlServer postgreSqlServer;

    protected QueryRunner createQueryRunner() throws Exception {
        this.postgreSqlServer = new TestingPostgreSqlServer();
        return PostgreSqlQueryRunner.createPostgreSqlQueryRunner(this.postgreSqlServer, (Map<String, String>)ImmutableMap.of(), (Map<String, String>)ImmutableMap.builder().put((Object)"metadata.cache-ttl", (Object)"10m").put((Object)"metadata.cache-missing", (Object)"true").build(), TpchTable.getTables());
    }

    @AfterClass(alwaysRun=true)
    public final void destroy() {
        this.postgreSqlServer.close();
    }

    protected boolean supportsViews() {
        return false;
    }

    protected boolean supportsArrays() {
        return new PostgreSqlConfig().getArrayMapping() != PostgreSqlConfig.ArrayMapping.DISABLED;
    }

    protected TestTable createTableWithDefaultColumns() {
        return new TestTable((SqlExecutor)new JdbcSqlExecutor(this.postgreSqlServer.getJdbcUrl()), "tpch.table", "(col_required BIGINT NOT NULL,col_nullable BIGINT,col_default BIGINT DEFAULT 43,col_nonnull_default BIGINT NOT NULL DEFAULT 42,col_required2 BIGINT NOT NULL)");
    }

    public void testCommentTable() {
        this.assertQueryFails("COMMENT ON TABLE orders IS 'hello'", "This connector does not support setting table comments");
    }

    public void testDelete() {
    }
}

