/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.postgresql;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.BaseEncoding;
import io.airlift.json.JsonCodec;
import io.prestosql.Session;
import io.prestosql.plugin.jdbc.DecimalConfig;
import io.prestosql.plugin.jdbc.UnsupportedTypeHandling;
import io.prestosql.plugin.postgresql.PostgreSqlConfig;
import io.prestosql.plugin.postgresql.PostgreSqlQueryRunner;
import io.prestosql.plugin.postgresql.TestingPostgreSqlServer;
import io.prestosql.spi.type.ArrayType;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.spi.type.RealType;
import io.prestosql.spi.type.SmallintType;
import io.prestosql.spi.type.TimeZoneKey;
import io.prestosql.spi.type.TimestampWithTimeZoneType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeSignature;
import io.prestosql.spi.type.VarbinaryType;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.testing.AbstractTestQueryFramework;
import io.prestosql.testing.QueryRunner;
import io.prestosql.testing.TestingSession;
import io.prestosql.testing.datatype.CreateAndInsertDataSetup;
import io.prestosql.testing.datatype.CreateAndPrestoInsertDataSetup;
import io.prestosql.testing.datatype.CreateAsSelectDataSetup;
import io.prestosql.testing.datatype.DataSetup;
import io.prestosql.testing.datatype.DataType;
import io.prestosql.testing.datatype.DataTypeTest;
import io.prestosql.testing.sql.JdbcSqlExecutor;
import io.prestosql.testing.sql.PrestoSqlExecutor;
import io.prestosql.testing.sql.SqlExecutor;
import io.prestosql.testing.sql.TestTable;
import io.prestosql.type.JsonType;
import io.prestosql.type.UuidType;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.charset.StandardCharsets;
import java.text.NumberFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test
public class TestPostgreSqlTypeMapping
extends AbstractTestQueryFramework {
    private static final LocalDate EPOCH_DAY = LocalDate.ofEpochDay(0L);
    private static final JsonCodec<List<Map<String, String>>> HSTORE_CODEC = JsonCodec.listJsonCodec((JsonCodec)JsonCodec.mapJsonCodec(String.class, String.class));
    private TestingPostgreSqlServer postgreSqlServer;
    private final LocalDateTime beforeEpoch = LocalDateTime.of(1958, 1, 1, 13, 18, 3, 123000000);
    private final LocalDateTime epoch = LocalDateTime.of(1970, 1, 1, 0, 0, 0);
    private final LocalDateTime afterEpoch = LocalDateTime.of(2019, 3, 18, 10, 1, 17, 987000000);
    private final ZoneId jvmZone = ZoneId.systemDefault();
    private final LocalDateTime timeGapInJvmZone1 = LocalDateTime.of(1970, 1, 1, 0, 13, 42);
    private final LocalDateTime timeGapInJvmZone2 = LocalDateTime.of(2018, 4, 1, 2, 13, 55, 123000000);
    private final LocalDateTime timeDoubledInJvmZone = LocalDateTime.of(2018, 10, 28, 1, 33, 17, 456000000);
    private final ZoneId vilnius = ZoneId.of("Europe/Vilnius");
    private final LocalDateTime timeGapInVilnius = LocalDateTime.of(2018, 3, 25, 3, 17, 17);
    private final LocalDateTime timeDoubledInVilnius = LocalDateTime.of(2018, 10, 28, 3, 33, 33, 333000000);
    private final ZoneId kathmandu = ZoneId.of("Asia/Kathmandu");
    private final LocalDateTime timeGapInKathmandu = LocalDateTime.of(1986, 1, 1, 0, 13, 7);
    private final ZoneOffset fixedOffsetEast = ZoneOffset.ofHoursMinutes(2, 17);
    private final ZoneOffset fixedOffsetWest = ZoneOffset.ofHoursMinutes(-7, -31);

    protected QueryRunner createQueryRunner() throws Exception {
        this.postgreSqlServer = new TestingPostgreSqlServer();
        return PostgreSqlQueryRunner.createPostgreSqlQueryRunner(this.postgreSqlServer, (Map<String, String>)ImmutableMap.of(), (Map<String, String>)ImmutableMap.of((Object)"jdbc-types-mapped-to-varchar", (Object)"Tsrange, Inet"), ImmutableList.of());
    }

    @AfterClass(alwaysRun=true)
    public final void destroy() {
        this.postgreSqlServer.close();
    }

    @BeforeClass
    public void setUp() {
        TestPostgreSqlTypeMapping.checkIsGap(this.jvmZone, this.timeGapInJvmZone1);
        TestPostgreSqlTypeMapping.checkIsGap(this.jvmZone, this.timeGapInJvmZone2);
        TestPostgreSqlTypeMapping.checkIsDoubled(this.jvmZone, this.timeDoubledInJvmZone);
        TestPostgreSqlTypeMapping.checkIsGap(this.vilnius, this.timeGapInVilnius);
        TestPostgreSqlTypeMapping.checkIsDoubled(this.vilnius, this.timeDoubledInVilnius);
        TestPostgreSqlTypeMapping.checkIsGap(this.kathmandu, this.timeGapInKathmandu);
        JdbcSqlExecutor executor = new JdbcSqlExecutor(this.postgreSqlServer.getJdbcUrl());
        executor.execute("CREATE EXTENSION hstore");
    }

    @Test
    public void testBasicTypes() {
        DataTypeTest.create((boolean)true).addRoundTrip(DataType.booleanDataType(), (Object)true).addRoundTrip(DataType.booleanDataType(), (Object)false).addRoundTrip(DataType.bigintDataType(), (Object)123456789012L).addRoundTrip(DataType.integerDataType(), (Object)1234567890).addRoundTrip(DataType.smallintDataType(), (Object)32456).addRoundTrip(DataType.doubleDataType(), (Object)123.45).addRoundTrip(DataType.realDataType(), (Object)Float.valueOf(123.45f)).addRoundTrip(DataType.dataType((String)"tinyint", (Type)SmallintType.SMALLINT, Object::toString, result -> (short)result.byteValue()), (Object)5).execute(this.getQueryRunner(), this.prestoCreateAsSelect("test_basic_types"));
    }

    @Test
    public void testVarbinary() {
        this.varbinaryTestCases((DataType<byte[]>)DataType.varbinaryDataType()).execute(this.getQueryRunner(), this.prestoCreateAsSelect("test_varbinary"));
        this.varbinaryTestCases(TestPostgreSqlTypeMapping.byteaDataType()).execute(this.getQueryRunner(), this.postgresCreateAndInsert("tpch.test_varbinary"));
    }

    private DataTypeTest varbinaryTestCases(DataType<byte[]> varbinaryDataType) {
        return DataTypeTest.create().addRoundTrip(varbinaryDataType, (Object)"hello".getBytes(StandardCharsets.UTF_8)).addRoundTrip(varbinaryDataType, (Object)"Pi\u0119kna \u0142\u0105ka w \u6771\u4eac\u90fd".getBytes(StandardCharsets.UTF_8)).addRoundTrip(varbinaryDataType, (Object)"Bag full of \ud83d\udcb0".getBytes(StandardCharsets.UTF_16LE)).addRoundTrip(varbinaryDataType, null).addRoundTrip(varbinaryDataType, (Object)new byte[0]).addRoundTrip(varbinaryDataType, (Object)new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 13, -7, 54, 122, -89, 0, 0, 0});
    }

    @Test
    public void testPrestoCreatedParameterizedVarchar() {
        this.varcharDataTypeTest().execute(this.getQueryRunner(), this.prestoCreateAsSelect("presto_test_parameterized_varchar"));
    }

    @Test
    public void testPostgreSqlCreatedParameterizedVarchar() {
        this.varcharDataTypeTest().execute(this.getQueryRunner(), this.postgresCreateAndInsert("tpch.postgresql_test_parameterized_varchar"));
    }

    private DataTypeTest varcharDataTypeTest() {
        return DataTypeTest.create().addRoundTrip(DataType.varcharDataType((int)10), (Object)"text_a").addRoundTrip(DataType.varcharDataType((int)255), (Object)"text_b").addRoundTrip(DataType.varcharDataType((int)65535), (Object)"text_d").addRoundTrip(DataType.varcharDataType((int)0xA00000), (Object)"text_f").addRoundTrip(DataType.varcharDataType(), (Object)"unbounded");
    }

    @Test
    public void testPrestoCreatedParameterizedVarcharUnicode() {
        this.unicodeVarcharDateTypeTest().execute(this.getQueryRunner(), this.prestoCreateAsSelect("postgresql_test_parameterized_varchar_unicode"));
    }

    @Test
    public void testPostgreSqlCreatedParameterizedVarcharUnicode() {
        this.unicodeVarcharDateTypeTest().execute(this.getQueryRunner(), this.postgresCreateAndInsert("tpch.postgresql_test_parameterized_varchar_unicode"));
    }

    @Test
    public void testPrestoCreatedParameterizedCharUnicode() {
        this.unicodeDataTypeTest(DataType::charDataType).execute(this.getQueryRunner(), this.prestoCreateAsSelect("postgresql_test_parameterized_char_unicode"));
    }

    @Test
    public void testPostgreSqlCreatedParameterizedCharUnicode() {
        this.unicodeDataTypeTest(DataType::charDataType).execute(this.getQueryRunner(), this.postgresCreateAndInsert("tpch.postgresql_test_parameterized_char_unicode"));
    }

    private DataTypeTest unicodeVarcharDateTypeTest() {
        return this.unicodeDataTypeTest(DataType::varcharDataType).addRoundTrip(DataType.varcharDataType(), (Object)"\u041d\u0443, \u043f\u043e\u0433\u043e\u0434\u0438!");
    }

    private DataTypeTest unicodeDataTypeTest(Function<Integer, DataType<String>> dataTypeFactory) {
        String sampleUnicodeText = "\u653b\u6bbb\u6a5f\u52d5\u968a";
        String sampleFourByteUnicodeCharacter = "\ud83d\ude02";
        return DataTypeTest.create().addRoundTrip(dataTypeFactory.apply(sampleUnicodeText.length()), (Object)sampleUnicodeText).addRoundTrip(dataTypeFactory.apply(32), (Object)sampleUnicodeText).addRoundTrip(dataTypeFactory.apply(20000), (Object)sampleUnicodeText).addRoundTrip(dataTypeFactory.apply(1), (Object)sampleFourByteUnicodeCharacter);
    }

    @Test
    public void testPostgresSqlCreatedDecimal() {
        this.decimalTests().execute(this.getQueryRunner(), this.postgresCreateAndInsert("tpch.test_decimal"));
    }

    @Test
    public void testPrestoCreatedDecimal() {
        this.decimalTests().execute(this.getQueryRunner(), this.prestoCreateAsSelect("test_decimal"));
    }

    private DataTypeTest decimalTests() {
        return DataTypeTest.create().addRoundTrip(DataType.decimalDataType((int)3, (int)0), (Object)new BigDecimal("193")).addRoundTrip(DataType.decimalDataType((int)3, (int)0), (Object)new BigDecimal("19")).addRoundTrip(DataType.decimalDataType((int)3, (int)0), (Object)new BigDecimal("-193")).addRoundTrip(DataType.decimalDataType((int)3, (int)1), (Object)new BigDecimal("10.0")).addRoundTrip(DataType.decimalDataType((int)3, (int)1), (Object)new BigDecimal("10.1")).addRoundTrip(DataType.decimalDataType((int)3, (int)1), (Object)new BigDecimal("-10.1")).addRoundTrip(DataType.decimalDataType((int)4, (int)2), (Object)new BigDecimal("2")).addRoundTrip(DataType.decimalDataType((int)4, (int)2), (Object)new BigDecimal("2.3")).addRoundTrip(DataType.decimalDataType((int)24, (int)2), (Object)new BigDecimal("2")).addRoundTrip(DataType.decimalDataType((int)24, (int)2), (Object)new BigDecimal("2.3")).addRoundTrip(DataType.decimalDataType((int)24, (int)2), (Object)new BigDecimal("123456789.3")).addRoundTrip(DataType.decimalDataType((int)24, (int)4), (Object)new BigDecimal("12345678901234567890.31")).addRoundTrip(DataType.decimalDataType((int)30, (int)5), (Object)new BigDecimal("3141592653589793238462643.38327")).addRoundTrip(DataType.decimalDataType((int)30, (int)5), (Object)new BigDecimal("-3141592653589793238462643.38327")).addRoundTrip(DataType.decimalDataType((int)38, (int)0), (Object)new BigDecimal("27182818284590452353602874713526624977")).addRoundTrip(DataType.decimalDataType((int)38, (int)0), (Object)new BigDecimal("-27182818284590452353602874713526624977"));
    }

    @Test
    public void testForcedMappingToVarchar() {
        JdbcSqlExecutor jdbcSqlExecutor = new JdbcSqlExecutor(this.postgreSqlServer.getJdbcUrl());
        jdbcSqlExecutor.execute("CREATE TABLE tpch.test_forced_varchar_mapping(tsrange_col tsrange, inet_col inet, tsrange_arr_col tsrange[], unsupported_nonforced_column tstzrange)");
        jdbcSqlExecutor.execute("INSERT INTO tpch.test_forced_varchar_mapping(tsrange_col, inet_col, tsrange_arr_col, unsupported_nonforced_column) VALUES ('[2010-01-01 14:30, 2010-01-01 15:30)'::tsrange, '172.0.0.1'::inet, array['[2010-01-01 14:30, 2010-01-01 15:30)'::tsrange], '[2010-01-01 14:30, 2010-01-01 15:30)'::tstzrange)");
        try {
            this.assertQuery(this.sessionWithArrayAsArray(), "SELECT column_name, data_type FROM information_schema.columns WHERE table_schema = 'tpch' AND table_name = 'test_forced_varchar_mapping'", "VALUES ('tsrange_col','varchar'),('inet_col','varchar'),('tsrange_arr_col','array(varchar)')");
            this.assertQuery(this.sessionWithArrayAsArray(), "SELECT * FROM tpch.test_forced_varchar_mapping", "VALUES ('[\"2010-01-01 14:30:00\",\"2010-01-01 15:30:00\")','172.0.0.1',ARRAY['[\"2010-01-01 14:30:00\",\"2010-01-01 15:30:00\")'])");
            this.assertQuery("SELECT 1 FROM tpch.test_forced_varchar_mapping WHERE tsrange_col = '[\"2010-01-01 14:30:00\",\"2010-01-01 15:30:00\")'", "VALUES 1");
            this.assertQuery("SELECT 1 FROM tpch.test_forced_varchar_mapping WHERE tsrange_col = 'some value'", "SELECT 1 WHERE false");
            this.assertQueryFails("INSERT INTO tpch.test_forced_varchar_mapping (tsrange_col) VALUES ('some value')", "Underlying type that is mapped to VARCHAR is not supported for INSERT: tsrange");
        }
        finally {
            jdbcSqlExecutor.execute("DROP TABLE tpch.test_forced_varchar_mapping");
        }
    }

    @Test
    public void testDecimalExceedingPrecisionMaxIgnored() {
        this.testUnsupportedDataTypeAsIgnored("decimal(50,0)", "12345678901234567890123456789012345678901234567890");
    }

    @Test
    public void testDecimalExceedingPrecisionMaxConvertedToVarchar() {
        this.testUnsupportedDataTypeConvertedToVarchar("decimal(50,0)", "12345678901234567890123456789012345678901234567890", "'12345678901234567890123456789012345678901234567890'");
    }

    @Test
    public void testDecimalExceedingPrecisionMaxWithExceedingIntegerValues() {
        JdbcSqlExecutor jdbcSqlExecutor = new JdbcSqlExecutor(this.postgreSqlServer.getJdbcUrl());
        try (TestTable testTable = new TestTable((SqlExecutor)jdbcSqlExecutor, "tpch.test_exceeding_max_decimal", "(d_col decimal(65,25))", Arrays.asList("1234567890123456789012345678901234567890.123456789", "-1234567890123456789012345678901234567890.123456789"));){
            this.assertQuery(this.sessionWithDecimalMappingAllowOverflow(RoundingMode.UNNECESSARY, 0), String.format("SELECT column_name, data_type FROM information_schema.columns WHERE table_schema = 'tpch' AND table_schema||'.'||table_name = '%s'", testTable.getName()), "VALUES ('d_col', 'decimal(38,0)')");
            this.assertQueryFails(this.sessionWithDecimalMappingAllowOverflow(RoundingMode.UNNECESSARY, 0), "SELECT d_col FROM " + testTable.getName(), "Rounding necessary");
            this.assertQueryFails(this.sessionWithDecimalMappingAllowOverflow(RoundingMode.HALF_UP, 0), "SELECT d_col FROM " + testTable.getName(), "Decimal overflow");
            this.assertQuery(this.sessionWithDecimalMappingStrict(UnsupportedTypeHandling.CONVERT_TO_VARCHAR), String.format("SELECT column_name, data_type FROM information_schema.columns WHERE table_schema = 'tpch' AND table_schema||'.'||table_name = '%s'", testTable.getName()), "VALUES ('d_col', 'varchar')");
            this.assertQuery(this.sessionWithDecimalMappingStrict(UnsupportedTypeHandling.CONVERT_TO_VARCHAR), "SELECT d_col FROM " + testTable.getName(), "VALUES ('1234567890123456789012345678901234567890.1234567890000000000000000'), ('-1234567890123456789012345678901234567890.1234567890000000000000000')");
        }
    }

    @Test
    public void testDecimalExceedingPrecisionMaxWithNonExceedingIntegerValues() {
        JdbcSqlExecutor jdbcSqlExecutor = new JdbcSqlExecutor(this.postgreSqlServer.getJdbcUrl());
        try (TestTable testTable = new TestTable((SqlExecutor)jdbcSqlExecutor, "tpch.test_exceeding_max_decimal", "(d_col decimal(60,20))", Arrays.asList("123456789012345678901234567890.123456789012345", "-123456789012345678901234567890.123456789012345"));){
            this.assertQuery(this.sessionWithDecimalMappingAllowOverflow(RoundingMode.UNNECESSARY, 0), String.format("SELECT column_name, data_type FROM information_schema.columns WHERE table_schema = 'tpch' AND table_schema||'.'||table_name = '%s'", testTable.getName()), "VALUES ('d_col', 'decimal(38,0)')");
            this.assertQueryFails(this.sessionWithDecimalMappingAllowOverflow(RoundingMode.UNNECESSARY, 0), "SELECT d_col FROM " + testTable.getName(), "Rounding necessary");
            this.assertQuery(this.sessionWithDecimalMappingAllowOverflow(RoundingMode.HALF_UP, 0), "SELECT d_col FROM " + testTable.getName(), "VALUES (123456789012345678901234567890), (-123456789012345678901234567890)");
            this.assertQuery(this.sessionWithDecimalMappingAllowOverflow(RoundingMode.UNNECESSARY, 8), String.format("SELECT column_name, data_type FROM information_schema.columns WHERE table_schema = 'tpch' AND table_schema||'.'||table_name = '%s'", testTable.getName()), "VALUES ('d_col', 'decimal(38,8)')");
            this.assertQueryFails(this.sessionWithDecimalMappingAllowOverflow(RoundingMode.UNNECESSARY, 8), "SELECT d_col FROM " + testTable.getName(), "Rounding necessary");
            this.assertQuery(this.sessionWithDecimalMappingAllowOverflow(RoundingMode.HALF_UP, 8), "SELECT d_col FROM " + testTable.getName(), "VALUES (123456789012345678901234567890.12345679), (-123456789012345678901234567890.12345679)");
            this.assertQuery(this.sessionWithDecimalMappingAllowOverflow(RoundingMode.HALF_UP, 22), String.format("SELECT column_name, data_type FROM information_schema.columns WHERE table_schema = 'tpch' AND table_schema||'.'||table_name = '%s'", testTable.getName()), "VALUES ('d_col', 'decimal(38,20)')");
            this.assertQueryFails(this.sessionWithDecimalMappingAllowOverflow(RoundingMode.HALF_UP, 20), "SELECT d_col FROM " + testTable.getName(), "Decimal overflow");
            this.assertQueryFails(this.sessionWithDecimalMappingAllowOverflow(RoundingMode.HALF_UP, 9), "SELECT d_col FROM " + testTable.getName(), "Decimal overflow");
            this.assertQuery(this.sessionWithDecimalMappingStrict(UnsupportedTypeHandling.CONVERT_TO_VARCHAR), String.format("SELECT column_name, data_type FROM information_schema.columns WHERE table_schema = 'tpch' AND table_schema||'.'||table_name = '%s'", testTable.getName()), "VALUES ('d_col', 'varchar')");
            this.assertQuery(this.sessionWithDecimalMappingStrict(UnsupportedTypeHandling.CONVERT_TO_VARCHAR), "SELECT d_col FROM " + testTable.getName(), "VALUES ('123456789012345678901234567890.12345678901234500000'), ('-123456789012345678901234567890.12345678901234500000')");
        }
    }

    @Test(dataProvider="testDecimalExceedingPrecisionMaxProvider")
    public void testDecimalExceedingPrecisionMaxWithSupportedValues(int typePrecision, int typeScale) {
        JdbcSqlExecutor jdbcSqlExecutor = new JdbcSqlExecutor(this.postgreSqlServer.getJdbcUrl());
        try (TestTable testTable = new TestTable((SqlExecutor)jdbcSqlExecutor, "tpch.test_exceeding_max_decimal", String.format("(d_col decimal(%d,%d))", typePrecision, typeScale), Arrays.asList("12.01", "-12.01", "123", "-123", "1.12345678", "-1.12345678"));){
            this.assertQuery(this.sessionWithDecimalMappingAllowOverflow(RoundingMode.UNNECESSARY, 0), String.format("SELECT column_name, data_type FROM information_schema.columns WHERE table_schema = 'tpch' AND table_schema||'.'||table_name = '%s'", testTable.getName()), "VALUES ('d_col', 'decimal(38,0)')");
            this.assertQueryFails(this.sessionWithDecimalMappingAllowOverflow(RoundingMode.UNNECESSARY, 0), "SELECT d_col FROM " + testTable.getName(), "Rounding necessary");
            this.assertQuery(this.sessionWithDecimalMappingAllowOverflow(RoundingMode.HALF_UP, 0), "SELECT d_col FROM " + testTable.getName(), "VALUES (12), (-12), (123), (-123), (1), (-1)");
            this.assertQuery(this.sessionWithDecimalMappingAllowOverflow(RoundingMode.HALF_UP, 3), String.format("SELECT column_name, data_type FROM information_schema.columns WHERE table_schema = 'tpch' AND table_schema||'.'||table_name = '%s'", testTable.getName()), "VALUES ('d_col', 'decimal(38,3)')");
            this.assertQuery(this.sessionWithDecimalMappingAllowOverflow(RoundingMode.HALF_UP, 3), "SELECT d_col FROM " + testTable.getName(), "VALUES (12.01), (-12.01), (123), (-123), (1.123), (-1.123)");
            this.assertQueryFails(this.sessionWithDecimalMappingAllowOverflow(RoundingMode.UNNECESSARY, 3), "SELECT d_col FROM " + testTable.getName(), "Rounding necessary");
            this.assertQuery(this.sessionWithDecimalMappingAllowOverflow(RoundingMode.HALF_UP, 8), String.format("SELECT column_name, data_type FROM information_schema.columns WHERE table_schema = 'tpch' AND table_schema||'.'||table_name = '%s'", testTable.getName()), "VALUES ('d_col', 'decimal(38,8)')");
            this.assertQuery(this.sessionWithDecimalMappingAllowOverflow(RoundingMode.HALF_UP, 8), "SELECT d_col FROM " + testTable.getName(), "VALUES (12.01), (-12.01), (123), (-123), (1.12345678), (-1.12345678)");
            this.assertQuery(this.sessionWithDecimalMappingAllowOverflow(RoundingMode.HALF_UP, 9), "SELECT d_col FROM " + testTable.getName(), "VALUES (12.01), (-12.01), (123), (-123), (1.12345678), (-1.12345678)");
            this.assertQuery(this.sessionWithDecimalMappingAllowOverflow(RoundingMode.UNNECESSARY, 8), "SELECT d_col FROM " + testTable.getName(), "VALUES (12.01), (-12.01), (123), (-123), (1.12345678), (-1.12345678)");
        }
    }

    @DataProvider
    public Object[][] testDecimalExceedingPrecisionMaxProvider() {
        return new Object[][]{{40, 8}, {50, 10}};
    }

    @Test
    public void testDecimalUnspecifiedPrecisionWithSupportedValues() {
        JdbcSqlExecutor jdbcSqlExecutor = new JdbcSqlExecutor(this.postgreSqlServer.getJdbcUrl());
        try (TestTable testTable = new TestTable((SqlExecutor)jdbcSqlExecutor, "tpch.test_var_decimal", "(d_col decimal)", Arrays.asList("1.12", "123456.789", "-1.12", "-123456.789"));){
            this.assertQuery(this.sessionWithDecimalMappingAllowOverflow(RoundingMode.UNNECESSARY, 0), String.format("SELECT column_name, data_type FROM information_schema.columns WHERE table_schema = 'tpch' AND table_schema||'.'||table_name = '%s'", testTable.getName()), "VALUES ('d_col','decimal(38,0)')");
            this.assertQueryFails(this.sessionWithDecimalMappingAllowOverflow(RoundingMode.UNNECESSARY, 0), "SELECT d_col FROM " + testTable.getName(), "Rounding necessary");
            this.assertQuery(this.sessionWithDecimalMappingAllowOverflow(RoundingMode.HALF_UP, 0), "SELECT d_col FROM " + testTable.getName(), "VALUES (1), (123457), (-1), (-123457)");
            this.assertQueryFails(this.sessionWithDecimalMappingAllowOverflow(RoundingMode.UNNECESSARY, 1), "SELECT d_col FROM " + testTable.getName(), "Rounding necessary");
            this.assertQuery(this.sessionWithDecimalMappingAllowOverflow(RoundingMode.HALF_UP, 1), String.format("SELECT column_name, data_type FROM information_schema.columns WHERE table_schema = 'tpch' AND table_schema||'.'||table_name = '%s'", testTable.getName()), "VALUES ('d_col','decimal(38,1)')");
            this.assertQuery(this.sessionWithDecimalMappingAllowOverflow(RoundingMode.HALF_UP, 1), "SELECT d_col FROM " + testTable.getName(), "VALUES (1.1), (123456.8), (-1.1), (-123456.8)");
            this.assertQueryFails(this.sessionWithDecimalMappingAllowOverflow(RoundingMode.UNNECESSARY, 2), "SELECT d_col FROM " + testTable.getName(), "Rounding necessary");
            this.assertQuery(this.sessionWithDecimalMappingAllowOverflow(RoundingMode.HALF_UP, 2), "SELECT d_col FROM " + testTable.getName(), "VALUES (1.12), (123456.79), (-1.12), (-123456.79)");
            this.assertQuery(this.sessionWithDecimalMappingAllowOverflow(RoundingMode.UNNECESSARY, 3), String.format("SELECT column_name, data_type FROM information_schema.columns WHERE table_schema = 'tpch' AND table_schema||'.'||table_name = '%s'", testTable.getName()), "VALUES ('d_col','decimal(38,3)')");
            this.assertQuery(this.sessionWithDecimalMappingAllowOverflow(RoundingMode.UNNECESSARY, 3), "SELECT d_col FROM " + testTable.getName(), "VALUES (1.12), (123456.789), (-1.12), (-123456.789)");
        }
    }

    @Test
    public void testDecimalUnspecifiedPrecisionWithExceedingValue() {
        JdbcSqlExecutor jdbcSqlExecutor = new JdbcSqlExecutor(this.postgreSqlServer.getJdbcUrl());
        try (TestTable testTable = new TestTable((SqlExecutor)jdbcSqlExecutor, "tpch.test_var_decimal_with_exceeding_value", "(key varchar(5), d_col decimal)", Arrays.asList("NULL, '1.12'", "NULL, '1234567890123456789012345678901234567890.1234567'"));){
            this.assertQuery(this.sessionWithDecimalMappingAllowOverflow(RoundingMode.UNNECESSARY, 0), String.format("SELECT column_name, data_type FROM information_schema.columns WHERE table_schema = 'tpch' AND table_schema||'.'||table_name = '%s'", testTable.getName()), "VALUES ('key', 'varchar(5)'),('d_col', 'decimal(38,0)')");
            this.assertQueryFails(this.sessionWithDecimalMappingAllowOverflow(RoundingMode.UNNECESSARY, 0), "SELECT * FROM " + testTable.getName(), "Rounding necessary");
            this.assertQueryFails(this.sessionWithDecimalMappingAllowOverflow(RoundingMode.HALF_UP, 0), "SELECT * FROM " + testTable.getName(), "Decimal overflow");
            this.assertQuery(this.sessionWithDecimalMappingStrict(UnsupportedTypeHandling.CONVERT_TO_VARCHAR), String.format("SELECT column_name, data_type FROM information_schema.columns WHERE table_schema = 'tpch' AND table_schema||'.'||table_name = '%s'", testTable.getName()), "VALUES ('key', 'varchar(5)'),('d_col', 'varchar')");
            this.assertQuery(this.sessionWithDecimalMappingStrict(UnsupportedTypeHandling.CONVERT_TO_VARCHAR), "SELECT * FROM " + testTable.getName(), "VALUES (NULL, '1.12'), (NULL, '1234567890123456789012345678901234567890.1234567')");
            this.assertQuery(this.sessionWithDecimalMappingStrict(UnsupportedTypeHandling.IGNORE), String.format("SELECT column_name, data_type FROM information_schema.columns WHERE table_schema = 'tpch' AND table_schema||'.'||table_name = '%s'", testTable.getName()), "VALUES ('key', 'varchar(5)')");
        }
    }

    @Test
    public void testArray() {
        DataTypeTest.create((boolean)true).addRoundTrip(TestPostgreSqlTypeMapping.arrayDataType(DataType.booleanDataType()), Arrays.asList(true, false)).addRoundTrip(TestPostgreSqlTypeMapping.arrayDataType(DataType.bigintDataType()), Arrays.asList(123456789012L)).addRoundTrip(TestPostgreSqlTypeMapping.arrayDataType(DataType.integerDataType()), Arrays.asList(1, 2, 1234567890)).addRoundTrip(TestPostgreSqlTypeMapping.arrayDataType(DataType.smallintDataType()), Arrays.asList((short)32456)).addRoundTrip(TestPostgreSqlTypeMapping.arrayDataType(DataType.doubleDataType()), Arrays.asList(123.45)).addRoundTrip(TestPostgreSqlTypeMapping.arrayDataType(DataType.realDataType()), Arrays.asList(Float.valueOf(123.45f))).execute(this.getQueryRunner(), this.sessionWithArrayAsArray(), this.prestoCreateAsSelect(this.sessionWithArrayAsArray(), "test_array_basic"));
        this.arrayDateTest(TestPostgreSqlTypeMapping::arrayDataType).execute(this.getQueryRunner(), this.sessionWithArrayAsArray(), this.prestoCreateAsSelect(this.sessionWithArrayAsArray(), "test_array_date"));
        this.arrayDateTest(TestPostgreSqlTypeMapping::postgresArrayDataType).execute(this.getQueryRunner(), this.sessionWithArrayAsArray(), this.postgresCreateAndInsert("tpch.test_array_date"));
        this.arrayDecimalTest(TestPostgreSqlTypeMapping::arrayDataType).execute(this.getQueryRunner(), this.sessionWithArrayAsArray(), this.prestoCreateAsSelect(this.sessionWithArrayAsArray(), "test_array_decimal"));
        this.arrayDecimalTest(TestPostgreSqlTypeMapping::postgresArrayDataType).execute(this.getQueryRunner(), this.sessionWithArrayAsArray(), this.postgresCreateAndInsert("tpch.test_array_decimal"));
        this.arrayVarcharDataTypeTest(TestPostgreSqlTypeMapping::arrayDataType).execute(this.getQueryRunner(), this.sessionWithArrayAsArray(), this.prestoCreateAsSelect(this.sessionWithArrayAsArray(), "test_array_varchar"));
        this.arrayVarcharDataTypeTest(TestPostgreSqlTypeMapping::postgresArrayDataType).execute(this.getQueryRunner(), this.sessionWithArrayAsArray(), this.postgresCreateAndInsert("tpch.test_array_varchar"));
        this.arrayUnicodeDataTypeTest(TestPostgreSqlTypeMapping::arrayDataType, DataType::charDataType).execute(this.getQueryRunner(), this.sessionWithArrayAsArray(), this.prestoCreateAsSelect(this.sessionWithArrayAsArray(), "test_array_parameterized_char_unicode"));
        this.arrayUnicodeDataTypeTest(TestPostgreSqlTypeMapping::postgresArrayDataType, DataType::charDataType).execute(this.getQueryRunner(), this.sessionWithArrayAsArray(), this.postgresCreateAndInsert("tpch.test_array_parameterized_char_unicode"));
        this.arrayVarcharUnicodeDataTypeTest(TestPostgreSqlTypeMapping::arrayDataType).execute(this.getQueryRunner(), this.sessionWithArrayAsArray(), this.prestoCreateAsSelect(this.sessionWithArrayAsArray(), "test_array_parameterized_varchar_unicode"));
        this.arrayVarcharUnicodeDataTypeTest(TestPostgreSqlTypeMapping::postgresArrayDataType).execute(this.getQueryRunner(), this.sessionWithArrayAsArray(), this.postgresCreateAndInsert("tpch.test_array_parameterized_varchar_unicode"));
    }

    @Test
    public void testInternalArray() {
        DataTypeTest.create().addRoundTrip(TestPostgreSqlTypeMapping.arrayDataType(DataType.integerDataType(), "_int4"), Arrays.asList(1, 2, 3)).addRoundTrip(TestPostgreSqlTypeMapping.arrayDataType(DataType.varcharDataType(), "_text"), Arrays.asList("a", "b")).execute(this.getQueryRunner(), this.sessionWithArrayAsArray(), this.postgresCreateAndInsert("tpch.test_array_with_native_name"));
    }

    @Test
    public void testArrayEmptyOrNulls() {
        DataTypeTest.create().addRoundTrip(TestPostgreSqlTypeMapping.arrayDataType(DataType.bigintDataType()), Arrays.asList(new Long[0])).addRoundTrip(TestPostgreSqlTypeMapping.arrayDataType(DataType.booleanDataType()), null).addRoundTrip(TestPostgreSqlTypeMapping.arrayDataType(DataType.realDataType()), Collections.singletonList(null)).addRoundTrip(TestPostgreSqlTypeMapping.arrayDataType(DataType.integerDataType()), Arrays.asList(1, null, 3, null)).addRoundTrip(TestPostgreSqlTypeMapping.arrayDataType(DataType.timestampDataType()), Arrays.asList(new LocalDateTime[0])).addRoundTrip(TestPostgreSqlTypeMapping.arrayDataType(DataType.timestampDataType()), Collections.singletonList(null)).addRoundTrip(TestPostgreSqlTypeMapping.arrayDataType(TestPostgreSqlTypeMapping.prestoTimestampWithTimeZoneDataType()), Arrays.asList(new ZonedDateTime[0])).addRoundTrip(TestPostgreSqlTypeMapping.arrayDataType(TestPostgreSqlTypeMapping.prestoTimestampWithTimeZoneDataType()), Collections.singletonList(null)).execute(this.getQueryRunner(), this.sessionWithArrayAsArray(), this.prestoCreateAsSelect(this.sessionWithArrayAsArray(), "test_array_empty_or_nulls"));
    }

    private DataTypeTest arrayDecimalTest(Function<DataType<BigDecimal>, DataType<List<BigDecimal>>> arrayTypeFactory) {
        return DataTypeTest.create().addRoundTrip(arrayTypeFactory.apply((DataType<BigDecimal>)DataType.decimalDataType((int)3, (int)0)), Arrays.asList(new BigDecimal("193"), new BigDecimal("19"), new BigDecimal("-193"))).addRoundTrip(arrayTypeFactory.apply((DataType<BigDecimal>)DataType.decimalDataType((int)3, (int)1)), Arrays.asList(new BigDecimal("10.0"), new BigDecimal("10.1"), new BigDecimal("-10.1"))).addRoundTrip(arrayTypeFactory.apply((DataType<BigDecimal>)DataType.decimalDataType((int)4, (int)2)), Arrays.asList(new BigDecimal("2"), new BigDecimal("2.3"))).addRoundTrip(arrayTypeFactory.apply((DataType<BigDecimal>)DataType.decimalDataType((int)24, (int)2)), Arrays.asList(new BigDecimal("2"), new BigDecimal("2.3"), new BigDecimal("123456789.3"))).addRoundTrip(arrayTypeFactory.apply((DataType<BigDecimal>)DataType.decimalDataType((int)24, (int)4)), Arrays.asList(new BigDecimal("12345678901234567890.31"))).addRoundTrip(arrayTypeFactory.apply((DataType<BigDecimal>)DataType.decimalDataType((int)30, (int)5)), Arrays.asList(new BigDecimal("3141592653589793238462643.38327"), new BigDecimal("-3141592653589793238462643.38327"))).addRoundTrip(arrayTypeFactory.apply((DataType<BigDecimal>)DataType.decimalDataType((int)38, (int)0)), Arrays.asList(new BigDecimal("27182818284590452353602874713526624977"), new BigDecimal("-27182818284590452353602874713526624977")));
    }

    private DataTypeTest arrayVarcharDataTypeTest(Function<DataType<String>, DataType<List<String>>> arrayTypeFactory) {
        return DataTypeTest.create().addRoundTrip(arrayTypeFactory.apply((DataType<String>)DataType.varcharDataType((int)10)), Arrays.asList("text_a")).addRoundTrip(arrayTypeFactory.apply((DataType<String>)DataType.varcharDataType((int)255)), Arrays.asList("text_b")).addRoundTrip(arrayTypeFactory.apply((DataType<String>)DataType.varcharDataType((int)65535)), Arrays.asList("text_d")).addRoundTrip(arrayTypeFactory.apply((DataType<String>)DataType.varcharDataType((int)0xA00000)), Arrays.asList("text_f")).addRoundTrip(arrayTypeFactory.apply((DataType<String>)DataType.varcharDataType()), Arrays.asList("unbounded"));
    }

    private DataTypeTest arrayVarcharUnicodeDataTypeTest(Function<DataType<String>, DataType<List<String>>> arrayTypeFactory) {
        return this.arrayUnicodeDataTypeTest(arrayTypeFactory, DataType::varcharDataType).addRoundTrip(arrayTypeFactory.apply((DataType<String>)DataType.varcharDataType()), Arrays.asList("\u041d\u0443, \u043f\u043e\u0433\u043e\u0434\u0438!"));
    }

    private DataTypeTest arrayUnicodeDataTypeTest(Function<DataType<String>, DataType<List<String>>> arrayTypeFactory, Function<Integer, DataType<String>> dataTypeFactory) {
        String sampleUnicodeText = "\u653b\u6bbb\u6a5f\u52d5\u968a";
        String sampleFourByteUnicodeCharacter = "\ud83d\ude02";
        return DataTypeTest.create().addRoundTrip(arrayTypeFactory.apply(dataTypeFactory.apply(sampleUnicodeText.length())), Arrays.asList(sampleUnicodeText)).addRoundTrip(arrayTypeFactory.apply(dataTypeFactory.apply(32)), Arrays.asList(sampleUnicodeText)).addRoundTrip(arrayTypeFactory.apply(dataTypeFactory.apply(20000)), Arrays.asList(sampleUnicodeText)).addRoundTrip(arrayTypeFactory.apply(dataTypeFactory.apply(1)), Arrays.asList(sampleFourByteUnicodeCharacter));
    }

    private DataTypeTest arrayDateTest(Function<DataType<LocalDate>, DataType<List<LocalDate>>> arrayTypeFactory) {
        ZoneId jvmZone = ZoneId.systemDefault();
        Preconditions.checkState((boolean)jvmZone.getId().equals("America/Bahia_Banderas"), (Object)"This test assumes certain JVM time zone");
        LocalDate dateOfLocalTimeChangeForwardAtMidnightInJvmZone = LocalDate.of(1970, 1, 1);
        TestPostgreSqlTypeMapping.checkIsGap(jvmZone, dateOfLocalTimeChangeForwardAtMidnightInJvmZone.atStartOfDay());
        ZoneId someZone = ZoneId.of("Europe/Vilnius");
        LocalDate dateOfLocalTimeChangeForwardAtMidnightInSomeZone = LocalDate.of(1983, 4, 1);
        TestPostgreSqlTypeMapping.checkIsGap(someZone, dateOfLocalTimeChangeForwardAtMidnightInSomeZone.atStartOfDay());
        LocalDate dateOfLocalTimeChangeBackwardAtMidnightInSomeZone = LocalDate.of(1983, 10, 1);
        TestPostgreSqlTypeMapping.checkIsDoubled(someZone, dateOfLocalTimeChangeBackwardAtMidnightInSomeZone.atStartOfDay().minusMinutes(1L));
        return DataTypeTest.create().addRoundTrip(arrayTypeFactory.apply((DataType<LocalDate>)DataType.dateDataType()), Arrays.asList(LocalDate.of(1952, 4, 3))).addRoundTrip(arrayTypeFactory.apply((DataType<LocalDate>)DataType.dateDataType()), Arrays.asList(LocalDate.of(1970, 1, 1))).addRoundTrip(arrayTypeFactory.apply((DataType<LocalDate>)DataType.dateDataType()), Arrays.asList(LocalDate.of(1970, 2, 3))).addRoundTrip(arrayTypeFactory.apply((DataType<LocalDate>)DataType.dateDataType()), Arrays.asList(LocalDate.of(2017, 7, 1))).addRoundTrip(arrayTypeFactory.apply((DataType<LocalDate>)DataType.dateDataType()), Arrays.asList(LocalDate.of(2017, 1, 1))).addRoundTrip(arrayTypeFactory.apply((DataType<LocalDate>)DataType.dateDataType()), Arrays.asList(dateOfLocalTimeChangeForwardAtMidnightInJvmZone)).addRoundTrip(arrayTypeFactory.apply((DataType<LocalDate>)DataType.dateDataType()), Arrays.asList(dateOfLocalTimeChangeForwardAtMidnightInSomeZone)).addRoundTrip(arrayTypeFactory.apply((DataType<LocalDate>)DataType.dateDataType()), Arrays.asList(dateOfLocalTimeChangeBackwardAtMidnightInSomeZone));
    }

    @Test
    public void testArrayMultidimensional() {
        DataTypeTest.create().addRoundTrip(TestPostgreSqlTypeMapping.arrayDataType(TestPostgreSqlTypeMapping.arrayDataType(DataType.booleanDataType())), Arrays.asList(Arrays.asList(null, null, null))).addRoundTrip(TestPostgreSqlTypeMapping.arrayDataType(TestPostgreSqlTypeMapping.arrayDataType(DataType.booleanDataType())), Arrays.asList(Arrays.asList(true, null), Arrays.asList(null, null), Arrays.asList(false, false))).addRoundTrip(TestPostgreSqlTypeMapping.arrayDataType(TestPostgreSqlTypeMapping.arrayDataType(DataType.integerDataType())), Arrays.asList(Arrays.asList(1, 2), Arrays.asList(null, null), Arrays.asList(3, 4))).addRoundTrip(TestPostgreSqlTypeMapping.arrayDataType(TestPostgreSqlTypeMapping.arrayDataType(DataType.decimalDataType((int)3, (int)0))), Arrays.asList(Arrays.asList(new BigDecimal("193")), Arrays.asList(new BigDecimal("19")), Arrays.asList(new BigDecimal("-193")))).execute(this.getQueryRunner(), this.sessionWithArrayAsArray(), this.prestoCreateAsSelect(this.sessionWithArrayAsArray(), "test_array_2d"));
        DataTypeTest.create().addRoundTrip(TestPostgreSqlTypeMapping.arrayDataType(TestPostgreSqlTypeMapping.arrayDataType(TestPostgreSqlTypeMapping.arrayDataType(DataType.doubleDataType()))), Arrays.asList(Arrays.asList(Arrays.asList(123.45), Arrays.asList(678.99)), Arrays.asList(Arrays.asList(543.21), Arrays.asList(998.76)), Arrays.asList(Arrays.asList(567.123), Arrays.asList(789.12)))).addRoundTrip(TestPostgreSqlTypeMapping.arrayDataType(TestPostgreSqlTypeMapping.arrayDataType(TestPostgreSqlTypeMapping.arrayDataType(DataType.dateDataType()))), Arrays.asList(Arrays.asList(Arrays.asList(LocalDate.of(1952, 4, 3), LocalDate.of(1970, 1, 1))), Arrays.asList(Arrays.asList(null, LocalDate.of(1970, 1, 1))), Arrays.asList(Arrays.asList(LocalDate.of(1970, 2, 3), LocalDate.of(2017, 7, 1))))).execute(this.getQueryRunner(), this.sessionWithArrayAsArray(), this.prestoCreateAsSelect(this.sessionWithArrayAsArray(), "test_array_3d"));
    }

    @Test
    public void testArrayAsJson() {
        Session session = Session.builder((Session)this.getQueryRunner().getDefaultSession()).setSystemProperty("postgresql.array_mapping", PostgreSqlConfig.ArrayMapping.AS_JSON.name()).build();
        DataTypeTest.create().addRoundTrip(TestPostgreSqlTypeMapping.arrayAsJsonDataType("boolean[]"), null).addRoundTrip(TestPostgreSqlTypeMapping.arrayAsJsonDataType("boolean[]"), (Object)"[[true,false],[false,true],[true,true]]").addRoundTrip(TestPostgreSqlTypeMapping.arrayAsJsonDataType("boolean[3][2]"), (Object)"[[true,false],[false,true],[true,true]]").addRoundTrip(TestPostgreSqlTypeMapping.arrayAsJsonDataType("boolean[100][100][100]"), (Object)"[true]").addRoundTrip(TestPostgreSqlTypeMapping.arrayAsJsonDataType("_bool"), (Object)"[[true,false],[null,null]]").addRoundTrip(TestPostgreSqlTypeMapping.arrayAsJsonDataType("_bool"), (Object)"[[[null]]]").addRoundTrip(TestPostgreSqlTypeMapping.arrayAsJsonDataType("_bool"), (Object)"[]").execute(this.getQueryRunner(), session, this.postgresCreateAndInsert("tpch.test_boolean_array_as_json"));
        DataTypeTest.create().addRoundTrip(TestPostgreSqlTypeMapping.arrayAsJsonDataType("integer[]"), null).addRoundTrip(TestPostgreSqlTypeMapping.arrayAsJsonDataType("integer[]"), (Object)"[[[1,2,3],[4,5,6]],[[7,8,9],[10,11,12]]]").addRoundTrip(TestPostgreSqlTypeMapping.arrayAsJsonDataType("integer[100][100][100]"), (Object)"[0]").addRoundTrip(TestPostgreSqlTypeMapping.arrayAsJsonDataType("integer[]"), (Object)"[[[null,null]]]").addRoundTrip(TestPostgreSqlTypeMapping.arrayAsJsonDataType("integer[]"), (Object)"[]").addRoundTrip(TestPostgreSqlTypeMapping.arrayAsJsonDataType("_int4"), (Object)"[]").addRoundTrip(TestPostgreSqlTypeMapping.arrayAsJsonDataType("_int4"), (Object)"[[0],[1],[2],[3]]").execute(this.getQueryRunner(), session, this.postgresCreateAndInsert("tpch.test_integer_array_as_json"));
        DataTypeTest.create().addRoundTrip(TestPostgreSqlTypeMapping.arrayAsJsonDataType("double precision[]"), null).addRoundTrip(TestPostgreSqlTypeMapping.arrayAsJsonDataType("double precision[]"), (Object)"[[[1.1,2.2,3.3],[4.4,5.5,6.6]]]").addRoundTrip(TestPostgreSqlTypeMapping.arrayAsJsonDataType("double precision[100][100][100]"), (Object)"[42.3]").addRoundTrip(TestPostgreSqlTypeMapping.arrayAsJsonDataType("double precision[]"), (Object)"[[[null,null]]]").addRoundTrip(TestPostgreSqlTypeMapping.arrayAsJsonDataType("double precision[]"), (Object)"[]").addRoundTrip(TestPostgreSqlTypeMapping.arrayAsJsonDataType("_float8"), (Object)"[]").addRoundTrip(TestPostgreSqlTypeMapping.arrayAsJsonDataType("_float8"), (Object)"[[1.1],[2.2]]").execute(this.getQueryRunner(), session, this.postgresCreateAndInsert("tpch.test_double_array_as_json"));
        DataTypeTest.create().addRoundTrip(TestPostgreSqlTypeMapping.arrayAsJsonDataType("real[]"), null).addRoundTrip(TestPostgreSqlTypeMapping.arrayAsJsonDataType("real[]"), (Object)"[[[1.1,2.2,3.3],[4.4,5.5,6.6]]]").addRoundTrip(TestPostgreSqlTypeMapping.arrayAsJsonDataType("real[100][100][100]"), (Object)"[42.3]").addRoundTrip(TestPostgreSqlTypeMapping.arrayAsJsonDataType("real[]"), (Object)"[[[null,null]]]").addRoundTrip(TestPostgreSqlTypeMapping.arrayAsJsonDataType("real[]"), (Object)"[]").addRoundTrip(TestPostgreSqlTypeMapping.arrayAsJsonDataType("_float4"), (Object)"[]").addRoundTrip(TestPostgreSqlTypeMapping.arrayAsJsonDataType("_float4"), (Object)"[[1.1],[2.2]]").execute(this.getQueryRunner(), session, this.postgresCreateAndInsert("tpch.test_real_array_as_json"));
        DataTypeTest.create().addRoundTrip(TestPostgreSqlTypeMapping.arrayAsJsonDataType("varchar[]"), null).addRoundTrip(TestPostgreSqlTypeMapping.arrayAsJsonDataType("varchar[]"), (Object)"[\"text\"]").addRoundTrip(TestPostgreSqlTypeMapping.arrayAsJsonDataType("_text"), (Object)"[[\"one\",\"two\"],[\"three\",\"four\"]]").addRoundTrip(TestPostgreSqlTypeMapping.arrayAsJsonDataType("_text"), (Object)"[[\"one\",null]]").addRoundTrip(TestPostgreSqlTypeMapping.arrayAsJsonDataType("_text"), (Object)"[]").execute(this.getQueryRunner(), session, this.postgresCreateAndInsert("tpch.test_varchar_array_as_json"));
        DataTypeTest.create().addRoundTrip(TestPostgreSqlTypeMapping.arrayAsJsonDataType("date[]"), null).addRoundTrip(TestPostgreSqlTypeMapping.arrayAsJsonDataType("date[]"), (Object)"[\"2019-01-02\"]").addRoundTrip(TestPostgreSqlTypeMapping.arrayAsJsonDataType("date[]"), (Object)"[null,null]").execute(this.getQueryRunner(), session, this.postgresCreateAndInsert("tpch.test_timestamp_array_as_json"));
        DataTypeTest.create().addRoundTrip(TestPostgreSqlTypeMapping.arrayAsJsonDataType("timestamp[]"), null).addRoundTrip(TestPostgreSqlTypeMapping.arrayAsJsonDataType("timestamp[]"), (Object)"[\"2019-01-02 03:04:05.789\"]").addRoundTrip(TestPostgreSqlTypeMapping.arrayAsJsonDataType("timestamp[]"), (Object)"[null,null]").execute(this.getQueryRunner(), session, this.postgresCreateAndInsert("tpch.test_timestamp_array_as_json"));
        DataTypeTest.create().addRoundTrip(TestPostgreSqlTypeMapping.arrayAsJsonDataType("hstore[]"), null).addRoundTrip(TestPostgreSqlTypeMapping.arrayAsJsonDataType("hstore[]"), (Object)"[]").addRoundTrip(TestPostgreSqlTypeMapping.arrayAsJsonDataType("hstore[]"), (Object)"[null,null]").addRoundTrip(TestPostgreSqlTypeMapping.hstoreArrayAsJsonDataType(), (Object)"[{\"a\":\"1\",\"b\":\"2\"},{\"a\":\"3\",\"d\":\"4\"}]").addRoundTrip(TestPostgreSqlTypeMapping.hstoreArrayAsJsonDataType(), (Object)"[{\"a\":null,\"b\":\"2\"}]").execute(this.getQueryRunner(), session, this.postgresCreateAndInsert("tpch.test_hstore_array_as_json"));
    }

    private static <E> DataType<List<E>> arrayDataType(DataType<E> elementType) {
        return TestPostgreSqlTypeMapping.arrayDataType(elementType, String.format("ARRAY(%s)", elementType.getInsertType()));
    }

    private static <E> DataType<List<E>> postgresArrayDataType(DataType<E> elementType) {
        return TestPostgreSqlTypeMapping.arrayDataType(elementType, elementType.getInsertType() + "[]");
    }

    private static <E> DataType<List<E>> arrayDataType(DataType<E> elementType, String insertType) {
        return DataType.dataType((String)insertType, (Type)new ArrayType(elementType.getPrestoResultType()), valuesList -> "ARRAY" + valuesList.stream().map(arg_0 -> ((DataType)elementType).toLiteral(arg_0)).collect(Collectors.toList()), valuesList -> "ARRAY" + valuesList.stream().map(arg_0 -> ((DataType)elementType).toPrestoLiteral(arg_0)).collect(Collectors.toList()), valuesList -> valuesList == null ? null : valuesList.stream().map(arg_0 -> ((DataType)elementType).toPrestoQueryResult(arg_0)).collect(Collectors.toList()));
    }

    private static DataType<String> arrayAsJsonDataType(String insertType) {
        return DataType.dataType((String)insertType, (Type)JsonType.JSON, value -> value.replace("[", "ARRAY[").replace("\"", "'") + "::" + insertType, Function.identity());
    }

    private static DataType<String> hstoreArrayAsJsonDataType() {
        return DataType.dataType((String)"hstore[]", (Type)JsonType.JSON, json -> ((List)HSTORE_CODEC.fromJson(json)).stream().map(TestPostgreSqlTypeMapping::hstoreLiteral).collect(Collectors.joining(",", "ARRAY[", "]")), Function.identity());
    }

    @Test
    public void testDate() {
        ZoneId jvmZone = ZoneId.systemDefault();
        Preconditions.checkState((boolean)jvmZone.getId().equals("America/Bahia_Banderas"), (Object)"This test assumes certain JVM time zone");
        LocalDate dateOfLocalTimeChangeForwardAtMidnightInJvmZone = LocalDate.of(1970, 1, 1);
        TestPostgreSqlTypeMapping.checkIsGap(jvmZone, dateOfLocalTimeChangeForwardAtMidnightInJvmZone.atStartOfDay());
        ZoneId someZone = ZoneId.of("Europe/Vilnius");
        LocalDate dateOfLocalTimeChangeForwardAtMidnightInSomeZone = LocalDate.of(1983, 4, 1);
        TestPostgreSqlTypeMapping.checkIsGap(someZone, dateOfLocalTimeChangeForwardAtMidnightInSomeZone.atStartOfDay());
        LocalDate dateOfLocalTimeChangeBackwardAtMidnightInSomeZone = LocalDate.of(1983, 10, 1);
        TestPostgreSqlTypeMapping.checkIsDoubled(someZone, dateOfLocalTimeChangeBackwardAtMidnightInSomeZone.atStartOfDay().minusMinutes(1L));
        DataTypeTest testCases = DataTypeTest.create((boolean)true).addRoundTrip(DataType.dateDataType(), (Object)LocalDate.of(1952, 4, 3)).addRoundTrip(DataType.dateDataType(), (Object)LocalDate.of(1970, 1, 1)).addRoundTrip(DataType.dateDataType(), (Object)LocalDate.of(1970, 2, 3)).addRoundTrip(DataType.dateDataType(), (Object)LocalDate.of(2017, 7, 1)).addRoundTrip(DataType.dateDataType(), (Object)LocalDate.of(2017, 1, 1)).addRoundTrip(DataType.dateDataType(), (Object)dateOfLocalTimeChangeForwardAtMidnightInJvmZone).addRoundTrip(DataType.dateDataType(), (Object)dateOfLocalTimeChangeForwardAtMidnightInSomeZone).addRoundTrip(DataType.dateDataType(), (Object)dateOfLocalTimeChangeBackwardAtMidnightInSomeZone);
        for (String timeZoneId : ImmutableList.of((Object)TimeZoneKey.UTC_KEY.getId(), (Object)jvmZone.getId(), (Object)someZone.getId())) {
            Session session = Session.builder((Session)this.getQueryRunner().getDefaultSession()).setTimeZoneKey(TimeZoneKey.getTimeZoneKey((String)timeZoneId)).build();
            testCases.execute(this.getQueryRunner(), session, this.postgresCreateAndInsert("tpch.test_date"));
            testCases.execute(this.getQueryRunner(), session, this.prestoCreateAsSelect("test_date"));
        }
    }

    @Test
    public void testEnum() {
        JdbcSqlExecutor jdbcSqlExecutor = new JdbcSqlExecutor(this.postgreSqlServer.getJdbcUrl());
        jdbcSqlExecutor.execute("CREATE TYPE enum_t AS ENUM ('a','b','c')");
        jdbcSqlExecutor.execute("CREATE TABLE tpch.test_enum(id int, enum_column enum_t)");
        jdbcSqlExecutor.execute("INSERT INTO tpch.test_enum(id,enum_column) values (1,'a'::enum_t),(2,'b'::enum_t)");
        try {
            this.assertQuery("SELECT column_name, data_type FROM information_schema.columns WHERE table_schema = 'tpch' AND table_name = 'test_enum'", "VALUES ('id','integer'),('enum_column','varchar')");
            this.assertQuery("SELECT * FROM tpch.test_enum", "VALUES (1,'a'),(2,'b')");
            this.assertQuery("SELECT * FROM tpch.test_enum WHERE enum_column='a'", "VALUES (1,'a')");
        }
        finally {
            jdbcSqlExecutor.execute("DROP TABLE tpch.test_enum");
            jdbcSqlExecutor.execute("DROP TYPE enum_t");
        }
    }

    @Test(dataProvider="testTimestampDataProvider")
    public void testTime(boolean legacyTimestamp, boolean insertWithPresto, ZoneId sessionZone) {
        LocalTime timeGapInJvmZone = LocalTime.of(0, 12, 34, 567000000);
        TestPostgreSqlTypeMapping.checkIsGap(this.jvmZone, timeGapInJvmZone.atDate(EPOCH_DAY));
        DataTypeTest tests = DataTypeTest.create().addRoundTrip(DataType.timeDataType(), (Object)LocalTime.of(1, 12, 34, 0)).addRoundTrip(DataType.timeDataType(), (Object)LocalTime.of(2, 12, 34, 0)).addRoundTrip(DataType.timeDataType(), (Object)LocalTime.of(2, 12, 34, 1000000)).addRoundTrip(DataType.timeDataType(), (Object)LocalTime.of(3, 12, 34, 0)).addRoundTrip(DataType.timeDataType(), (Object)LocalTime.of(4, 12, 34, 0)).addRoundTrip(DataType.timeDataType(), (Object)LocalTime.of(5, 12, 34, 0)).addRoundTrip(DataType.timeDataType(), (Object)LocalTime.of(6, 12, 34, 0)).addRoundTrip(DataType.timeDataType(), (Object)LocalTime.of(9, 12, 34, 0)).addRoundTrip(DataType.timeDataType(), (Object)LocalTime.of(10, 12, 34, 0)).addRoundTrip(DataType.timeDataType(), (Object)LocalTime.of(15, 12, 34, 567000000)).addRoundTrip(DataType.timeDataType(), (Object)LocalTime.of(23, 59, 59, 999000000));
        this.addTimeTestIfSupported(tests, legacyTimestamp, sessionZone, this.epoch.toLocalTime());
        this.addTimeTestIfSupported(tests, legacyTimestamp, sessionZone, timeGapInJvmZone);
        Session session = Session.builder((Session)this.getQueryRunner().getDefaultSession()).setTimeZoneKey(TimeZoneKey.getTimeZoneKey((String)sessionZone.getId())).setSystemProperty("legacy_timestamp", Boolean.toString(legacyTimestamp)).build();
        if (insertWithPresto) {
            tests.execute(this.getQueryRunner(), session, this.prestoCreateAsSelect(session, "test_time"));
        } else {
            tests.execute(this.getQueryRunner(), session, this.postgresCreateAndInsert("tpch.test_time"));
        }
    }

    private void addTimeTestIfSupported(DataTypeTest tests, boolean legacyTimestamp, ZoneId sessionZone, LocalTime time) {
        if (legacyTimestamp && TestPostgreSqlTypeMapping.isGap(sessionZone, time.atDate(EPOCH_DAY))) {
            return;
        }
        tests.addRoundTrip(DataType.timeDataType(), (Object)time);
    }

    @Test(dataProvider="testTimestampDataProvider")
    public void testTimestamp(boolean legacyTimestamp, boolean insertWithPresto, ZoneId sessionZone) {
        DataTypeTest tests = DataTypeTest.create((boolean)true).addRoundTrip(DataType.timestampDataType(), (Object)this.beforeEpoch).addRoundTrip(DataType.timestampDataType(), (Object)this.afterEpoch).addRoundTrip(DataType.timestampDataType(), (Object)this.timeDoubledInJvmZone).addRoundTrip(DataType.timestampDataType(), (Object)this.timeDoubledInVilnius);
        this.addTimestampTestIfSupported(tests, legacyTimestamp, sessionZone, this.epoch);
        this.addTimestampTestIfSupported(tests, legacyTimestamp, sessionZone, this.timeGapInJvmZone1);
        this.addTimestampTestIfSupported(tests, legacyTimestamp, sessionZone, this.timeGapInJvmZone2);
        this.addTimestampTestIfSupported(tests, legacyTimestamp, sessionZone, this.timeGapInVilnius);
        this.addTimestampTestIfSupported(tests, legacyTimestamp, sessionZone, this.timeGapInKathmandu);
        Session session = Session.builder((Session)this.getQueryRunner().getDefaultSession()).setTimeZoneKey(TimeZoneKey.getTimeZoneKey((String)sessionZone.getId())).setSystemProperty("legacy_timestamp", Boolean.toString(legacyTimestamp)).build();
        if (insertWithPresto) {
            tests.execute(this.getQueryRunner(), session, this.prestoCreateAsSelect(session, "test_timestamp"));
        } else {
            tests.execute(this.getQueryRunner(), session, this.postgresCreateAndInsert("tpch.test_timestamp"));
        }
    }

    private void addTimestampTestIfSupported(DataTypeTest tests, boolean legacyTimestamp, ZoneId sessionZone, LocalDateTime dateTime) {
        if (legacyTimestamp && TestPostgreSqlTypeMapping.isGap(sessionZone, dateTime)) {
            return;
        }
        tests.addRoundTrip(DataType.timestampDataType(), (Object)dateTime);
    }

    @Test(dataProvider="testTimestampDataProvider")
    public void testArrayTimestamp(boolean legacyTimestamp, boolean insertWithPresto, ZoneId sessionZone) {
        DataSetup dataSetup;
        DataType dataType;
        if (insertWithPresto) {
            dataType = TestPostgreSqlTypeMapping.arrayDataType(DataType.timestampDataType());
            dataSetup = this.prestoCreateAsSelect(this.sessionWithArrayAsArray(), "test_array_timestamp");
        } else {
            dataType = TestPostgreSqlTypeMapping.arrayDataType(DataType.timestampDataType(), "timestamp[]");
            dataSetup = this.postgresCreateAndInsert("tpch.test_array_timestamp");
        }
        DataTypeTest tests = DataTypeTest.create((boolean)true).addRoundTrip(dataType, Arrays.asList(this.beforeEpoch)).addRoundTrip(dataType, Arrays.asList(this.afterEpoch)).addRoundTrip(dataType, Arrays.asList(this.timeDoubledInJvmZone)).addRoundTrip(dataType, Arrays.asList(this.timeDoubledInVilnius));
        this.addArrayTimestampTestIfSupported(tests, legacyTimestamp, sessionZone, dataType, this.epoch);
        this.addArrayTimestampTestIfSupported(tests, legacyTimestamp, sessionZone, dataType, this.timeGapInJvmZone1);
        this.addArrayTimestampTestIfSupported(tests, legacyTimestamp, sessionZone, dataType, this.timeGapInJvmZone2);
        this.addArrayTimestampTestIfSupported(tests, legacyTimestamp, sessionZone, dataType, this.timeGapInVilnius);
        this.addArrayTimestampTestIfSupported(tests, legacyTimestamp, sessionZone, dataType, this.timeGapInKathmandu);
        Session session = Session.builder((Session)this.sessionWithArrayAsArray()).setTimeZoneKey(TimeZoneKey.getTimeZoneKey((String)sessionZone.getId())).setSystemProperty("legacy_timestamp", Boolean.toString(legacyTimestamp)).build();
        tests.execute(this.getQueryRunner(), session, dataSetup);
    }

    private void addArrayTimestampTestIfSupported(DataTypeTest tests, boolean legacyTimestamp, ZoneId sessionZone, DataType<List<LocalDateTime>> dataType, LocalDateTime dateTime) {
        if (legacyTimestamp && TestPostgreSqlTypeMapping.isGap(sessionZone, dateTime)) {
            return;
        }
        tests.addRoundTrip(dataType, Arrays.asList(dateTime));
    }

    @DataProvider
    public Object[][] testTimestampDataProvider() {
        return new Object[][]{{true, true, ZoneOffset.UTC}, {false, true, ZoneOffset.UTC}, {true, false, ZoneOffset.UTC}, {false, false, ZoneOffset.UTC}, {true, true, this.jvmZone}, {false, true, this.jvmZone}, {true, false, this.jvmZone}, {false, false, this.jvmZone}, {true, true, this.vilnius}, {false, true, this.vilnius}, {true, false, this.vilnius}, {false, false, this.vilnius}, {true, true, this.kathmandu}, {false, true, this.kathmandu}, {true, false, this.kathmandu}, {false, false, this.kathmandu}, {true, true, ZoneId.of(TestingSession.DEFAULT_TIME_ZONE_KEY.getId())}, {false, true, ZoneId.of(TestingSession.DEFAULT_TIME_ZONE_KEY.getId())}, {true, false, ZoneId.of(TestingSession.DEFAULT_TIME_ZONE_KEY.getId())}, {false, false, ZoneId.of(TestingSession.DEFAULT_TIME_ZONE_KEY.getId())}};
    }

    @Test(dataProvider="testTimestampWithTimeZoneDataProvider")
    public void testTimestampWithTimeZone(boolean insertWithPresto) {
        DataSetup dataSetup;
        DataType<ZonedDateTime> dataType;
        if (insertWithPresto) {
            dataType = TestPostgreSqlTypeMapping.prestoTimestampWithTimeZoneDataType();
            dataSetup = this.prestoCreateAsSelect("test_timestamp_with_time_zone");
        } else {
            dataType = TestPostgreSqlTypeMapping.postgreSqlTimestampWithTimeZoneDataType();
            dataSetup = this.postgresCreateAndInsert("tpch.test_timestamp_with_time_zone");
        }
        DataTypeTest tests = DataTypeTest.create((boolean)true).addRoundTrip(dataType, (Object)this.epoch.atZone(ZoneOffset.UTC)).addRoundTrip(dataType, (Object)this.epoch.atZone(this.kathmandu)).addRoundTrip(dataType, (Object)this.epoch.atZone(this.fixedOffsetEast)).addRoundTrip(dataType, (Object)this.epoch.atZone(this.fixedOffsetWest)).addRoundTrip(dataType, (Object)this.beforeEpoch.atZone(ZoneOffset.UTC)).addRoundTrip(dataType, (Object)this.beforeEpoch.atZone(this.kathmandu)).addRoundTrip(dataType, (Object)this.beforeEpoch.atZone(this.fixedOffsetEast)).addRoundTrip(dataType, (Object)this.beforeEpoch.atZone(this.fixedOffsetWest)).addRoundTrip(dataType, (Object)this.afterEpoch.atZone(ZoneOffset.UTC)).addRoundTrip(dataType, (Object)this.afterEpoch.atZone(this.kathmandu)).addRoundTrip(dataType, (Object)this.afterEpoch.atZone(this.fixedOffsetEast)).addRoundTrip(dataType, (Object)this.afterEpoch.atZone(this.fixedOffsetWest)).addRoundTrip(dataType, (Object)this.afterEpoch.atZone(ZoneId.of("GMT"))).addRoundTrip(dataType, (Object)this.afterEpoch.atZone(ZoneId.of("UTC"))).addRoundTrip(dataType, (Object)this.afterEpoch.atZone(ZoneId.of("Z"))).addRoundTrip(dataType, (Object)this.afterEpoch.atZone(ZoneId.of("UTC+00:00"))).addRoundTrip(dataType, (Object)this.timeDoubledInJvmZone.atZone(ZoneOffset.UTC)).addRoundTrip(dataType, (Object)this.timeDoubledInJvmZone.atZone(this.jvmZone)).addRoundTrip(dataType, (Object)this.timeDoubledInJvmZone.atZone(this.kathmandu)).addRoundTrip(dataType, (Object)this.timeDoubledInVilnius.atZone(ZoneOffset.UTC)).addRoundTrip(dataType, (Object)this.timeDoubledInVilnius.atZone(this.vilnius)).addRoundTrip(dataType, (Object)this.timeDoubledInVilnius.atZone(this.kathmandu)).addRoundTrip(dataType, (Object)this.timeGapInJvmZone1.atZone(ZoneOffset.UTC)).addRoundTrip(dataType, (Object)this.timeGapInJvmZone1.atZone(this.kathmandu)).addRoundTrip(dataType, (Object)this.timeGapInJvmZone2.atZone(ZoneOffset.UTC)).addRoundTrip(dataType, (Object)this.timeGapInJvmZone2.atZone(this.kathmandu)).addRoundTrip(dataType, (Object)this.timeGapInVilnius.atZone(this.kathmandu)).addRoundTrip(dataType, (Object)this.timeGapInKathmandu.atZone(this.vilnius));
        tests.execute(this.getQueryRunner(), dataSetup);
    }

    @Test(dataProvider="testTimestampWithTimeZoneDataProvider")
    public void testArrayTimestampWithTimeZone(boolean insertWithPresto) {
        DataSetup dataSetup;
        DataType<List<ZonedDateTime>> dataType;
        if (insertWithPresto) {
            dataType = TestPostgreSqlTypeMapping.arrayDataType(TestPostgreSqlTypeMapping.prestoTimestampWithTimeZoneDataType());
            dataSetup = this.prestoCreateAsSelect(this.sessionWithArrayAsArray(), "test_array_timestamp_with_time_zone");
        } else {
            dataType = TestPostgreSqlTypeMapping.arrayDataType(TestPostgreSqlTypeMapping.postgreSqlTimestampWithTimeZoneDataType(), "timestamptz[]");
            dataSetup = this.postgresCreateAndInsert("tpch.test_array_timestamp_with_time_zone");
        }
        DataTypeTest tests = DataTypeTest.create().addRoundTrip(dataType, Arrays.asList(this.epoch.atZone(ZoneOffset.UTC), this.epoch.atZone(this.kathmandu))).addRoundTrip(dataType, Arrays.asList(this.beforeEpoch.atZone(this.kathmandu), this.beforeEpoch.atZone(ZoneOffset.UTC))).addRoundTrip(dataType, Arrays.asList(this.afterEpoch.atZone(ZoneOffset.UTC), this.afterEpoch.atZone(this.kathmandu))).addRoundTrip(dataType, Arrays.asList(this.timeDoubledInJvmZone.atZone(ZoneOffset.UTC))).addRoundTrip(dataType, Arrays.asList(this.timeDoubledInJvmZone.atZone(this.kathmandu))).addRoundTrip(dataType, Arrays.asList(this.timeDoubledInVilnius.atZone(ZoneOffset.UTC), this.timeDoubledInVilnius.atZone(this.vilnius), this.timeDoubledInVilnius.atZone(this.kathmandu))).addRoundTrip(dataType, Arrays.asList(this.timeGapInJvmZone1.atZone(ZoneOffset.UTC), this.timeGapInJvmZone1.atZone(this.kathmandu))).addRoundTrip(dataType, Arrays.asList(this.timeGapInJvmZone2.atZone(ZoneOffset.UTC), this.timeGapInJvmZone2.atZone(this.kathmandu))).addRoundTrip(dataType, Arrays.asList(this.timeGapInVilnius.atZone(this.kathmandu))).addRoundTrip(dataType, Arrays.asList(this.timeGapInKathmandu.atZone(this.vilnius)));
        if (!insertWithPresto) {
            tests.addRoundTrip(dataType, Arrays.asList(this.timeDoubledInJvmZone.atZone(this.jvmZone)));
        }
        tests.execute(this.getQueryRunner(), this.sessionWithArrayAsArray(), dataSetup);
    }

    @DataProvider
    public Object[][] testTimestampWithTimeZoneDataProvider() {
        return new Object[][]{{true}, {false}};
    }

    @Test
    public void testJson() {
        this.jsonTestCases((DataType<String>)DataType.jsonDataType()).execute(this.getQueryRunner(), this.prestoCreateAsSelect("presto_test_json"));
        this.jsonTestCases((DataType<String>)DataType.jsonDataType()).execute(this.getQueryRunner(), this.postgresCreateAndInsert("tpch.postgresql_test_json"));
    }

    @Test
    public void testJsonb() {
        this.jsonTestCases(TestPostgreSqlTypeMapping.jsonbDataType()).execute(this.getQueryRunner(), this.postgresCreateAndInsert("tpch.postgresql_test_jsonb"));
    }

    private DataTypeTest jsonTestCases(DataType<String> jsonDataType) {
        return DataTypeTest.create((boolean)true).addRoundTrip(jsonDataType, (Object)"{}").addRoundTrip(jsonDataType, null).addRoundTrip(jsonDataType, (Object)"null").addRoundTrip(jsonDataType, (Object)"123.4").addRoundTrip(jsonDataType, (Object)"\"abc\"").addRoundTrip(jsonDataType, (Object)"\"text with \\\" quotations and ' apostrophes\"").addRoundTrip(jsonDataType, (Object)"\"\"").addRoundTrip(jsonDataType, (Object)"{\"a\":1,\"b\":2}").addRoundTrip(jsonDataType, (Object)"{\"a\":[1,2,3],\"b\":{\"aa\":11,\"bb\":[{\"a\":1,\"b\":2},{\"a\":0}]}}").addRoundTrip(jsonDataType, (Object)"[]");
    }

    @Test
    public void testHstore() {
        this.hstoreTestCases(this.hstoreDataType()).execute(this.getQueryRunner(), this.postgresCreateAndInsert("tpch.postgresql_test_hstore"));
        this.hstoreTestCases(this.varcharMapDataType()).execute(this.getQueryRunner(), this.postgresCreatePrestoInsert("tpch.postgresql_test_hstore"));
    }

    private DataTypeTest hstoreTestCases(DataType<Map<String, String>> varcharMapDataType) {
        return DataTypeTest.create().addRoundTrip(varcharMapDataType, null).addRoundTrip(varcharMapDataType, (Object)ImmutableMap.of()).addRoundTrip(varcharMapDataType, (Object)ImmutableMap.of((Object)"key1", (Object)"value1")).addRoundTrip(varcharMapDataType, (Object)ImmutableMap.of((Object)"key1", (Object)"value1", (Object)"key2", (Object)"value2", (Object)"key3", (Object)"value3")).addRoundTrip(varcharMapDataType, (Object)ImmutableMap.of((Object)"key1", (Object)" \" ", (Object)"key2", (Object)" ' ", (Object)"key3", (Object)" ]) ")).addRoundTrip(varcharMapDataType, Collections.singletonMap("key1", null));
    }

    @Test
    public void testUuid() {
        this.uuidTestCases(TestPostgreSqlTypeMapping.uuidDataType()).execute(this.getQueryRunner(), this.prestoCreateAsSelect("presto_test_uuid"));
    }

    private DataTypeTest uuidTestCases(DataType<UUID> uuidDataType) {
        return DataTypeTest.create((boolean)true).addRoundTrip(uuidDataType, (Object)UUID.fromString("00000000-0000-0000-0000-000000000000")).addRoundTrip(uuidDataType, (Object)UUID.fromString("123e4567-e89b-12d3-a456-426655440000"));
    }

    @Test
    public void testMoney() {
        DataTypeTest.create((boolean)true).addRoundTrip(TestPostgreSqlTypeMapping.moneyDataType(), null).addRoundTrip(TestPostgreSqlTypeMapping.moneyDataType(), (Object)10.0).addRoundTrip(TestPostgreSqlTypeMapping.moneyDataType(), (Object)10.54).addRoundTrip(TestPostgreSqlTypeMapping.moneyDataType(), (Object)1.000000042E7).execute(this.getQueryRunner(), this.postgresCreateAndInsert("tpch.presto_test_money"));
    }

    @Test
    public void testReal() {
        TestPostgreSqlTypeMapping.singlePrecisionFloatingPointTests((DataType<Float>)DataType.realDataType()).execute(this.getQueryRunner(), this.prestoCreateAsSelect("presto_test_real"));
        TestPostgreSqlTypeMapping.singlePrecisionFloatingPointTests(TestPostgreSqlTypeMapping.postgreSqlRealDataType()).execute(this.getQueryRunner(), this.postgresCreateAndInsert("tpch.postgresql_test_real"));
    }

    @Test
    public void testDouble() {
        TestPostgreSqlTypeMapping.doublePrecisionFloatinPointTests((DataType<Double>)DataType.doubleDataType()).execute(this.getQueryRunner(), this.prestoCreateAsSelect("presto_test_double"));
        TestPostgreSqlTypeMapping.doublePrecisionFloatinPointTests(TestPostgreSqlTypeMapping.postgreSqlDoubleDataType()).execute(this.getQueryRunner(), this.postgresCreateAndInsert("tpch.postgresql_test_double"));
    }

    private static DataTypeTest singlePrecisionFloatingPointTests(DataType<Float> floatType) {
        return DataTypeTest.create((boolean)true).addRoundTrip(floatType, (Object)Float.valueOf(3.14f)).addRoundTrip(floatType, (Object)Float.valueOf((float)Math.PI)).addRoundTrip(floatType, (Object)Float.valueOf(Float.NaN)).addRoundTrip(floatType, (Object)Float.valueOf(Float.NEGATIVE_INFINITY)).addRoundTrip(floatType, (Object)Float.valueOf(Float.POSITIVE_INFINITY)).addRoundTrip(floatType, null);
    }

    private static DataTypeTest doublePrecisionFloatinPointTests(DataType<Double> doubleType) {
        return DataTypeTest.create((boolean)true).addRoundTrip(doubleType, (Object)1.0E100).addRoundTrip(doubleType, (Object)Double.NaN).addRoundTrip(doubleType, (Object)Double.POSITIVE_INFINITY).addRoundTrip(doubleType, (Object)Double.NEGATIVE_INFINITY).addRoundTrip(doubleType, null);
    }

    private void testUnsupportedDataTypeAsIgnored(String dataTypeName, String databaseValue) {
        JdbcSqlExecutor jdbcSqlExecutor = new JdbcSqlExecutor(this.postgreSqlServer.getJdbcUrl());
        try (TestTable table = new TestTable((SqlExecutor)jdbcSqlExecutor, "tpch.unsupported_type", String.format("(key varchar(5), unsupported_column %s)", dataTypeName), (List)ImmutableList.of((Object)"'1', NULL", (Object)("'2', " + databaseValue)));){
            this.assertQuery("SELECT * FROM " + table.getName(), "VALUES 1, 2");
            this.assertQuery("DESC " + table.getName(), "VALUES ('key', 'varchar(5)','', '')");
            this.assertUpdate(String.format("INSERT INTO %s VALUES '3'", table.getName()), 1L);
            this.assertQuery("SELECT * FROM " + table.getName(), "VALUES '1', '2', '3'");
        }
    }

    private void testUnsupportedDataTypeConvertedToVarchar(String dataTypeName, String databaseValue, String prestoValue) {
        JdbcSqlExecutor jdbcSqlExecutor = new JdbcSqlExecutor(this.postgreSqlServer.getJdbcUrl());
        try (TestTable table = new TestTable((SqlExecutor)jdbcSqlExecutor, "tpch.unsupported_type", String.format("(key varchar(5), unsupported_column %s)", dataTypeName), (List)ImmutableList.of((Object)"1, NULL", (Object)("2, " + databaseValue)));){
            Session convertToVarchar = this.withUnsupportedType(UnsupportedTypeHandling.CONVERT_TO_VARCHAR);
            this.assertQuery(convertToVarchar, "SELECT * FROM " + table.getName(), String.format("VALUES ('1', NULL), ('2', %s)", prestoValue));
            this.assertQuery(convertToVarchar, String.format("SELECT key FROM %s WHERE unsupported_column = %s", table.getName(), prestoValue), "VALUES '2'");
            this.assertQuery(convertToVarchar, "DESC " + table.getName(), "VALUES ('key', 'varchar(5)', '', ''), ('unsupported_column', 'varchar', '', '')");
            this.assertQueryFails(convertToVarchar, String.format("INSERT INTO %s (key, unsupported_column) VALUES (3, NULL)", table.getName()), "Insert query has mismatched column types: Table: \\[varchar\\(5\\), varchar\\], Query: \\[integer, unknown\\]");
            this.assertQueryFails(convertToVarchar, String.format("INSERT INTO %s (key, unsupported_column) VALUES (4, %s)", table.getName(), prestoValue), "Insert query has mismatched column types: Table: \\[varchar\\(5\\), varchar\\], Query: \\[integer, varchar\\(50\\)\\]");
            this.assertUpdate(convertToVarchar, String.format("INSERT INTO %s (key) VALUES '5'", table.getName()), 1L);
            this.assertQuery(convertToVarchar, "SELECT * FROM " + table.getName(), String.format("VALUES ('1', NULL), ('2', %s), ('5', NULL)", prestoValue));
        }
    }

    private Session withUnsupportedType(UnsupportedTypeHandling unsupportedTypeHandling) {
        return Session.builder((Session)this.getSession()).setCatalogSessionProperty("postgresql", "unsupported_type_handling", unsupportedTypeHandling.name()).build();
    }

    public static DataType<ZonedDateTime> prestoTimestampWithTimeZoneDataType() {
        return DataType.dataType((String)"timestamp with time zone", (Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE, DateTimeFormatter.ofPattern("'TIMESTAMP '''yyyy-MM-dd HH:mm:ss.SSS VV''")::format, zonedDateTime -> zonedDateTime.withZoneSameInstant(ZoneId.of("UTC")));
    }

    public static DataType<ZonedDateTime> postgreSqlTimestampWithTimeZoneDataType() {
        return DataType.dataType((String)"timestamp with time zone", (Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE, zonedDateTime -> DateTimeFormatter.ofPattern("'TIMESTAMP WITH TIME ZONE '''yyyy-MM-dd HH:mm:ss.SSS VV''").format(zonedDateTime.withZoneSameInstant(ZoneOffset.UTC)), DateTimeFormatter.ofPattern("'TIMESTAMP '''yyyy-MM-dd HH:mm:ss.SSS VV''")::format, zonedDateTime -> zonedDateTime.withZoneSameInstant(ZoneId.of("UTC")));
    }

    public static DataType<String> jsonbDataType() {
        return DataType.dataType((String)"jsonb", (Type)JsonType.JSON, value -> "JSON " + DataType.formatStringLiteral((String)value), Function.identity());
    }

    private DataType<Map<String, String>> hstoreDataType() {
        return DataType.dataType((String)"hstore", (Type)this.getQueryRunner().getMetadata().getType(TypeSignature.mapType((TypeSignature)VarcharType.VARCHAR.getTypeSignature(), (TypeSignature)VarcharType.VARCHAR.getTypeSignature())), TestPostgreSqlTypeMapping::hstoreLiteral, Function.identity());
    }

    private static String hstoreLiteral(Map<String, String> value) {
        return value.entrySet().stream().flatMap(entry -> Stream.of((String)entry.getKey(), (String)entry.getValue())).map(input -> input == null ? "null" : DataType.formatStringLiteral((String)input)).collect(Collectors.joining(",", "hstore(ARRAY[", "]::varchar[])"));
    }

    private DataType<Map<String, String>> varcharMapDataType() {
        return DataType.dataType((String)"hstore", (Type)this.getQueryRunner().getMetadata().getType(TypeSignature.mapType((TypeSignature)VarcharType.VARCHAR.getTypeSignature(), (TypeSignature)VarcharType.VARCHAR.getTypeSignature())), value -> {
            List formatted = (List)value.entrySet().stream().flatMap(entry -> Stream.of((String)entry.getKey(), (String)entry.getValue())).map(string -> {
                if (string == null) {
                    return "null";
                }
                return DataType.formatStringLiteral((String)string);
            }).collect(ImmutableList.toImmutableList());
            ImmutableList.Builder keys = ImmutableList.builder();
            ImmutableList.Builder values = ImmutableList.builder();
            for (int i = 0; i < formatted.size(); i += 2) {
                keys.add((Object)((String)formatted.get(i)));
                values.add((Object)((String)formatted.get(i + 1)));
            }
            return String.format("MAP(ARRAY[%s], ARRAY[%s])", Joiner.on((char)',').join((Iterable)keys.build()), Joiner.on((char)',').join((Iterable)values.build()));
        }, Function.identity());
    }

    public static DataType<UUID> uuidDataType() {
        return DataType.dataType((String)"uuid", (Type)UuidType.UUID, value -> "UUID " + DataType.formatStringLiteral((String)value.toString()), Function.identity());
    }

    private static DataType<byte[]> byteaDataType() {
        return DataType.dataType((String)"bytea", (Type)VarbinaryType.VARBINARY, bytes -> String.format("bytea E'\\\\x%s'", BaseEncoding.base16().encode(bytes)), DataType::binaryLiteral, Function.identity());
    }

    private static DataType<Double> moneyDataType() {
        return DataType.dataType((String)"money", (Type)VarcharType.VARCHAR, String::valueOf, amount -> {
            NumberFormat numberFormat = NumberFormat.getCurrencyInstance(Locale.US);
            return "'" + numberFormat.format(amount) + "'";
        }, amount -> {
            NumberFormat numberFormat = NumberFormat.getCurrencyInstance(Locale.US);
            return numberFormat.format(amount);
        });
    }

    private Session sessionWithArrayAsArray() {
        return Session.builder((Session)this.getQueryRunner().getDefaultSession()).setSystemProperty("postgresql.array_mapping", PostgreSqlConfig.ArrayMapping.AS_ARRAY.name()).build();
    }

    private Session sessionWithDecimalMappingAllowOverflow(RoundingMode roundingMode, int scale) {
        return Session.builder((Session)this.getQueryRunner().getDefaultSession()).setCatalogSessionProperty("postgresql", "decimal_mapping", DecimalConfig.DecimalMapping.ALLOW_OVERFLOW.name()).setCatalogSessionProperty("postgresql", "decimal_rounding_mode", roundingMode.name()).setCatalogSessionProperty("postgresql", "decimal_default_scale", Integer.valueOf(scale).toString()).build();
    }

    private Session sessionWithDecimalMappingStrict(UnsupportedTypeHandling unsupportedTypeHandling) {
        return Session.builder((Session)this.getQueryRunner().getDefaultSession()).setCatalogSessionProperty("postgresql", "decimal_mapping", DecimalConfig.DecimalMapping.STRICT.name()).setCatalogSessionProperty("postgresql", "unsupported_type_handling", unsupportedTypeHandling.name()).build();
    }

    private DataSetup prestoCreateAsSelect(String tableNamePrefix) {
        return this.prestoCreateAsSelect(this.getSession(), tableNamePrefix);
    }

    private DataSetup prestoCreateAsSelect(Session session, String tableNamePrefix) {
        return new CreateAsSelectDataSetup((SqlExecutor)new PrestoSqlExecutor(this.getQueryRunner(), session), tableNamePrefix);
    }

    private DataSetup postgresCreateAndInsert(String tableNamePrefix) {
        return new CreateAndInsertDataSetup((SqlExecutor)new JdbcSqlExecutor(this.postgreSqlServer.getJdbcUrl()), tableNamePrefix);
    }

    private DataSetup postgresCreatePrestoInsert(String tableNamePrefix) {
        return new CreateAndPrestoInsertDataSetup((SqlExecutor)new JdbcSqlExecutor(this.postgreSqlServer.getJdbcUrl()), new PrestoSqlExecutor(this.getQueryRunner()), tableNamePrefix);
    }

    private static void checkIsGap(ZoneId zone, LocalDateTime dateTime) {
        Verify.verify((boolean)TestPostgreSqlTypeMapping.isGap(zone, dateTime), (String)"Expected %s to be a gap in %s", (Object)dateTime, (Object)zone);
    }

    private static boolean isGap(ZoneId zone, LocalDateTime dateTime) {
        return zone.getRules().getValidOffsets(dateTime).isEmpty();
    }

    private static void checkIsDoubled(ZoneId zone, LocalDateTime dateTime) {
        Verify.verify((zone.getRules().getValidOffsets(dateTime).size() == 2 ? 1 : 0) != 0, (String)"Expected %s to be doubled in %s", (Object)dateTime, (Object)zone);
    }

    private static DataType<Float> postgreSqlRealDataType() {
        return DataType.dataType((String)"real", (Type)RealType.REAL, value -> {
            if (Float.isFinite(value.floatValue())) {
                return value.toString();
            }
            if (Float.isNaN(value.floatValue())) {
                return "'NaN'::real";
            }
            return String.format("'%sInfinity'::real", value.floatValue() > 0.0f ? "+" : "-");
        }, arg_0 -> ((DataType)DataType.realDataType()).toPrestoLiteral(arg_0), Function.identity());
    }

    private static DataType<Double> postgreSqlDoubleDataType() {
        return DataType.dataType((String)"double precision", (Type)DoubleType.DOUBLE, value -> {
            if (Double.isFinite(value)) {
                return value.toString();
            }
            if (Double.isNaN(value)) {
                return "'NaN'::double precision";
            }
            return String.format("'%sInfinity'::double precision", value > 0.0 ? "+" : "-");
        }, arg_0 -> ((DataType)DataType.doubleDataType()).toPrestoLiteral(arg_0), Function.identity());
    }
}

