/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.postgresql;

import java.io.Closeable;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import org.testcontainers.containers.PostgreSQLContainer;

public class TestingPostgreSqlServer
implements Closeable {
    private static final String USER = "test";
    private static final String PASSWORD = "test";
    private static final String DATABASE = "tpch";
    private final PostgreSQLContainer dockerContainer = new PostgreSQLContainer("postgres:10.3").withDatabaseName("tpch").withUsername("test").withPassword("test");

    public TestingPostgreSqlServer() {
        this.dockerContainer.start();
    }

    public void execute(String sql) throws SQLException {
        TestingPostgreSqlServer.execute(this.getJdbcUrl(), sql);
    }

    private static void execute(String url, String sql) throws SQLException {
        try (Connection connection = DriverManager.getConnection(url);
             Statement statement = connection.createStatement();){
            statement.execute(sql);
        }
    }

    public String getJdbcUrl() {
        return String.format("jdbc:postgresql://%s:%s/%s?user=%s&password=%s", this.dockerContainer.getContainerIpAddress(), this.dockerContainer.getMappedPort(PostgreSQLContainer.POSTGRESQL_PORT.intValue()), DATABASE, "test", "test");
    }

    @Override
    public void close() {
        this.dockerContainer.close();
    }
}

