/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.postgresql;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.math.LongMath;
import io.airlift.log.Logger;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.prestosql.plugin.base.util.JsonTypeUtil;
import io.prestosql.plugin.jdbc.BaseJdbcClient;
import io.prestosql.plugin.jdbc.BaseJdbcConfig;
import io.prestosql.plugin.jdbc.BooleanReadFunction;
import io.prestosql.plugin.jdbc.ColumnMapping;
import io.prestosql.plugin.jdbc.ConnectionFactory;
import io.prestosql.plugin.jdbc.DecimalConfig;
import io.prestosql.plugin.jdbc.DecimalSessionSessionProperties;
import io.prestosql.plugin.jdbc.DoubleReadFunction;
import io.prestosql.plugin.jdbc.JdbcColumnHandle;
import io.prestosql.plugin.jdbc.JdbcErrorCode;
import io.prestosql.plugin.jdbc.JdbcExpression;
import io.prestosql.plugin.jdbc.JdbcIdentity;
import io.prestosql.plugin.jdbc.JdbcTableHandle;
import io.prestosql.plugin.jdbc.JdbcTypeHandle;
import io.prestosql.plugin.jdbc.LongReadFunction;
import io.prestosql.plugin.jdbc.LongWriteFunction;
import io.prestosql.plugin.jdbc.ObjectReadFunction;
import io.prestosql.plugin.jdbc.ObjectWriteFunction;
import io.prestosql.plugin.jdbc.PredicatePushdownController;
import io.prestosql.plugin.jdbc.ReadFunction;
import io.prestosql.plugin.jdbc.SliceReadFunction;
import io.prestosql.plugin.jdbc.SliceWriteFunction;
import io.prestosql.plugin.jdbc.StandardColumnMappings;
import io.prestosql.plugin.jdbc.TypeHandlingJdbcSessionProperties;
import io.prestosql.plugin.jdbc.UnsupportedTypeHandling;
import io.prestosql.plugin.jdbc.WriteMapping;
import io.prestosql.plugin.jdbc.expression.AggregateFunctionRewriter;
import io.prestosql.plugin.jdbc.expression.ImplementAvgDecimal;
import io.prestosql.plugin.jdbc.expression.ImplementAvgFloatingPoint;
import io.prestosql.plugin.jdbc.expression.ImplementCount;
import io.prestosql.plugin.jdbc.expression.ImplementCountAll;
import io.prestosql.plugin.jdbc.expression.ImplementMinMax;
import io.prestosql.plugin.jdbc.expression.ImplementSum;
import io.prestosql.plugin.postgresql.ImplementAvgBigint;
import io.prestosql.plugin.postgresql.PostgreSqlConfig;
import io.prestosql.plugin.postgresql.PostgreSqlSessionProperties;
import io.prestosql.plugin.postgresql.TypeUtils;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.block.SingleMapBlock;
import io.prestosql.spi.connector.AggregateFunction;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.connector.ConnectorTableMetadata;
import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.spi.connector.TableNotFoundException;
import io.prestosql.spi.type.ArrayType;
import io.prestosql.spi.type.DateTimeEncoding;
import io.prestosql.spi.type.DecimalType;
import io.prestosql.spi.type.LongTimestamp;
import io.prestosql.spi.type.LongTimestampWithTimeZone;
import io.prestosql.spi.type.MapType;
import io.prestosql.spi.type.TimeType;
import io.prestosql.spi.type.TimeZoneKey;
import io.prestosql.spi.type.TimestampType;
import io.prestosql.spi.type.TimestampWithTimeZoneType;
import io.prestosql.spi.type.Timestamps;
import io.prestosql.spi.type.TinyintType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeManager;
import io.prestosql.spi.type.TypeSignature;
import io.prestosql.spi.type.TypeSignatureParameter;
import io.prestosql.spi.type.VarbinaryType;
import io.prestosql.spi.type.VarcharType;
import java.io.IOException;
import java.math.RoundingMode;
import java.sql.Array;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiFunction;
import javax.inject.Inject;
import org.postgresql.core.TypeInfo;
import org.postgresql.jdbc.PgConnection;
import org.postgresql.util.PGobject;

public class PostgreSqlClient
extends BaseJdbcClient {
    private static final Logger log = Logger.get(PostgreSqlClient.class);
    private static final int ARRAY_RESULT_SET_VALUE_COLUMN = 2;
    private static final String DUPLICATE_TABLE_SQLSTATE = "42P07";
    private static final int POSTGRESQL_MAX_SUPPORTED_TIMESTAMP_PRECISION = 6;
    private final Type jsonType;
    private final Type uuidType;
    private final MapType varcharMapType;
    private final String[] tableTypes;
    private final AggregateFunctionRewriter aggregateFunctionRewriter;

    @Inject
    public PostgreSqlClient(BaseJdbcConfig config, PostgreSqlConfig postgreSqlConfig, ConnectionFactory connectionFactory, TypeManager typeManager) {
        super(config, "\"", connectionFactory);
        this.jsonType = typeManager.getType(new TypeSignature("json", new TypeSignatureParameter[0]));
        this.uuidType = typeManager.getType(new TypeSignature("uuid", new TypeSignatureParameter[0]));
        this.varcharMapType = (MapType)typeManager.getType(TypeSignature.mapType((TypeSignature)VarcharType.VARCHAR.getTypeSignature(), (TypeSignature)VarcharType.VARCHAR.getTypeSignature()));
        ArrayList tableTypes = new ArrayList();
        Collections.addAll(tableTypes, "TABLE", "VIEW", "MATERIALIZED VIEW", "FOREIGN TABLE");
        if (postgreSqlConfig.isIncludeSystemTables()) {
            Collections.addAll(tableTypes, "SYSTEM TABLE", "SYSTEM VIEW");
        }
        this.tableTypes = tableTypes.toArray(new String[0]);
        JdbcTypeHandle bigintTypeHandle = new JdbcTypeHandle(-5, Optional.of("bigint"), 0, Optional.empty(), Optional.empty(), Optional.empty());
        this.aggregateFunctionRewriter = new AggregateFunctionRewriter(arg_0 -> ((PostgreSqlClient)this).quoted(arg_0), (Set)ImmutableSet.builder().add((Object)new ImplementCountAll(bigintTypeHandle)).add((Object)new ImplementCount(bigintTypeHandle)).add((Object)new ImplementMinMax()).add((Object)new ImplementSum(PostgreSqlClient::toTypeHandle)).add((Object)new ImplementAvgFloatingPoint()).add((Object)new ImplementAvgDecimal()).add((Object)new ImplementAvgBigint()).build());
    }

    public void createTable(ConnectorSession session, ConnectorTableMetadata tableMetadata) {
        try {
            this.createTable(session, tableMetadata, tableMetadata.getTable().getTableName());
        }
        catch (SQLException e) {
            boolean exists = DUPLICATE_TABLE_SQLSTATE.equals(e.getSQLState());
            throw new PrestoException((ErrorCodeSupplier)(exists ? StandardErrorCode.ALREADY_EXISTS : JdbcErrorCode.JDBC_ERROR), (Throwable)e);
        }
    }

    protected void renameTable(JdbcIdentity identity, String catalogName, String schemaName, String tableName, SchemaTableName newTable) {
        if (!schemaName.equals(newTable.getSchemaName())) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Table rename across schemas is not supported in PostgreSQL");
        }
        String sql = String.format("ALTER TABLE %s RENAME TO %s", this.quoted(catalogName, schemaName, tableName), this.quoted(newTable.getTableName()));
        this.execute(identity, sql);
    }

    public PreparedStatement getPreparedStatement(Connection connection, String sql) throws SQLException {
        connection.setAutoCommit(false);
        PreparedStatement statement = connection.prepareStatement(sql);
        statement.setFetchSize(1000);
        return statement;
    }

    protected ResultSet getTables(Connection connection, Optional<String> schemaName, Optional<String> tableName) throws SQLException {
        DatabaseMetaData metadata = connection.getMetaData();
        return metadata.getTables(connection.getCatalog(), PostgreSqlClient.escapeNamePattern(schemaName, (String)metadata.getSearchStringEscape()).orElse(null), PostgreSqlClient.escapeNamePattern(tableName, (String)metadata.getSearchStringEscape()).orElse(null), (String[])this.tableTypes.clone());
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public List<JdbcColumnHandle> getColumns(ConnectorSession session, JdbcTableHandle tableHandle) {
        try (Connection connection = this.connectionFactory.openConnection(JdbcIdentity.from((ConnectorSession)session));){
            ImmutableList immutableList;
            block18: {
                Object arrayColumnDimensions = ImmutableMap.of();
                if (PostgreSqlSessionProperties.getArrayMapping(session) == PostgreSqlConfig.ArrayMapping.AS_ARRAY) {
                    arrayColumnDimensions = PostgreSqlClient.getArrayColumnDimensions(connection, tableHandle);
                }
                ResultSet resultSet = this.getColumns(tableHandle, connection.getMetaData());
                try {
                    ArrayList<JdbcColumnHandle> columns = new ArrayList<JdbcColumnHandle>();
                    while (resultSet.next()) {
                        String columnName = resultSet.getString("COLUMN_NAME");
                        JdbcTypeHandle typeHandle = new JdbcTypeHandle(resultSet.getInt("DATA_TYPE"), Optional.of(resultSet.getString("TYPE_NAME")), resultSet.getInt("COLUMN_SIZE"), PostgreSqlClient.getInteger((ResultSet)resultSet, (String)"DECIMAL_DIGITS"), Optional.ofNullable((Integer)arrayColumnDimensions.get(columnName)), Optional.empty());
                        Optional<ColumnMapping> columnMapping = this.toPrestoType(session, connection, typeHandle);
                        log.debug("Mapping data type of '%s' column '%s': %s mapped to %s", new Object[]{tableHandle.getSchemaTableName(), columnName, typeHandle, columnMapping});
                        if (columnMapping.isPresent()) {
                            boolean nullable = resultSet.getInt("NULLABLE") != 0;
                            Optional<String> comment = Optional.ofNullable(resultSet.getString("REMARKS"));
                            columns.add(JdbcColumnHandle.builder().setColumnName(columnName).setJdbcTypeHandle(typeHandle).setColumnType(columnMapping.get().getType()).setNullable(nullable).setComment(comment).build());
                        }
                        if (!columnMapping.isEmpty()) continue;
                        UnsupportedTypeHandling unsupportedTypeHandling = TypeHandlingJdbcSessionProperties.getUnsupportedTypeHandling((ConnectorSession)session);
                        Verify.verify((unsupportedTypeHandling == UnsupportedTypeHandling.IGNORE ? 1 : 0) != 0, (String)"Unsupported type handling is set to %s, but toPrestoType() returned empty for %s", (Object)unsupportedTypeHandling, (Object)typeHandle);
                    }
                    if (columns.isEmpty()) {
                        throw new TableNotFoundException(tableHandle.getSchemaTableName());
                    }
                    immutableList = ImmutableList.copyOf(columns);
                    if (resultSet == null) break block18;
                }
                catch (Throwable throwable) {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                resultSet.close();
            }
            return immutableList;
        }
        catch (SQLException e) {
            throw new PrestoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
        }
    }

    private static Map<String, Integer> getArrayColumnDimensions(Connection connection, JdbcTableHandle tableHandle) throws SQLException {
        String sql = "SELECT att.attname, greatest(att.attndims, 1) AS attndims FROM pg_attribute att   JOIN pg_type attyp ON att.atttypid = attyp.oid  JOIN pg_class tbl ON tbl.oid = att.attrelid   JOIN pg_namespace ns ON tbl.relnamespace = ns.oid WHERE ns.nspname = ? AND tbl.relname = ? AND attyp.typcategory = 'A' ";
        try (PreparedStatement statement = connection.prepareStatement(sql);){
            statement.setString(1, tableHandle.getSchemaName());
            statement.setString(2, tableHandle.getTableName());
            HashMap<String, Integer> arrayColumnDimensions = new HashMap<String, Integer>();
            try (ResultSet resultSet = statement.executeQuery();){
                while (resultSet.next()) {
                    arrayColumnDimensions.put(resultSet.getString("attname"), resultSet.getInt("attndims"));
                }
            }
            HashMap<String, Integer> hashMap = arrayColumnDimensions;
            return hashMap;
        }
    }

    public Optional<ColumnMapping> toPrestoType(ConnectorSession session, Connection connection, JdbcTypeHandle typeHandle) {
        Optional<ColumnMapping> columnMapping;
        String jdbcTypeName = (String)typeHandle.getJdbcTypeName().orElseThrow(() -> new PrestoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, "Type name is missing: " + typeHandle));
        Optional mapping = this.getForcedMappingToVarchar(typeHandle);
        if (mapping.isPresent()) {
            return mapping;
        }
        switch (jdbcTypeName) {
            case "money": {
                return Optional.of(PostgreSqlClient.moneyColumnMapping());
            }
            case "uuid": {
                return Optional.of(this.uuidColumnMapping());
            }
            case "jsonb": 
            case "json": {
                return Optional.of(this.jsonColumnMapping());
            }
            case "timestamptz": {
                int decimalDigits = (Integer)typeHandle.getDecimalDigits().orElseThrow(() -> new IllegalStateException("decimal digits not present"));
                return Optional.of(PostgreSqlClient.timestampWithTimeZoneColumnMapping(decimalDigits));
            }
            case "hstore": {
                return Optional.of(this.hstoreColumnMapping(session));
            }
        }
        if (typeHandle.getJdbcType() == 12 && !jdbcTypeName.equals("varchar")) {
            return Optional.of(PostgreSqlClient.typedVarcharColumnMapping(jdbcTypeName));
        }
        if (typeHandle.getJdbcType() == 92) {
            int decimalDigits = (Integer)typeHandle.getDecimalDigits().orElseThrow(() -> new IllegalStateException("decimal digits not present"));
            return Optional.of(PostgreSqlClient.timeColumnMapping(decimalDigits));
        }
        if (typeHandle.getJdbcType() == 93) {
            int decimalDigits = (Integer)typeHandle.getDecimalDigits().orElseThrow(() -> new IllegalStateException("decimal digits not present"));
            TimestampType timestampType = TimestampType.createTimestampType((int)decimalDigits);
            return Optional.of(ColumnMapping.longMapping((Type)timestampType, (LongReadFunction)StandardColumnMappings.timestampReadFunction((TimestampType)timestampType), PostgreSqlClient::shortTimestampWriteFunction));
        }
        if (typeHandle.getJdbcType() == 2 && DecimalSessionSessionProperties.getDecimalRounding((ConnectorSession)session) == DecimalConfig.DecimalMapping.ALLOW_OVERFLOW) {
            if (typeHandle.getColumnSize() == 131089) {
                return Optional.of(StandardColumnMappings.decimalColumnMapping((DecimalType)DecimalType.createDecimalType((int)38, (int)DecimalSessionSessionProperties.getDecimalDefaultScale((ConnectorSession)session)), (RoundingMode)DecimalSessionSessionProperties.getDecimalRoundingMode((ConnectorSession)session)));
            }
            int precision = typeHandle.getColumnSize();
            int decimalDigits = (Integer)typeHandle.getDecimalDigits().orElseThrow(() -> new IllegalStateException("decimal digits not present"));
            if (precision > 38) {
                int scale = Math.min(decimalDigits, DecimalSessionSessionProperties.getDecimalDefaultScale((ConnectorSession)session));
                return Optional.of(StandardColumnMappings.decimalColumnMapping((DecimalType)DecimalType.createDecimalType((int)38, (int)scale), (RoundingMode)DecimalSessionSessionProperties.getDecimalRoundingMode((ConnectorSession)session)));
            }
        }
        if (typeHandle.getJdbcType() == 2003 && (columnMapping = this.arrayToPrestoType(session, connection, typeHandle)).isPresent()) {
            return columnMapping;
        }
        return super.toPrestoType(session, connection, typeHandle);
    }

    private Optional<ColumnMapping> arrayToPrestoType(ConnectorSession session, Connection connection, JdbcTypeHandle typeHandle) {
        Preconditions.checkArgument((typeHandle.getJdbcType() == 2003 ? 1 : 0) != 0, (Object)"Not array type");
        PostgreSqlConfig.ArrayMapping arrayMapping = PostgreSqlSessionProperties.getArrayMapping(session);
        if (arrayMapping == PostgreSqlConfig.ArrayMapping.DISABLED) {
            return Optional.empty();
        }
        JdbcTypeHandle baseElementTypeHandle = PostgreSqlClient.getArrayElementTypeHandle(connection, typeHandle);
        String baseElementTypeName = (String)baseElementTypeHandle.getJdbcTypeName().orElseThrow(() -> new PrestoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, "Element type name is missing: " + baseElementTypeHandle));
        if (baseElementTypeHandle.getJdbcType() == -2) {
            return Optional.empty();
        }
        Optional<ColumnMapping> baseElementMapping = this.toPrestoType(session, connection, baseElementTypeHandle);
        if (arrayMapping == PostgreSqlConfig.ArrayMapping.AS_ARRAY) {
            if (typeHandle.getArrayDimensions().isEmpty()) {
                return Optional.empty();
            }
            return baseElementMapping.map(elementMapping -> {
                ArrayType prestoArrayType = new ArrayType(elementMapping.getType());
                ColumnMapping arrayColumnMapping = PostgreSqlClient.arrayColumnMapping(session, prestoArrayType, elementMapping, baseElementTypeName);
                int arrayDimensions = (Integer)typeHandle.getArrayDimensions().get();
                for (int i = 1; i < arrayDimensions; ++i) {
                    prestoArrayType = new ArrayType((Type)prestoArrayType);
                    arrayColumnMapping = PostgreSqlClient.arrayColumnMapping(session, prestoArrayType, arrayColumnMapping, baseElementTypeName);
                }
                return arrayColumnMapping;
            });
        }
        if (arrayMapping == PostgreSqlConfig.ArrayMapping.AS_JSON) {
            return baseElementMapping.map(elementMapping -> this.arrayAsJsonColumnMapping(session, (ColumnMapping)elementMapping));
        }
        throw new IllegalStateException("Unsupported array mapping type: " + arrayMapping);
    }

    public WriteMapping toWriteMapping(ConnectorSession session, Type type) {
        if (VarbinaryType.VARBINARY.equals((Object)type)) {
            return WriteMapping.sliceMapping((String)"bytea", (SliceWriteFunction)StandardColumnMappings.varbinaryWriteFunction());
        }
        if (type instanceof TimeType) {
            TimeType timeType = (TimeType)type;
            if (timeType.getPrecision() <= 6) {
                return WriteMapping.longMapping((String)String.format("time(%s)", timeType.getPrecision()), (LongWriteFunction)PostgreSqlClient.timeWriteFunction(timeType.getPrecision()));
            }
            return WriteMapping.longMapping((String)String.format("time(%s)", 6), (LongWriteFunction)PostgreSqlClient.timeWriteFunction(6));
        }
        if (type instanceof TimestampType) {
            TimestampType timestampType = (TimestampType)type;
            if (timestampType.getPrecision() <= 6) {
                Verify.verify((timestampType.getPrecision() <= 6 ? 1 : 0) != 0);
                return WriteMapping.longMapping((String)String.format("timestamp(%s)", timestampType.getPrecision()), PostgreSqlClient::shortTimestampWriteFunction);
            }
            Verify.verify((timestampType.getPrecision() > 6 ? 1 : 0) != 0);
            return WriteMapping.objectMapping((String)String.format("timestamp(%s)", 6), (ObjectWriteFunction)PostgreSqlClient.longTimestampWriteFunction());
        }
        if (type instanceof TimestampWithTimeZoneType) {
            TimestampWithTimeZoneType timestampWithTimeZoneType = (TimestampWithTimeZoneType)type;
            if (timestampWithTimeZoneType.getPrecision() <= 6) {
                String dataType = String.format("timestamptz(%d)", timestampWithTimeZoneType.getPrecision());
                if (timestampWithTimeZoneType.getPrecision() <= 3) {
                    return WriteMapping.longMapping((String)dataType, (LongWriteFunction)PostgreSqlClient.shortTimestampWithTimeZoneWriteFunction());
                }
                return WriteMapping.objectMapping((String)dataType, (ObjectWriteFunction)PostgreSqlClient.longTimestampWithTimeZoneWriteFunction());
            }
            return WriteMapping.objectMapping((String)String.format("timestamptz(%d)", 6), (ObjectWriteFunction)PostgreSqlClient.longTimestampWithTimeZoneWriteFunction());
        }
        if (TinyintType.TINYINT.equals((Object)type)) {
            return WriteMapping.longMapping((String)"smallint", (LongWriteFunction)StandardColumnMappings.tinyintWriteFunction());
        }
        if (type.equals(this.jsonType)) {
            return WriteMapping.sliceMapping((String)"jsonb", (SliceWriteFunction)PostgreSqlClient.typedVarcharWriteFunction("json"));
        }
        if (type.equals(this.uuidType)) {
            return WriteMapping.sliceMapping((String)"uuid", (SliceWriteFunction)PostgreSqlClient.uuidWriteFunction());
        }
        if (type instanceof ArrayType && PostgreSqlSessionProperties.getArrayMapping(session) == PostgreSqlConfig.ArrayMapping.AS_ARRAY) {
            Type elementType = ((ArrayType)type).getElementType();
            String elementDataType = this.toWriteMapping(session, elementType).getDataType();
            return WriteMapping.objectMapping((String)(elementDataType + "[]"), (ObjectWriteFunction)PostgreSqlClient.arrayWriteFunction(session, elementType, TypeUtils.getArrayElementPgTypeName(session, this, elementType)));
        }
        return super.toWriteMapping(session, type);
    }

    public Optional<JdbcExpression> implementAggregation(ConnectorSession session, AggregateFunction aggregate, Map<String, ColumnHandle> assignments) {
        return this.aggregateFunctionRewriter.rewrite(session, aggregate, assignments);
    }

    private static Optional<JdbcTypeHandle> toTypeHandle(DecimalType decimalType) {
        return Optional.of(new JdbcTypeHandle(2, Optional.of("decimal"), decimalType.getPrecision(), Optional.of(decimalType.getScale()), Optional.empty(), Optional.empty()));
    }

    protected Optional<BiFunction<String, Long, String>> limitFunction() {
        return Optional.of((sql, limit) -> sql + " LIMIT " + limit);
    }

    public boolean isLimitGuaranteed(ConnectorSession session) {
        return true;
    }

    private static ColumnMapping timeColumnMapping(int precision) {
        Verify.verify((precision <= 6 ? 1 : 0) != 0, (String)"Unsupported precision: %s", (int)precision);
        return ColumnMapping.longMapping((Type)TimeType.createTimeType((int)precision), (resultSet, columnIndex) -> {
            LocalTime time = resultSet.getObject(columnIndex, LocalTime.class);
            long nanosOfDay = time.toNanoOfDay();
            if (nanosOfDay == 86399999999999L) {
                nanosOfDay = 86400000000000L - LongMath.pow((long)10L, (int)(9 - precision));
            }
            long picosOfDay = nanosOfDay * 1000L;
            return Timestamps.round((long)picosOfDay, (int)(12 - precision));
        }, (LongWriteFunction)PostgreSqlClient.timeWriteFunction(precision), (PredicatePushdownController)ColumnMapping.DISABLE_PUSHDOWN);
    }

    public static LongWriteFunction timeWriteFunction(int precision) {
        Preconditions.checkArgument((precision <= 6 ? 1 : 0) != 0, (String)"Unsupported precision: %s", (int)precision);
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("HH:mm:ss.SSSSSS");
        return (statement, index, picosOfDay) -> {
            if ((picosOfDay = Timestamps.round((long)picosOfDay, (int)(12 - precision))) == 86400000000000000L) {
                picosOfDay = 0L;
            }
            LocalTime localTime = LocalTime.ofNanoOfDay(picosOfDay / 1000L);
            PGobject pgObject = new PGobject();
            pgObject.setType("time");
            pgObject.setValue(dateTimeFormatter.format(localTime));
            statement.setObject(index, pgObject);
        };
    }

    private static void shortTimestampWriteFunction(PreparedStatement statement, int index, long epochMicros) throws SQLException {
        LocalDateTime localDateTime = StandardColumnMappings.fromPrestoTimestamp((long)epochMicros);
        statement.setObject(index, TypeUtils.toPgTimestamp(localDateTime));
    }

    private static ObjectWriteFunction longTimestampWriteFunction() {
        return ObjectWriteFunction.of(LongTimestamp.class, (statement, index, timestamp) -> {
            Verify.verify((boolean)true);
            long epochMicros = timestamp.getEpochMicros();
            if (timestamp.getPicosOfMicro() >= 500000) {
                ++epochMicros;
            }
            PostgreSqlClient.shortTimestampWriteFunction(statement, index, epochMicros);
        });
    }

    public void setColumnComment(JdbcIdentity identity, JdbcTableHandle handle, JdbcColumnHandle column, Optional<String> comment) {
        String sql = String.format("COMMENT ON COLUMN %s.%s IS %s", this.quoted(handle.getRemoteTableName()), this.quoted(column.getColumnName()), comment.isPresent() ? String.format("'%s'", comment.get()) : "NULL");
        this.execute(identity, sql);
    }

    private static ColumnMapping timestampWithTimeZoneColumnMapping(int precision) {
        Preconditions.checkArgument((precision <= 6 ? 1 : 0) != 0, (String)"unsupported precision value %d", (int)precision);
        TimestampWithTimeZoneType prestoType = TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)precision);
        if (precision <= 3) {
            return ColumnMapping.longMapping((Type)prestoType, (LongReadFunction)PostgreSqlClient.shortTimestampWithTimeZoneReadFunction(), (LongWriteFunction)PostgreSqlClient.shortTimestampWithTimeZoneWriteFunction());
        }
        return ColumnMapping.objectMapping((Type)prestoType, (ObjectReadFunction)PostgreSqlClient.longTimestampWithTimeZoneReadFunction(), (ObjectWriteFunction)PostgreSqlClient.longTimestampWithTimeZoneWriteFunction());
    }

    private static LongReadFunction shortTimestampWithTimeZoneReadFunction() {
        return (resultSet, columnIndex) -> {
            long millisUtc = resultSet.getTimestamp(columnIndex).getTime();
            return DateTimeEncoding.packDateTimeWithZone((long)millisUtc, (TimeZoneKey)TimeZoneKey.UTC_KEY);
        };
    }

    private static LongWriteFunction shortTimestampWithTimeZoneWriteFunction() {
        return (statement, index, value) -> {
            long millisUtc = DateTimeEncoding.unpackMillisUtc((long)value);
            statement.setTimestamp(index, new Timestamp(millisUtc));
        };
    }

    private static ObjectReadFunction longTimestampWithTimeZoneReadFunction() {
        return ObjectReadFunction.of(LongTimestampWithTimeZone.class, (resultSet, columnIndex) -> {
            OffsetDateTime offsetDateTime = resultSet.getObject(columnIndex, OffsetDateTime.class);
            return LongTimestampWithTimeZone.fromEpochSecondsAndFraction((long)offsetDateTime.toEpochSecond(), (long)((long)offsetDateTime.getNano() * 1000L), (TimeZoneKey)TimeZoneKey.UTC_KEY);
        });
    }

    private static ObjectWriteFunction longTimestampWithTimeZoneWriteFunction() {
        return ObjectWriteFunction.of(LongTimestampWithTimeZone.class, (statement, index, value) -> {
            long epochSeconds = value.getEpochMillis() / 1000L;
            long nanosOfSecond = value.getEpochMillis() % 1000L * 1000000L + (long)(value.getPicosOfMilli() / 1000);
            statement.setObject(index, OffsetDateTime.ofInstant(Instant.ofEpochSecond(epochSeconds, nanosOfSecond), TimeZoneKey.UTC_KEY.getZoneId()));
        });
    }

    private ColumnMapping hstoreColumnMapping(ConnectorSession session) {
        return ColumnMapping.objectMapping((Type)this.varcharMapType, (ObjectReadFunction)this.varcharMapReadFunction(), (ObjectWriteFunction)this.hstoreWriteFunction(session), (PredicatePushdownController)ColumnMapping.DISABLE_PUSHDOWN);
    }

    private ObjectReadFunction varcharMapReadFunction() {
        return ObjectReadFunction.of(Block.class, (resultSet, columnIndex) -> {
            Map map = (Map)resultSet.getObject(columnIndex);
            BlockBuilder keyBlockBuilder = this.varcharMapType.getKeyType().createBlockBuilder(null, map.size());
            BlockBuilder valueBlockBuilder = this.varcharMapType.getValueType().createBlockBuilder(null, map.size());
            for (Map.Entry entry : map.entrySet()) {
                if (entry.getKey() == null) {
                    throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "hstore key is null");
                }
                this.varcharMapType.getKeyType().writeSlice(keyBlockBuilder, Slices.utf8Slice((String)((String)entry.getKey())));
                if (entry.getValue() == null) {
                    valueBlockBuilder.appendNull();
                    continue;
                }
                this.varcharMapType.getValueType().writeSlice(valueBlockBuilder, Slices.utf8Slice((String)((String)entry.getValue())));
            }
            return (Block)this.varcharMapType.createBlockFromKeyValue(Optional.empty(), new int[]{0, map.size()}, keyBlockBuilder.build(), valueBlockBuilder.build()).getObject(0, Block.class);
        });
    }

    private ObjectWriteFunction hstoreWriteFunction(ConnectorSession session) {
        return ObjectWriteFunction.of(Block.class, (statement, index, block) -> {
            Preconditions.checkArgument((boolean)(block instanceof SingleMapBlock), (String)"wrong block type: %s. expected SingleMapBlock", (Object)block.getClass().getSimpleName());
            HashMap<Object, Object> map = new HashMap<Object, Object>();
            for (int i = 0; i < block.getPositionCount(); i += 2) {
                map.put(this.varcharMapType.getKeyType().getObjectValue(session, block, i), this.varcharMapType.getValueType().getObjectValue(session, block, i + 1));
            }
            statement.setObject(index, Collections.unmodifiableMap(map));
        });
    }

    private static ColumnMapping arrayColumnMapping(ConnectorSession session, ArrayType arrayType, ColumnMapping arrayElementMapping, String baseElementJdbcTypeName) {
        return ColumnMapping.objectMapping((Type)arrayType, (ObjectReadFunction)PostgreSqlClient.arrayReadFunction(arrayType.getElementType(), arrayElementMapping.getReadFunction()), (ObjectWriteFunction)PostgreSqlClient.arrayWriteFunction(session, arrayType.getElementType(), baseElementJdbcTypeName));
    }

    private static ObjectReadFunction arrayReadFunction(Type elementType, ReadFunction elementReadFunction) {
        return ObjectReadFunction.of(Block.class, (resultSet, columnIndex) -> {
            Array array = resultSet.getArray(columnIndex);
            BlockBuilder builder = elementType.createBlockBuilder(null, 10);
            try (ResultSet arrayAsResultSet = array.getResultSet();){
                while (arrayAsResultSet.next()) {
                    if (elementReadFunction.isNull(arrayAsResultSet, 2)) {
                        builder.appendNull();
                        continue;
                    }
                    if (elementType.getJavaType() == Boolean.TYPE) {
                        elementType.writeBoolean(builder, ((BooleanReadFunction)elementReadFunction).readBoolean(arrayAsResultSet, 2));
                        continue;
                    }
                    if (elementType.getJavaType() == Long.TYPE) {
                        elementType.writeLong(builder, ((LongReadFunction)elementReadFunction).readLong(arrayAsResultSet, 2));
                        continue;
                    }
                    if (elementType.getJavaType() == Double.TYPE) {
                        elementType.writeDouble(builder, ((DoubleReadFunction)elementReadFunction).readDouble(arrayAsResultSet, 2));
                        continue;
                    }
                    if (elementType.getJavaType() == Slice.class) {
                        elementType.writeSlice(builder, ((SliceReadFunction)elementReadFunction).readSlice(arrayAsResultSet, 2));
                        continue;
                    }
                    elementType.writeObject(builder, ((ObjectReadFunction)elementReadFunction).readObject(arrayAsResultSet, 2));
                }
            }
            return builder.build();
        });
    }

    private static ObjectWriteFunction arrayWriteFunction(ConnectorSession session, Type elementType, String baseElementJdbcTypeName) {
        return ObjectWriteFunction.of(Block.class, (statement, index, block) -> {
            Array jdbcArray = statement.getConnection().createArrayOf(baseElementJdbcTypeName, TypeUtils.getJdbcObjectArray(session, elementType, block));
            statement.setArray(index, jdbcArray);
        });
    }

    private ColumnMapping arrayAsJsonColumnMapping(ConnectorSession session, ColumnMapping baseElementMapping) {
        return ColumnMapping.sliceMapping((Type)this.jsonType, (SliceReadFunction)PostgreSqlClient.arrayAsJsonReadFunction(session, baseElementMapping), (statement, index, block) -> {
            throw new UnsupportedOperationException();
        }, (PredicatePushdownController)ColumnMapping.DISABLE_PUSHDOWN);
    }

    private static SliceReadFunction arrayAsJsonReadFunction(ConnectorSession session, ColumnMapping baseElementMapping) {
        return (resultSet, columnIndex) -> {
            Object jdbcArray = resultSet.getArray(columnIndex).getArray();
            int arrayDimensions = TypeUtils.arrayDepth(jdbcArray);
            ReadFunction readFunction = baseElementMapping.getReadFunction();
            Type type = baseElementMapping.getType();
            for (int i = 0; i < arrayDimensions; ++i) {
                readFunction = PostgreSqlClient.arrayReadFunction(type, readFunction);
                type = new ArrayType(type);
            }
            Block block = (Block)((ObjectReadFunction)readFunction).readObject(resultSet, columnIndex);
            BlockBuilder builder = type.createBlockBuilder(null, 1);
            type.writeObject(builder, (Object)block);
            Object value = type.getObjectValue(session, builder.build(), 0);
            try {
                return JsonTypeUtil.toJsonValue((Object)value);
            }
            catch (IOException e) {
                throw new PrestoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, "Conversion to JSON failed for  " + type.getDisplayName(), (Throwable)e);
            }
        };
    }

    private static JdbcTypeHandle getArrayElementTypeHandle(Connection connection, JdbcTypeHandle arrayTypeHandle) {
        String jdbcTypeName = (String)arrayTypeHandle.getJdbcTypeName().orElseThrow(() -> new PrestoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, "Type name is missing: " + arrayTypeHandle));
        try {
            TypeInfo typeInfo = connection.unwrap(PgConnection.class).getTypeInfo();
            int pgElementOid = typeInfo.getPGArrayElement(typeInfo.getPGType(jdbcTypeName));
            Verify.verify((boolean)arrayTypeHandle.getCaseSensitivity().isEmpty(), (String)"Case sensitivity not supported", (Object[])new Object[0]);
            return new JdbcTypeHandle(typeInfo.getSQLType(pgElementOid), Optional.of(typeInfo.getPGType(pgElementOid)), arrayTypeHandle.getColumnSize(), arrayTypeHandle.getDecimalDigits(), arrayTypeHandle.getArrayDimensions(), Optional.empty());
        }
        catch (SQLException e) {
            throw new PrestoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
        }
    }

    private ColumnMapping jsonColumnMapping() {
        return ColumnMapping.sliceMapping((Type)this.jsonType, (resultSet, columnIndex) -> JsonTypeUtil.jsonParse((Slice)Slices.utf8Slice((String)resultSet.getString(columnIndex))), (SliceWriteFunction)PostgreSqlClient.typedVarcharWriteFunction("json"), (PredicatePushdownController)ColumnMapping.DISABLE_PUSHDOWN);
    }

    private static ColumnMapping typedVarcharColumnMapping(String jdbcTypeName) {
        return ColumnMapping.sliceMapping((Type)VarcharType.VARCHAR, (resultSet, columnIndex) -> Slices.utf8Slice((String)resultSet.getString(columnIndex)), (SliceWriteFunction)PostgreSqlClient.typedVarcharWriteFunction(jdbcTypeName));
    }

    private static SliceWriteFunction typedVarcharWriteFunction(String jdbcTypeName) {
        return (statement, index, value) -> {
            PGobject pgObject = new PGobject();
            pgObject.setType(jdbcTypeName);
            pgObject.setValue(value.toStringUtf8());
            statement.setObject(index, pgObject);
        };
    }

    private static ColumnMapping moneyColumnMapping() {
        return ColumnMapping.sliceMapping((Type)VarcharType.VARCHAR, (SliceReadFunction)new SliceReadFunction(){

            public boolean isNull(ResultSet resultSet, int columnIndex) throws SQLException {
                resultSet.getString(columnIndex);
                return resultSet.wasNull();
            }

            public Slice readSlice(ResultSet resultSet, int columnIndex) throws SQLException {
                return Slices.utf8Slice((String)resultSet.getString(columnIndex));
            }
        }, (statement, index, value) -> {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Money type is not supported for INSERT");
        }, (PredicatePushdownController)ColumnMapping.DISABLE_PUSHDOWN);
    }

    private static SliceWriteFunction uuidWriteFunction() {
        return (statement, index, value) -> {
            long high = Long.reverseBytes(value.getLong(0));
            long low = Long.reverseBytes(value.getLong(8));
            UUID uuid = new UUID(high, low);
            statement.setObject(index, (Object)uuid, 1111);
        };
    }

    private static Slice uuidSlice(UUID uuid) {
        return Slices.wrappedLongArray((long[])new long[]{Long.reverseBytes(uuid.getMostSignificantBits()), Long.reverseBytes(uuid.getLeastSignificantBits())});
    }

    private ColumnMapping uuidColumnMapping() {
        return ColumnMapping.sliceMapping((Type)this.uuidType, (resultSet, columnIndex) -> PostgreSqlClient.uuidSlice((UUID)resultSet.getObject(columnIndex)), (SliceWriteFunction)PostgreSqlClient.uuidWriteFunction());
    }
}

