/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.postgresql;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Shorts;
import com.google.common.primitives.SignedBytes;
import io.airlift.slice.Slice;
import io.prestosql.plugin.jdbc.StandardColumnMappings;
import io.prestosql.plugin.postgresql.PostgreSqlClient;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.type.ArrayType;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.BooleanType;
import io.prestosql.spi.type.CharType;
import io.prestosql.spi.type.DateTimeEncoding;
import io.prestosql.spi.type.DateType;
import io.prestosql.spi.type.DecimalType;
import io.prestosql.spi.type.Decimals;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.spi.type.IntegerType;
import io.prestosql.spi.type.LongTimestampWithTimeZone;
import io.prestosql.spi.type.RealType;
import io.prestosql.spi.type.SmallintType;
import io.prestosql.spi.type.TimeZoneKey;
import io.prestosql.spi.type.TimestampType;
import io.prestosql.spi.type.TimestampWithTimeZoneType;
import io.prestosql.spi.type.TinyintType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarcharType;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.util.concurrent.TimeUnit;
import org.joda.time.DateTimeZone;
import org.postgresql.util.PGobject;

final class TypeUtils {
    private TypeUtils() {
    }

    static String getArrayElementPgTypeName(ConnectorSession session, PostgreSqlClient client, Type elementType) {
        if (DoubleType.DOUBLE.equals((Object)elementType)) {
            return "float";
        }
        if (RealType.REAL.equals((Object)elementType)) {
            return "float4";
        }
        if (elementType instanceof VarcharType || elementType instanceof CharType) {
            return "varchar";
        }
        if (elementType instanceof TimestampWithTimeZoneType) {
            return "timestamptz";
        }
        if (elementType instanceof TimestampType) {
            return "timestamp";
        }
        if (elementType instanceof DecimalType) {
            return "decimal";
        }
        if (elementType instanceof ArrayType) {
            return TypeUtils.getArrayElementPgTypeName(session, client, ((ArrayType)elementType).getElementType());
        }
        return client.toWriteMapping(session, elementType).getDataType();
    }

    static Object[] getJdbcObjectArray(ConnectorSession session, Type elementType, Block block) throws SQLException {
        int positionCount = block.getPositionCount();
        Object[] valuesArray = new Object[positionCount];
        int subArrayLength = 1;
        for (int i = 0; i < positionCount; ++i) {
            Object objectValue;
            valuesArray[i] = objectValue = TypeUtils.prestoNativeToJdbcObject(session, elementType, io.prestosql.spi.type.TypeUtils.readNativeValue((Type)elementType, (Block)block, (int)i));
            if (objectValue == null || !objectValue.getClass().isArray()) continue;
            subArrayLength = Math.max(subArrayLength, Array.getLength(objectValue));
        }
        if (elementType instanceof ArrayType) {
            TypeUtils.handleArrayNulls(valuesArray, subArrayLength);
        }
        return valuesArray;
    }

    public static int arrayDepth(Object jdbcArray) {
        Preconditions.checkArgument((boolean)jdbcArray.getClass().isArray(), (Object)"jdbcArray is not an array");
        int depth = 0;
        while (jdbcArray != null && jdbcArray.getClass().isArray()) {
            ++depth;
            if (Array.getLength(jdbcArray) == 0) {
                return depth;
            }
            jdbcArray = Array.get(jdbcArray, 0);
        }
        return depth;
    }

    private static void handleArrayNulls(Object[] valuesArray, int length) {
        for (int i = 0; i < valuesArray.length; ++i) {
            if (valuesArray[i] != null) continue;
            valuesArray[i] = new Object[length];
        }
    }

    private static Object prestoNativeToJdbcObject(ConnectorSession session, Type prestoType, Object prestoNative) throws SQLException {
        if (prestoNative == null) {
            return null;
        }
        if (DoubleType.DOUBLE.equals((Object)prestoType) || BooleanType.BOOLEAN.equals((Object)prestoType) || BigintType.BIGINT.equals((Object)prestoType)) {
            return prestoNative;
        }
        if (prestoType instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)prestoType;
            if (decimalType.isShort()) {
                BigInteger unscaledValue = BigInteger.valueOf((Long)prestoNative);
                return new BigDecimal(unscaledValue, decimalType.getScale(), new MathContext(decimalType.getPrecision()));
            }
            BigInteger unscaledValue = Decimals.decodeUnscaledValue((Slice)((Slice)prestoNative));
            return new BigDecimal(unscaledValue, decimalType.getScale(), new MathContext(decimalType.getPrecision()));
        }
        if (RealType.REAL.equals((Object)prestoType)) {
            return Float.valueOf(Float.intBitsToFloat(Math.toIntExact((Long)prestoNative)));
        }
        if (TinyintType.TINYINT.equals((Object)prestoType)) {
            return SignedBytes.checkedCast((long)((Long)prestoNative));
        }
        if (SmallintType.SMALLINT.equals((Object)prestoType)) {
            return Shorts.checkedCast((long)((Long)prestoNative));
        }
        if (IntegerType.INTEGER.equals((Object)prestoType)) {
            return Math.toIntExact((Long)prestoNative);
        }
        if (DateType.DATE.equals((Object)prestoType)) {
            long millis = TimeUnit.DAYS.toMillis((Long)prestoNative);
            return new Date(DateTimeZone.UTC.getMillisKeepLocal(DateTimeZone.getDefault(), millis));
        }
        if (prestoType instanceof TimestampType && ((TimestampType)prestoType).isShort()) {
            TimestampType timestampType = (TimestampType)prestoType;
            return TypeUtils.toPgTimestamp(StandardColumnMappings.fromPrestoTimestamp((long)((Long)prestoNative)));
        }
        if (prestoType instanceof TimestampWithTimeZoneType) {
            int precision = ((TimestampWithTimeZoneType)prestoType).getPrecision();
            if (precision <= 3) {
                long millisUtc = DateTimeEncoding.unpackMillisUtc((long)((Long)prestoNative));
                return new Timestamp(millisUtc);
            }
            LongTimestampWithTimeZone value = (LongTimestampWithTimeZone)prestoNative;
            long epochSeconds = value.getEpochMillis() / 1000L;
            long nanosOfSecond = value.getEpochMillis() % 1000L * 1000000L + (long)(value.getPicosOfMilli() / 1000);
            return OffsetDateTime.ofInstant(Instant.ofEpochSecond(epochSeconds, nanosOfSecond), TimeZoneKey.UTC_KEY.getZoneId());
        }
        if (prestoType instanceof VarcharType || prestoType instanceof CharType) {
            return ((Slice)prestoNative).toStringUtf8();
        }
        if (prestoType instanceof ArrayType) {
            return TypeUtils.getJdbcObjectArray(session, ((ArrayType)prestoType).getElementType(), (Block)prestoNative);
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Unsupported type: " + prestoType);
    }

    static PGobject toPgTimestamp(LocalDateTime localDateTime) throws SQLException {
        PGobject pgObject = new PGobject();
        pgObject.setType("timestamp");
        pgObject.setValue(localDateTime.toString());
        return pgObject;
    }
}

