/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.resourcegroups;

import com.google.common.base.Throwables;
import com.google.inject.Injector;
import com.google.inject.Module;
import io.airlift.bootstrap.Bootstrap;
import io.airlift.json.JsonModule;
import io.prestosql.plugin.resourcegroups.FileResourceGroupConfigurationManager;
import io.prestosql.plugin.resourcegroups.FileResourceGroupsModule;
import io.prestosql.spi.memory.ClusterMemoryPoolManager;
import io.prestosql.spi.resourcegroups.ResourceGroupConfigurationManager;
import io.prestosql.spi.resourcegroups.ResourceGroupConfigurationManagerContext;
import io.prestosql.spi.resourcegroups.ResourceGroupConfigurationManagerFactory;
import java.util.Map;

public class FileResourceGroupConfigurationManagerFactory
implements ResourceGroupConfigurationManagerFactory {
    public String getName() {
        return "file";
    }

    public ResourceGroupConfigurationManager<?> create(Map<String, String> config, ResourceGroupConfigurationManagerContext context) {
        try {
            Bootstrap app = new Bootstrap(new Module[]{new JsonModule(), new FileResourceGroupsModule(), binder -> binder.bind(ClusterMemoryPoolManager.class).toInstance((Object)context.getMemoryPoolManager())});
            Injector injector = app.strictConfig().doNotInitializeLogging().setRequiredConfigurationProperties(config).initialize();
            return (ResourceGroupConfigurationManager)injector.getInstance(FileResourceGroupConfigurationManager.class);
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

