/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.resourcegroups.db;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigBinder;
import java.util.Map;
import org.weakref.jmx.ObjectNameBuilder;
import org.weakref.jmx.ObjectNameGenerator;

public class PrefixObjectNameGeneratorModule
implements Module {
    private static final String CONNECTOR_PACKAGE_NAME = "io.prestosql.plugin.resourcegroups.db";
    private static final String DEFAULT_DOMAIN_BASE = "presto.plugin.resourcegroups.db";

    public void configure(Binder binder) {
        ConfigBinder.configBinder((Binder)binder).bindConfig(PrefixObjectNameGeneratorConfig.class);
    }

    @Provides
    ObjectNameGenerator createPrefixObjectNameGenerator(PrefixObjectNameGeneratorConfig config) {
        String domainBase = DEFAULT_DOMAIN_BASE;
        if (config.getDomainBase() != null) {
            domainBase = config.getDomainBase();
        }
        return new PrefixObjectNameGenerator(domainBase);
    }

    public static final class PrefixObjectNameGenerator
    implements ObjectNameGenerator {
        private final String domainBase;

        public PrefixObjectNameGenerator(String domainBase) {
            this.domainBase = domainBase;
        }

        public String generatedNameOf(Class<?> type, Map<String, String> properties) {
            return new ObjectNameBuilder(this.toDomain(type)).withProperties(properties).build();
        }

        private String toDomain(Class<?> type) {
            String domain = type.getPackage().getName();
            if (domain.startsWith(PrefixObjectNameGeneratorModule.CONNECTOR_PACKAGE_NAME)) {
                domain = this.domainBase + domain.substring(PrefixObjectNameGeneratorModule.CONNECTOR_PACKAGE_NAME.length());
            }
            return domain;
        }
    }

    public static class PrefixObjectNameGeneratorConfig {
        private String domainBase;

        public String getDomainBase() {
            return this.domainBase;
        }

        @Config(value="jmx.base-name")
        public PrefixObjectNameGeneratorConfig setDomainBase(String domainBase) {
            this.domainBase = domainBase;
            return this;
        }
    }
}

