/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject.config.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.statement.SqlParser;
import org.jdbi.v3.core.statement.SqlStatements;
import org.jdbi.v3.sqlobject.config.Configurer;
import org.jdbi.v3.sqlobject.config.UseSqlParser;

public class UseSqlParserImpl
implements Configurer {
    @Override
    public void configureForMethod(ConfigRegistry registry, Annotation annotation, Class<?> sqlObjectType, Method method) {
        UseSqlParser anno = (UseSqlParser)annotation;
        SqlParser parser = this.instantiate(anno.value(), sqlObjectType, method);
        ((SqlStatements)registry.get(SqlStatements.class)).setSqlParser(parser);
    }

    @Override
    public void configureForType(ConfigRegistry registry, Annotation annotation, Class<?> sqlObjectType) {
        this.configureForMethod(registry, annotation, sqlObjectType, null);
    }

    private SqlParser instantiate(Class<? extends SqlParser> parserClass, Class<?> sqlObjectType, @Nullable Method method) {
        return Stream.of(UseSqlParserImpl.tryConstructor(parserClass, new Object[0]), UseSqlParserImpl.tryConstructor(parserClass, sqlObjectType), UseSqlParserImpl.tryConstructor(parserClass, sqlObjectType, method)).map(Supplier::get).filter(Objects::nonNull).findFirst().orElseThrow(() -> new IllegalStateException("Unable to instantiate, no viable constructor for " + parserClass.getName()));
    }

    private static <T extends SqlParser> Supplier<T> tryConstructor(Class<T> c, Object ... args) {
        Object[] nonNullArgs = Arrays.stream(args).filter(Objects::nonNull).toArray(Object[]::new);
        return () -> {
            try {
                Class[] classes = (Class[])Arrays.stream(nonNullArgs).map(Object::getClass).toArray(Class[]::new);
                return (SqlParser)c.getConstructor(classes).newInstance(nonNullArgs);
            }
            catch (NoSuchMethodException ignored) {
                return null;
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        };
    }
}

