/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.resourcegroups.db;

import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.units.Duration;
import io.airlift.units.MinDuration;
import java.util.concurrent.TimeUnit;

public class DbResourceGroupConfig {
    private String configUrl;
    private boolean exactMatchSelectorEnabled;
    private Duration maxRefreshInterval = new Duration(1.0, TimeUnit.HOURS);

    public String getConfigDbUrl() {
        return this.configUrl;
    }

    @Config(value="resource-groups.config-db-url")
    public DbResourceGroupConfig setConfigDbUrl(String configUrl) {
        this.configUrl = configUrl;
        return this;
    }

    @MinDuration(value="10s")
    public Duration getMaxRefreshInterval() {
        return this.maxRefreshInterval;
    }

    @Config(value="resource-groups.max-refresh-interval")
    @ConfigDescription(value="Time period for which the cluster will continue to accept queries after refresh failures cause configuration to become stale")
    public DbResourceGroupConfig setMaxRefreshInterval(Duration maxRefreshInterval) {
        this.maxRefreshInterval = maxRefreshInterval;
        return this;
    }

    public boolean getExactMatchSelectorEnabled() {
        return this.exactMatchSelectorEnabled;
    }

    @Config(value="resource-groups.exact-match-selector-enabled")
    public DbResourceGroupConfig setExactMatchSelectorEnabled(boolean exactMatchSelectorEnabled) {
        this.exactMatchSelectorEnabled = exactMatchSelectorEnabled;
        return this;
    }
}

