/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.resourcegroups.db;

import com.google.common.base.Throwables;
import com.google.inject.Injector;
import com.google.inject.Module;
import io.airlift.bootstrap.Bootstrap;
import io.airlift.json.JsonModule;
import io.prestosql.plugin.resourcegroups.db.DbResourceGroupConfigurationManager;
import io.prestosql.plugin.resourcegroups.db.DbResourceGroupsModule;
import io.prestosql.plugin.resourcegroups.db.ForEnvironment;
import io.prestosql.plugin.resourcegroups.db.PrefixObjectNameGeneratorModule;
import io.prestosql.spi.memory.ClusterMemoryPoolManager;
import io.prestosql.spi.resourcegroups.ResourceGroupConfigurationManager;
import io.prestosql.spi.resourcegroups.ResourceGroupConfigurationManagerContext;
import io.prestosql.spi.resourcegroups.ResourceGroupConfigurationManagerFactory;
import java.util.Map;

public class DbResourceGroupConfigurationManagerFactory
implements ResourceGroupConfigurationManagerFactory {
    public String getName() {
        return "db";
    }

    public ResourceGroupConfigurationManager<?> create(Map<String, String> config, ResourceGroupConfigurationManagerContext context) {
        try {
            Bootstrap app = new Bootstrap(new Module[]{new JsonModule(), new DbResourceGroupsModule(), new PrefixObjectNameGeneratorModule(), binder -> binder.bind(String.class).annotatedWith(ForEnvironment.class).toInstance((Object)context.getEnvironment()), binder -> binder.bind(ClusterMemoryPoolManager.class).toInstance((Object)context.getMemoryPoolManager())});
            Injector injector = app.strictConfig().doNotInitializeLogging().setRequiredConfigurationProperties(config).initialize();
            return (ResourceGroupConfigurationManager)injector.getInstance(DbResourceGroupConfigurationManager.class);
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

