/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject.statement.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.sql.SQLException;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.extension.HandleSupplier;
import org.jdbi.v3.core.mapper.RowMapper;
import org.jdbi.v3.core.result.RowReducer;
import org.jdbi.v3.core.statement.SqlStatement;
import org.jdbi.v3.core.statement.UnableToCreateStatementException;
import org.jdbi.v3.core.statement.UnableToExecuteStatementException;
import org.jdbi.v3.sqlobject.Handler;
import org.jdbi.v3.sqlobject.SqlObjects;
import org.jdbi.v3.sqlobject.customizer.SqlStatementCustomizer;
import org.jdbi.v3.sqlobject.customizer.SqlStatementCustomizerFactory;
import org.jdbi.v3.sqlobject.customizer.SqlStatementCustomizingAnnotation;
import org.jdbi.v3.sqlobject.statement.ParameterCustomizerFactory;
import org.jdbi.v3.sqlobject.statement.UseRowMapper;
import org.jdbi.v3.sqlobject.statement.UseRowReducer;
import org.jdbi.v3.sqlobject.statement.internal.SqlObjectStatementConfiguration;

abstract class CustomizingStatementHandler<StatementType extends SqlStatement<StatementType>>
implements Handler {
    private final List<BoundCustomizer> statementCustomizers;
    private final Class<?> sqlObjectType;
    private final Method method;

    CustomizingStatementHandler(Class<?> type, Method method) {
        this.sqlObjectType = type;
        this.method = method;
        Stream<BoundCustomizer> typeCustomizers = Stream.concat(Stream.of(type.getInterfaces()), Stream.of(type)).flatMap(xva$0 -> CustomizingStatementHandler.annotationsFor(xva$0)).map(a -> CustomizingStatementHandler.instantiateFactory(a).createForType((Annotation)a, type)).map(BoundCustomizer::of);
        Stream<BoundCustomizer> methodCustomizers = CustomizingStatementHandler.annotationsFor(method).map(a -> CustomizingStatementHandler.instantiateFactory(a).createForMethod((Annotation)a, type, method)).map(BoundCustomizer::of);
        Stream<BoundCustomizer> parameterCustomizers = this.parameterCustomizers(type, method);
        this.statementCustomizers = Stream.of(typeCustomizers, methodCustomizers, parameterCustomizers).reduce(Stream.empty(), Stream::concat).collect(Collectors.toList());
    }

    private static Stream<Annotation> annotationsFor(AnnotatedElement ... elements) {
        return Stream.of(elements).map(AnnotatedElement::getAnnotations).flatMap(Stream::of).filter(a -> a.annotationType().isAnnotationPresent(SqlStatementCustomizingAnnotation.class));
    }

    private Stream<BoundCustomizer> parameterCustomizers(Class<?> type, Method method) {
        Parameter[] parameters = method.getParameters();
        return IntStream.range(0, parameters.length).boxed().flatMap(i -> this.eachParameterCustomizers(type, method, parameters[i], (Integer)i));
    }

    private Stream<BoundCustomizer> eachParameterCustomizers(Class<?> type, Method method, Parameter parameter, Integer i) {
        List customizers = CustomizingStatementHandler.annotationsFor(parameter).map(a -> CustomizingStatementHandler.instantiateFactory(a).createForParameter((Annotation)a, type, method, parameter, i, this.getParameterType(parameter))).map(c -> (stmt, args) -> c.apply(stmt, args[i])).collect(Collectors.toList());
        if (!customizers.isEmpty()) {
            return customizers.stream();
        }
        if (parameter.getType() == Consumer.class) {
            if (method.getReturnType() != Void.TYPE) {
                throw new IllegalStateException("SQL Object methods with a Consumer parameter must have void return type.");
            }
            return Stream.empty();
        }
        return Stream.of(this.defaultParameterCustomizer(type, method, parameter, i));
    }

    private BoundCustomizer defaultParameterCustomizer(Class<?> type, Method method, Parameter parameter, Integer i) {
        return (stmt, args) -> CustomizingStatementHandler.getDefaultParameterCustomizerFactory(stmt).createForParameter(type, method, parameter, i, this.getParameterType(parameter)).apply(stmt, args[i]);
    }

    Type getParameterType(Parameter parameter) {
        return parameter.getParameterizedType();
    }

    private static ParameterCustomizerFactory getDefaultParameterCustomizerFactory(SqlStatement<?> stmt) {
        return ((SqlObjects)stmt.getConfig(SqlObjects.class)).getDefaultParameterCustomizerFactory();
    }

    private static SqlStatementCustomizerFactory instantiateFactory(Annotation annotation) {
        SqlStatementCustomizingAnnotation sca = annotation.annotationType().getAnnotation(SqlStatementCustomizingAnnotation.class);
        try {
            return sca.value().getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalStateException("unable to instantiate sql statement customizer factory", e);
        }
    }

    @Override
    public Object invoke(Object target, Object[] args, HandleSupplier hs) throws Exception {
        Handle h = hs.getHandle();
        String locatedSql = this.locateSql(h);
        StatementType stmt = this.createStatement(h, locatedSql);
        SqlObjectStatementConfiguration cfg = (SqlObjectStatementConfiguration)stmt.getConfig(SqlObjectStatementConfiguration.class);
        cfg.setArgs(args);
        this.configureReturner(stmt, cfg);
        this.applyCustomizers(stmt, args);
        return cfg.getReturner().get();
    }

    void applyCustomizers(StatementType stmt, Object[] args) {
        this.statementCustomizers.forEach(b -> {
            try {
                b.apply((SqlStatement<?>)stmt, args);
            }
            catch (SQLException e) {
                throw new UnableToExecuteStatementException((Exception)e, stmt.getContext());
            }
        });
    }

    abstract void configureReturner(StatementType var1, SqlObjectStatementConfiguration var2);

    abstract StatementType createStatement(Handle var1, String var2);

    String locateSql(Handle h) {
        return ((SqlObjects)h.getConfig(SqlObjects.class)).getSqlLocator().locate(this.sqlObjectType, this.method, h.getConfig());
    }

    Method getMethod() {
        return this.method;
    }

    static RowMapper<?> rowMapperFor(UseRowMapper annotation) {
        Class<RowMapper<?>> mapperClass = annotation.value();
        try {
            return mapperClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new UnableToCreateStatementException("Could not create mapper " + mapperClass.getName(), (Throwable)e, null);
        }
    }

    static RowReducer<?, ?> rowReducerFor(UseRowReducer annotation) {
        Class<RowReducer<?, ?>> reducerClass = annotation.value();
        try {
            return reducerClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new UnableToCreateStatementException("Could not create reducer " + reducerClass.getName(), (Throwable)e, null);
        }
    }

    private static interface BoundCustomizer {
        public void apply(SqlStatement<?> var1, Object[] var2) throws SQLException;

        public static BoundCustomizer of(SqlStatementCustomizer c) {
            return (stmt, args) -> c.apply(stmt);
        }
    }
}

