/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.guava.ser;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.WritableTypeId;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitable;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonObjectFormatVisitor;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.google.common.collect.BoundType;
import com.google.common.collect.Range;
import java.io.IOException;

public class RangeSerializer
extends StdSerializer<Range<?>>
implements ContextualSerializer {
    protected final JavaType _rangeType;
    protected final JsonSerializer<Object> _endpointSerializer;

    public RangeSerializer(JavaType type) {
        this(type, null);
    }

    public RangeSerializer(JavaType type, JsonSerializer<?> endpointSer) {
        super(type);
        this._rangeType = type;
        this._endpointSerializer = endpointSer;
    }

    @Deprecated
    public boolean isEmpty(Range<?> value) {
        return this.isEmpty((SerializerProvider)null, value);
    }

    public boolean isEmpty(SerializerProvider prov, Range<?> value) {
        return value.isEmpty();
    }

    public JsonSerializer<?> createContextual(SerializerProvider prov, BeanProperty property) throws JsonMappingException {
        JsonSerializer cs;
        if (this._endpointSerializer == null) {
            JavaType endpointType = this._rangeType.containedTypeOrUnknown(0);
            if (endpointType != null && !endpointType.hasRawClass(Object.class)) {
                JsonSerializer ser = prov.findValueSerializer(endpointType, property);
                return new RangeSerializer(this._rangeType, ser);
            }
        } else if (this._endpointSerializer instanceof ContextualSerializer && (cs = ((ContextualSerializer)this._endpointSerializer).createContextual(prov, property)) != this._endpointSerializer) {
            return new RangeSerializer(this._rangeType, cs);
        }
        return this;
    }

    public void serialize(Range<?> value, JsonGenerator gen, SerializerProvider provider) throws IOException, JsonGenerationException {
        gen.writeStartObject(value);
        this._writeContents(value, gen, provider);
        gen.writeEndObject();
    }

    public void serializeWithType(Range<?> value, JsonGenerator gen, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        gen.setCurrentValue(value);
        WritableTypeId typeIdDef = typeSer.writeTypePrefix(gen, typeSer.typeId(value, JsonToken.START_OBJECT));
        this._writeContents(value, gen, provider);
        typeSer.writeTypeSuffix(gen, typeIdDef);
    }

    private void _writeContents(Range<?> value, JsonGenerator g, SerializerProvider provider) throws IOException {
        if (value.hasLowerBound()) {
            if (this._endpointSerializer != null) {
                g.writeFieldName("lowerEndpoint");
                this._endpointSerializer.serialize((Object)value.lowerEndpoint(), g, provider);
            } else {
                provider.defaultSerializeField("lowerEndpoint", (Object)value.lowerEndpoint(), g);
            }
            g.writeStringField("lowerBoundType", value.lowerBoundType().name());
        }
        if (value.hasUpperBound()) {
            if (this._endpointSerializer != null) {
                g.writeFieldName("upperEndpoint");
                this._endpointSerializer.serialize((Object)value.upperEndpoint(), g, provider);
            } else {
                provider.defaultSerializeField("upperEndpoint", (Object)value.upperEndpoint(), g);
            }
            g.writeStringField("upperBoundType", value.upperBoundType().name());
        }
    }

    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        JsonObjectFormatVisitor objectVisitor;
        if (visitor != null && (objectVisitor = visitor.expectObjectFormat(typeHint)) != null && this._endpointSerializer != null) {
            JavaType endpointType = this._rangeType.containedType(0);
            JavaType btType = visitor.getProvider().constructType(BoundType.class);
            JsonSerializer btSer = visitor.getProvider().findValueSerializer(btType, null);
            objectVisitor.property("lowerEndpoint", this._endpointSerializer, endpointType);
            objectVisitor.property("lowerBoundType", (JsonFormatVisitable)btSer, btType);
            objectVisitor.property("upperEndpoint", this._endpointSerializer, endpointType);
            objectVisitor.property("upperBoundType", (JsonFormatVisitable)btSer, btType);
        }
    }
}

