/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.argument;

import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.URI;
import java.net.URL;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.UUID;
import org.jdbi.v3.core.argument.Argument;
import org.jdbi.v3.core.argument.ArgumentFactory;
import org.jdbi.v3.core.argument.Arguments;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.generic.GenericTypes;
import org.jdbi.v3.core.statement.StatementContext;

public class BuiltInArgumentFactory
implements ArgumentFactory {
    private static final ArgBuilder<String> STR_BUILDER = v -> new BuiltInArgument(String.class, 12, PreparedStatement::setString, v);
    private static final Map<Class<?>, ArgBuilder<?>> BUILDERS = BuiltInArgumentFactory.createInternalBuilders();
    public static final ArgumentFactory INSTANCE = new BuiltInArgumentFactory();

    private static <T> void register(Map<Class<?>, ArgBuilder<?>> map, Class<T> klass, int type, StatementBinder<T> binder) {
        BuiltInArgumentFactory.register(map, klass, v -> new BuiltInArgument(klass, type, binder, v));
    }

    private static <T> void register(Map<Class<?>, ArgBuilder<?>> map, Class<T> klass, ArgBuilder<T> builder) {
        map.put(klass, builder);
    }

    private static <T> StatementBinder<T> stringifyValue(StatementBinder<String> real) {
        return (p, i, v) -> real.bind(p, i, String.valueOf(v));
    }

    private static Map<Class<?>, ArgBuilder<?>> createInternalBuilders() {
        IdentityHashMap map = new IdentityHashMap();
        BuiltInArgumentFactory.register(map, BigDecimal.class, 2, PreparedStatement::setBigDecimal);
        BuiltInArgumentFactory.register(map, Blob.class, 2004, PreparedStatement::setBlob);
        BuiltInArgumentFactory.register(map, Boolean.class, 16, PreparedStatement::setBoolean);
        BuiltInArgumentFactory.register(map, Boolean.TYPE, 16, PreparedStatement::setBoolean);
        BuiltInArgumentFactory.register(map, Byte.class, -6, PreparedStatement::setByte);
        BuiltInArgumentFactory.register(map, Byte.TYPE, -6, PreparedStatement::setByte);
        BuiltInArgumentFactory.register(map, byte[].class, -3, PreparedStatement::setBytes);
        BuiltInArgumentFactory.register(map, Character.class, 1, BuiltInArgumentFactory.stringifyValue(PreparedStatement::setString));
        BuiltInArgumentFactory.register(map, Character.TYPE, 1, BuiltInArgumentFactory.stringifyValue(PreparedStatement::setString));
        BuiltInArgumentFactory.register(map, Clob.class, 2005, PreparedStatement::setClob);
        BuiltInArgumentFactory.register(map, Double.class, 8, PreparedStatement::setDouble);
        BuiltInArgumentFactory.register(map, Double.TYPE, 8, PreparedStatement::setDouble);
        BuiltInArgumentFactory.register(map, Float.class, 6, PreparedStatement::setFloat);
        BuiltInArgumentFactory.register(map, Float.TYPE, 6, PreparedStatement::setFloat);
        BuiltInArgumentFactory.register(map, Inet4Address.class, 1111, (p, i, v) -> p.setString(i, v.getHostAddress()));
        BuiltInArgumentFactory.register(map, Inet6Address.class, 1111, (p, i, v) -> p.setString(i, v.getHostAddress()));
        BuiltInArgumentFactory.register(map, Integer.class, 4, PreparedStatement::setInt);
        BuiltInArgumentFactory.register(map, Integer.TYPE, 4, PreparedStatement::setInt);
        BuiltInArgumentFactory.register(map, java.util.Date.class, 93, (p, i, v) -> p.setTimestamp(i, new Timestamp(v.getTime())));
        BuiltInArgumentFactory.register(map, Long.class, 4, PreparedStatement::setLong);
        BuiltInArgumentFactory.register(map, Long.TYPE, 4, PreparedStatement::setLong);
        BuiltInArgumentFactory.register(map, Short.class, 5, PreparedStatement::setShort);
        BuiltInArgumentFactory.register(map, Short.TYPE, 5, PreparedStatement::setShort);
        BuiltInArgumentFactory.register(map, Date.class, 91, PreparedStatement::setDate);
        BuiltInArgumentFactory.register(map, String.class, STR_BUILDER);
        BuiltInArgumentFactory.register(map, Time.class, 92, PreparedStatement::setTime);
        BuiltInArgumentFactory.register(map, Timestamp.class, 93, PreparedStatement::setTimestamp);
        BuiltInArgumentFactory.register(map, URL.class, 70, PreparedStatement::setURL);
        BuiltInArgumentFactory.register(map, URI.class, 12, BuiltInArgumentFactory.stringifyValue(PreparedStatement::setString));
        BuiltInArgumentFactory.register(map, UUID.class, 12, PreparedStatement::setObject);
        BuiltInArgumentFactory.register(map, Instant.class, 93, (p, i, v) -> p.setTimestamp(i, Timestamp.from(v)));
        BuiltInArgumentFactory.register(map, LocalDate.class, 91, (p, i, v) -> p.setDate(i, Date.valueOf(v)));
        BuiltInArgumentFactory.register(map, LocalDateTime.class, 93, (p, i, v) -> p.setTimestamp(i, Timestamp.valueOf(v)));
        BuiltInArgumentFactory.register(map, OffsetDateTime.class, 93, (p, i, v) -> p.setTimestamp(i, Timestamp.from(v.toInstant())));
        BuiltInArgumentFactory.register(map, ZonedDateTime.class, 93, (p, i, v) -> p.setTimestamp(i, Timestamp.from(v.toInstant())));
        BuiltInArgumentFactory.register(map, LocalTime.class, 92, (p, i, v) -> p.setTime(i, Time.valueOf(v)));
        BuiltInArgumentFactory.register(map, OptionalInt.class, 4, (p, i, v) -> {
            if (v.isPresent()) {
                p.setInt(i, v.getAsInt());
            } else {
                p.setNull(i, 4);
            }
        });
        BuiltInArgumentFactory.register(map, OptionalLong.class, -5, (p, i, v) -> {
            if (v.isPresent()) {
                p.setLong(i, v.getAsLong());
            } else {
                p.setNull(i, -5);
            }
        });
        BuiltInArgumentFactory.register(map, OptionalDouble.class, 8, (p, i, v) -> {
            if (v.isPresent()) {
                p.setDouble(i, v.getAsDouble());
            } else {
                p.setNull(i, 8);
            }
        });
        return Collections.unmodifiableMap(map);
    }

    @Override
    public Optional<Argument> build(Type expectedType, Object value, ConfigRegistry config) {
        ArgBuilder<?> v;
        Class<?> expectedClass = GenericTypes.getErasedType(expectedType);
        if (value != null && expectedClass == Object.class) {
            expectedClass = value.getClass();
        }
        if ((v = BUILDERS.get(expectedClass)) != null) {
            return Optional.of(v.build(value));
        }
        if (value instanceof Enum) {
            Enum enumValue = (Enum)value;
            return Optional.of(STR_BUILDER.build(enumValue.name()));
        }
        if (value instanceof Optional) {
            Object nestedValue = ((Optional)value).orElse(null);
            Type nestedType = this.findOptionalType(expectedType, nestedValue);
            return config.get(Arguments.class).findFor(nestedType, nestedValue);
        }
        return value == null ? Optional.of(config.get(Arguments.class).getUntypedNullArgument()) : Optional.empty();
    }

    private Type findOptionalType(Type wrapperType, Object nestedValue) {
        Optional<Type> nestedType;
        if (GenericTypes.getErasedType(wrapperType).equals(Optional.class) && (nestedType = GenericTypes.findGenericParameter(wrapperType, Optional.class)).isPresent()) {
            return nestedType.get();
        }
        return nestedValue == null ? Object.class : nestedValue.getClass();
    }

    static final class BuiltInArgument<T>
    implements Argument {
        private final T value;
        private final Class<T> klass;
        private final int type;
        private final StatementBinder<T> binder;

        private BuiltInArgument(Class<T> klass, int type, StatementBinder<T> binder, T value) {
            this.binder = binder;
            this.klass = klass;
            this.type = type;
            this.value = value;
        }

        @Override
        public void apply(int position, PreparedStatement statement, StatementContext ctx) throws SQLException {
            if (this.value == null) {
                statement.setNull(position, this.type);
                return;
            }
            this.binder.bind(statement, position, this.value);
        }

        public String toString() {
            if (this.klass.isArray()) {
                return String.format("{array of %s length %s}", this.klass.getComponentType(), Array.getLength(this.value));
            }
            return String.valueOf(this.value);
        }

        StatementBinder<T> getStatementBinder() {
            return this.binder;
        }
    }

    @FunctionalInterface
    static interface ArgBuilder<T> {
        public Argument build(T var1);
    }

    @FunctionalInterface
    static interface StatementBinder<T> {
        public void bind(PreparedStatement var1, int var2, T var3) throws SQLException;
    }
}

