/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.resourcegroups;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import io.prestosql.plugin.resourcegroups.ResourceGroupIdTemplate;
import io.prestosql.plugin.resourcegroups.SelectorResourceEstimate;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;

public class SelectorSpec {
    private final Optional<Pattern> userRegex;
    private final Optional<Pattern> sourceRegex;
    private final Optional<String> queryType;
    private final Optional<List<String>> clientTags;
    private final Optional<SelectorResourceEstimate> selectorResourceEstimate;
    private final ResourceGroupIdTemplate group;

    @JsonCreator
    public SelectorSpec(@JsonProperty(value="user") Optional<Pattern> userRegex, @JsonProperty(value="source") Optional<Pattern> sourceRegex, @JsonProperty(value="queryType") Optional<String> queryType, @JsonProperty(value="clientTags") Optional<List<String>> clientTags, @JsonProperty(value="selectorResourceEstimate") Optional<SelectorResourceEstimate> selectorResourceEstimate, @JsonProperty(value="group") ResourceGroupIdTemplate group) {
        this.userRegex = Objects.requireNonNull(userRegex, "userRegex is null");
        this.sourceRegex = Objects.requireNonNull(sourceRegex, "sourceRegex is null");
        this.queryType = Objects.requireNonNull(queryType, "queryType is null");
        this.clientTags = Objects.requireNonNull(clientTags, "clientTags is null");
        this.selectorResourceEstimate = Objects.requireNonNull(selectorResourceEstimate, "selectorResourceEstimate is null");
        this.group = Objects.requireNonNull(group, "group is null");
    }

    public Optional<Pattern> getUserRegex() {
        return this.userRegex;
    }

    public Optional<Pattern> getSourceRegex() {
        return this.sourceRegex;
    }

    public Optional<String> getQueryType() {
        return this.queryType;
    }

    public Optional<List<String>> getClientTags() {
        return this.clientTags;
    }

    public Optional<SelectorResourceEstimate> getResourceEstimate() {
        return this.selectorResourceEstimate;
    }

    public ResourceGroupIdTemplate getGroup() {
        return this.group;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof SelectorSpec)) {
            return false;
        }
        SelectorSpec that = (SelectorSpec)other;
        return this.group.equals(that.group) && this.userRegex.map(Pattern::pattern).equals(that.userRegex.map(Pattern::pattern)) && this.userRegex.map(Pattern::flags).equals(that.userRegex.map(Pattern::flags)) && this.sourceRegex.map(Pattern::pattern).equals(that.sourceRegex.map(Pattern::pattern)) && this.sourceRegex.map(Pattern::flags).equals(that.sourceRegex.map(Pattern::flags)) && this.queryType.equals(that.queryType) && this.clientTags.equals(that.clientTags);
    }

    public int hashCode() {
        return Objects.hash(this.group, this.userRegex.map(Pattern::pattern), this.userRegex.map(Pattern::flags), this.sourceRegex.map(Pattern::pattern), this.sourceRegex.map(Pattern::flags), this.queryType, this.clientTags);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("resourceGroup", (Object)this.group).add("userRegex", this.userRegex).add("userFlags", this.userRegex.map(Pattern::flags)).add("sourceRegex", this.sourceRegex).add("sourceFlags", this.sourceRegex.map(Pattern::flags)).add("queryType", this.queryType).add("clientTags", this.clientTags).toString();
    }
}

