/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.spi.block;

import io.airlift.slice.Slice;
import io.airlift.slice.SliceInput;
import io.airlift.slice.SliceOutput;
import io.airlift.slice.Slices;
import io.prestosql.spi.block.AbstractFixedWidthBlock;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockEncoding;
import io.prestosql.spi.block.BlockEncodingSerde;
import io.prestosql.spi.block.EncoderUtil;
import io.prestosql.spi.block.FixedWidthBlock;

public class FixedWidthBlockEncoding
implements BlockEncoding {
    public static final String NAME = "FIXED_WIDTH";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void writeBlock(BlockEncodingSerde blockEncodingSerde, SliceOutput sliceOutput, Block block) {
        AbstractFixedWidthBlock fixedWidthBlock = (AbstractFixedWidthBlock)block;
        sliceOutput.appendInt(fixedWidthBlock.getFixedSize());
        sliceOutput.appendInt(fixedWidthBlock.getPositionCount());
        EncoderUtil.encodeNullsAsBits(sliceOutput, fixedWidthBlock);
        Slice slice = fixedWidthBlock.getRawSlice();
        sliceOutput.appendInt(slice.length()).writeBytes(slice);
    }

    @Override
    public Block readBlock(BlockEncodingSerde blockEncodingSerde, SliceInput sliceInput) {
        int fixedSize = sliceInput.readInt();
        int positionCount = sliceInput.readInt();
        Slice valueIsNull = EncoderUtil.decodeNullBits(sliceInput, positionCount).map(Slices::wrappedBooleanArray).orElse(null);
        int blockSize = sliceInput.readInt();
        Slice slice = sliceInput.readSlice(blockSize);
        return new FixedWidthBlock(fixedSize, positionCount, slice, valueIsNull);
    }
}

