/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.spi.connector.classloader;

import io.prestosql.spi.classloader.ThreadContextClassLoader;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.connector.ConnectorPageSource;
import io.prestosql.spi.connector.ConnectorPageSourceProvider;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.connector.ConnectorSplit;
import io.prestosql.spi.connector.ConnectorTransactionHandle;
import java.util.List;
import java.util.Objects;

public class ClassLoaderSafeConnectorPageSourceProvider
implements ConnectorPageSourceProvider {
    private final ConnectorPageSourceProvider delegate;
    private final ClassLoader classLoader;

    public ClassLoaderSafeConnectorPageSourceProvider(ConnectorPageSourceProvider delegate, ClassLoader classLoader) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.classLoader = Objects.requireNonNull(classLoader, "classLoader is null");
    }

    @Override
    public ConnectorPageSource createPageSource(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorSplit split, List<ColumnHandle> columns) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            ConnectorPageSource connectorPageSource = this.delegate.createPageSource(transactionHandle, session, split, columns);
            return connectorPageSource;
        }
    }
}

