/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.spi.security;

import io.prestosql.spi.security.SelectedRole;
import java.security.Principal;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class ConnectorIdentity {
    private final String user;
    private final Optional<Principal> principal;
    private final Optional<SelectedRole> role;
    private final Map<String, String> extraCredentials;

    public ConnectorIdentity(String user, Optional<Principal> principal, Optional<SelectedRole> role) {
        this(user, principal, role, Collections.emptyMap());
    }

    public ConnectorIdentity(String user, Optional<Principal> principal, Optional<SelectedRole> role, Map<String, String> extraCredentials) {
        this.user = Objects.requireNonNull(user, "user is null");
        this.principal = Objects.requireNonNull(principal, "principal is null");
        this.role = Objects.requireNonNull(role, "role is null");
        this.extraCredentials = Collections.unmodifiableMap(new HashMap<String, String>(Objects.requireNonNull(extraCredentials, "extraCredentials is null")));
    }

    public String getUser() {
        return this.user;
    }

    public Optional<Principal> getPrincipal() {
        return this.principal;
    }

    public Optional<SelectedRole> getRole() {
        return this.role;
    }

    public Map<String, String> getExtraCredentials() {
        return this.extraCredentials;
    }

    public boolean equals(Object o) {
        throw new UnsupportedOperationException();
    }

    public int hashCode() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ConnectorIdentity{");
        sb.append("user='").append(this.user).append('\'');
        this.principal.ifPresent(principal -> sb.append(", principal=").append(principal));
        this.role.ifPresent(role -> sb.append(", role=").append(role));
        sb.append(", extraCredentials=").append(this.extraCredentials.keySet());
        sb.append('}');
        return sb.toString();
    }
}

