/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.spi.block;

import io.airlift.slice.SliceInput;
import io.airlift.slice.SliceOutput;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockEncoding;
import io.prestosql.spi.block.BlockEncodingSerde;
import io.prestosql.spi.block.EncoderUtil;
import io.prestosql.spi.block.Int96ArrayBlock;

public class Int96ArrayBlockEncoding
implements BlockEncoding {
    public static final String NAME = "INT96_ARRAY";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void writeBlock(BlockEncodingSerde blockEncodingSerde, SliceOutput sliceOutput, Block block) {
        int positionCount = block.getPositionCount();
        sliceOutput.appendInt(positionCount);
        EncoderUtil.encodeNullsAsBits(sliceOutput, block);
        for (int position = 0; position < positionCount; ++position) {
            if (block.isNull(position)) continue;
            sliceOutput.writeLong(block.getLong(position, 0));
            sliceOutput.writeInt(block.getInt(position, 8));
        }
    }

    @Override
    public Block readBlock(BlockEncodingSerde blockEncodingSerde, SliceInput sliceInput) {
        int positionCount = sliceInput.readInt();
        boolean[] valueIsNull = EncoderUtil.decodeNullBits(sliceInput, positionCount).orElse(null);
        long[] high = new long[positionCount];
        int[] low = new int[positionCount];
        for (int position = 0; position < positionCount; ++position) {
            if (valueIsNull != null && valueIsNull[position]) continue;
            high[position] = sliceInput.readLong();
            low[position] = sliceInput.readInt();
        }
        return new Int96ArrayBlock(0, positionCount, valueIsNull, high, low);
    }
}

