/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.spi.connector;

import io.prestosql.spi.connector.SchemaRoutineName;
import java.util.Locale;
import java.util.Objects;

public final class CatalogSchemaRoutineName {
    private final String catalogName;
    private final SchemaRoutineName schemaRoutineName;

    public CatalogSchemaRoutineName(String catalogName, SchemaRoutineName schemaRoutineName) {
        this.catalogName = Objects.requireNonNull(catalogName, "catalogName is null").toLowerCase(Locale.ENGLISH);
        this.schemaRoutineName = Objects.requireNonNull(schemaRoutineName, "schemaRoutineName is null");
    }

    public CatalogSchemaRoutineName(String catalogName, String schemaName, String routineName) {
        this.catalogName = Objects.requireNonNull(catalogName, "catalogName is null");
        this.schemaRoutineName = new SchemaRoutineName(schemaName, routineName);
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public SchemaRoutineName getSchemaRoutineName() {
        return this.schemaRoutineName;
    }

    public String getSchemaName() {
        return this.schemaRoutineName.getSchemaName();
    }

    public String getRoutineName() {
        return this.schemaRoutineName.getRoutineName();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CatalogSchemaRoutineName that = (CatalogSchemaRoutineName)o;
        return Objects.equals(this.catalogName, that.catalogName) && Objects.equals(this.schemaRoutineName, that.schemaRoutineName);
    }

    public int hashCode() {
        return Objects.hash(this.catalogName, this.schemaRoutineName);
    }

    public String toString() {
        return this.catalogName + "." + this.schemaRoutineName;
    }
}

