/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.spi.type;

import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.block.BlockBuilderStatus;
import io.prestosql.spi.block.LongArrayBlockBuilder;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.type.SqlTimestamp;
import io.prestosql.spi.type.TimestampType;
import io.prestosql.spi.type.TimestampTypes;

class ShortTimestampType
extends TimestampType {
    public ShortTimestampType(int precision) {
        super(precision, Long.TYPE);
        if (precision < 0 || precision > 6) {
            throw new IllegalArgumentException(String.format("Precision must be in the range [0, %s]", 6));
        }
    }

    @Override
    public final int getFixedSize() {
        return 8;
    }

    @Override
    public final long getLong(Block block, int position) {
        return block.getLong(position, 0);
    }

    @Override
    public final void writeLong(BlockBuilder blockBuilder, long value) {
        blockBuilder.writeLong(value).closeEntry();
    }

    @Override
    public final void appendTo(Block block, int position, BlockBuilder blockBuilder) {
        if (block.isNull(position)) {
            blockBuilder.appendNull();
        } else {
            blockBuilder.writeLong(block.getLong(position, 0)).closeEntry();
        }
    }

    @Override
    public boolean equalTo(Block leftBlock, int leftPosition, Block rightBlock, int rightPosition) {
        long rightValue;
        long leftValue = leftBlock.getLong(leftPosition, 0);
        return leftValue == (rightValue = rightBlock.getLong(rightPosition, 0));
    }

    @Override
    public long hash(Block block, int position) {
        return TimestampTypes.hashShortTimestamp(block.getLong(position, 0));
    }

    @Override
    public int compareTo(Block leftBlock, int leftPosition, Block rightBlock, int rightPosition) {
        long leftValue = leftBlock.getLong(leftPosition, 0);
        long rightValue = rightBlock.getLong(rightPosition, 0);
        return Long.compare(leftValue, rightValue);
    }

    @Override
    public final BlockBuilder createBlockBuilder(BlockBuilderStatus blockBuilderStatus, int expectedEntries, int expectedBytesPerEntry) {
        int maxBlockSizeInBytes = blockBuilderStatus == null ? 0x100000 : blockBuilderStatus.getMaxPageSizeInBytes();
        return new LongArrayBlockBuilder(blockBuilderStatus, Math.min(expectedEntries, maxBlockSizeInBytes / 8));
    }

    @Override
    public final BlockBuilder createBlockBuilder(BlockBuilderStatus blockBuilderStatus, int expectedEntries) {
        return this.createBlockBuilder(blockBuilderStatus, expectedEntries, 8);
    }

    @Override
    public final BlockBuilder createFixedSizeBlockBuilder(int positionCount) {
        return new LongArrayBlockBuilder(null, positionCount);
    }

    @Override
    public Object getObjectValue(ConnectorSession session, Block block, int position) {
        if (block.isNull(position)) {
            return null;
        }
        long value = block.getLong(position, 0);
        if (this.getPrecision() <= 3) {
            value = ShortTimestampType.scaleEpochMillisToMicros(value);
        }
        if (session.isLegacyTimestamp()) {
            return SqlTimestamp.newLegacyInstance(this.getPrecision(), value, 0, session.getTimeZoneKey());
        }
        return SqlTimestamp.newInstance(this.getPrecision(), value, 0);
    }

    private static long scaleEpochMillisToMicros(long epochMillis) {
        return Math.multiplyExact(epochMillis, 1000);
    }
}

