/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.spi.type;

import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.type.AbstractType;
import io.prestosql.spi.type.FixedWidthType;
import io.prestosql.spi.type.LongTimestampType;
import io.prestosql.spi.type.ShortTimestampType;
import io.prestosql.spi.type.TypeSignature;
import io.prestosql.spi.type.TypeSignatureParameter;

public abstract class TimestampType
extends AbstractType
implements FixedWidthType {
    public static final int MAX_PRECISION = 12;
    public static final int MAX_SHORT_PRECISION = 6;
    public static final int DEFAULT_PRECISION = 3;
    @Deprecated
    public static final TimestampType TIMESTAMP = new ShortTimestampType(3);
    private final int precision;

    public static TimestampType createTimestampType(int precision) {
        if (precision == 3) {
            return TIMESTAMP;
        }
        if (precision < 0 || precision > 12) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE, String.format("TIMESTAMP precision must be in range [0, %s]", 12));
        }
        if (precision <= 6) {
            return new ShortTimestampType(precision);
        }
        return new LongTimestampType(precision);
    }

    TimestampType(int precision, Class<?> javaType) {
        super(new TypeSignature("timestamp", TypeSignatureParameter.numericParameter(precision)), javaType);
        this.precision = precision;
    }

    public int getPrecision() {
        return this.precision;
    }

    public final boolean isShort() {
        return this.precision <= 6;
    }

    @Override
    public boolean isComparable() {
        return true;
    }

    @Override
    public boolean isOrderable() {
        return true;
    }
}

