/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.spi.type;

import io.airlift.slice.XxHash64;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.type.LongTimestamp;

public final class TimestampTypes {
    private TimestampTypes() {
    }

    public static long hashShortTimestamp(long value) {
        return Long.rotateLeft(value * -4417276706812531889L, 31) * -7046029288634856825L;
    }

    public static long hashLongTimestamp(LongTimestamp value) {
        return TimestampTypes.hashLongTimestamp(value.getEpochMicros(), value.getPicosOfMicro());
    }

    static long hashLongTimestamp(long epochMicros, long fraction) {
        return XxHash64.hash((long)epochMicros) ^ XxHash64.hash((long)fraction);
    }

    public static void writeLongTimestamp(BlockBuilder blockBuilder, LongTimestamp timestamp) {
        TimestampTypes.writeLongTimestamp(blockBuilder, timestamp.getEpochMicros(), timestamp.getPicosOfMicro());
    }

    public static void writeLongTimestamp(BlockBuilder blockBuilder, long epochMicros, int fraction) {
        blockBuilder.writeLong(epochMicros);
        blockBuilder.writeInt(fraction);
        blockBuilder.closeEntry();
    }
}

