/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.spi.type;

import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.type.AbstractType;
import io.prestosql.spi.type.FixedWidthType;
import io.prestosql.spi.type.LongTimestampWithTimeZoneType;
import io.prestosql.spi.type.ShortTimestampWithTimeZoneType;
import io.prestosql.spi.type.TypeSignature;
import io.prestosql.spi.type.TypeSignatureParameter;

public abstract class TimestampWithTimeZoneType
extends AbstractType
implements FixedWidthType {
    public static final int MAX_PRECISION = 12;
    public static final int MAX_SHORT_PRECISION = 3;
    public static final int DEFAULT_PRECISION = 3;
    @Deprecated
    public static final TimestampWithTimeZoneType TIMESTAMP_WITH_TIME_ZONE = new ShortTimestampWithTimeZoneType(3);
    private final int precision;

    public static TimestampWithTimeZoneType createTimestampWithTimeZoneType(int precision) {
        if (precision == 3) {
            return TIMESTAMP_WITH_TIME_ZONE;
        }
        if (precision <= 3) {
            return new ShortTimestampWithTimeZoneType(precision);
        }
        if (precision <= 12) {
            return new LongTimestampWithTimeZoneType(precision);
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE, String.format("TIMESTAMP WITH TIME ZONE precision must be in range [0, %s]", 12));
    }

    TimestampWithTimeZoneType(int precision, Class<?> javaType) {
        super(new TypeSignature("timestamp with time zone", TypeSignatureParameter.numericParameter(precision)), javaType);
        if (precision < 0 || precision > 12) {
            throw new IllegalArgumentException(String.format("Precision must be in the range [0, %s]", 12));
        }
        this.precision = precision;
    }

    public final int getPrecision() {
        return this.precision;
    }

    public final boolean isShort() {
        return this.precision <= 3;
    }

    @Override
    public final boolean isComparable() {
        return true;
    }

    @Override
    public final boolean isOrderable() {
        return true;
    }
}

