/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.sqlserver;

import com.microsoft.sqlserver.jdbc.SQLServerDriver;
import io.prestosql.plugin.jdbc.BaseJdbcClient;
import io.prestosql.plugin.jdbc.BaseJdbcConfig;
import io.prestosql.plugin.jdbc.ConnectionFactory;
import io.prestosql.plugin.jdbc.DriverConnectionFactory;
import io.prestosql.plugin.jdbc.JdbcErrorCode;
import io.prestosql.plugin.jdbc.JdbcIdentity;
import io.prestosql.plugin.jdbc.JdbcOutputTableHandle;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import javax.inject.Inject;

public class SqlServerClient
extends BaseJdbcClient {
    @Inject
    public SqlServerClient(BaseJdbcConfig config) {
        super(config, "\"", (ConnectionFactory)new DriverConnectionFactory((Driver)new SQLServerDriver(), config));
    }

    public void commitCreateTable(JdbcIdentity identity, JdbcOutputTableHandle handle) {
        String sql = String.format("sp_rename %s, %s", SqlServerClient.singleQuote(handle.getCatalogName(), handle.getSchemaName(), handle.getTemporaryTableName()), SqlServerClient.singleQuote(handle.getTableName()));
        try (Connection connection = this.getConnection(identity, handle);){
            this.execute(connection, sql);
        }
        catch (SQLException e) {
            throw new PrestoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
        }
    }

    private static String singleQuote(String catalog, String schema, String table) {
        return SqlServerClient.singleQuote(catalog + "." + schema + "." + table);
    }

    private static String singleQuote(String literal) {
        return "'" + literal + "'";
    }
}

